<?php
/**
 * @version $Id: cred.php 33126 2015-10-01 19:01:51Z astarostin $
 * ------------------------------------------------------------------------------
 * part of interface for credentials manegment
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$user = new User();

// check special credentials
$scUsers = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "u");
$scAccess = $user->checkObjectCredentials($_SESSION[SESSION_USERID], Obj::CONTROL_PANEL, "U");
?>

<div id="credentialManager" class="tabs">
	<script>
		var scUsers = <?=$scUsers ? "true" : "false";?>;
		var scAccess = <?=$scAccess ? "true" : "false";?>;
	</script>
	<div class="tabs_menu">
		<div class="single_tab">
			<div class="tab_text">
				<?php print __("Credential manager");?>
			</div>
		</div>
	</div>
	<div class="tabs_content">
		<div class="credentialManager_content">

			<div id="password_editor">
				<div class="tabs_menu_header"><input type="button" class="password_editor_close" value="X"></div>
				<div class="content">
					<div class="tabs">
						<div class="tabs_menu">
							<div class="single_tab">
								<div class="tab_text">
									<?php print __("Change password");?>
								</div>
							</div>
						</div>
						<div class="tabs_content">
						</div>
						<div class="tabs_footer"></div>
					</div>
				</div>
			</div>

			<div id="editor">
				<div class="tabs_menu_header"><input type="button" class="editor_close" value="X"></div>
				<div class="content"></div>
			</div>
			<div class="credentialManagerBlock">
				<div id="users" class="objectListWrapper">
					<div class="listWithControlsWrapper">
						<div class="caption"><?=__("Users");?></div>
						<select class="objectList" multiple="true">
						</select>
						<div class="controls">
							<input type="button" class="add" value="<?=__("Add");?>"/>
							<input type="button" class="delete" value="<?=__("Delete");?>"/>
							<input type="button" class="edit" value="<?=__("Edit");?>"/>
							<input type="button" class="edit_password" value="<?=__("Password");?>"/>
						</div>
					</div>
					<div class="controls2">
						<input type="button" class="move" value="&#x2190;"/>
					</div>
				</div>
				<div id="roles" class="objectListWrapper">
					<div class="listWithControlsWrapper">
						<div class="caption"><?=__("Roles");?></div>
						<select class="objectList" multiple="true">
						</select>
						<div class="controls">
							<input type="button" class="add" value="<?=__("Add");?>"/>
							<input type="button" class="delete" value="<?=__("Delete");?>"/>
							<input type="button" class="edit" value="<?=__("Edit");?>"/>
						</div>
					</div>
					<div class="controls2">
						<input type="button" class="move" value="&#x2190;"/>
					</div>
				</div>
				<div id="sets" class="objectListWrapper">
					<div class="listWithControlsWrapper">
						<div class="caption"><?=__("Sets");?></div>
						<select class="objectList" multiple="true">
						</select>
						<div class="controls">
							<input type="button" class="add" value="<?=__("Add");?>"/>
							<input type="button" class="delete" value="<?=__("Delete");?>"/>
							<input type="button" class="edit" value="<?=__("Edit");?>"/>
							<span class="showSystemSets"><label><input type="checkbox"/> <?=__("system sets");?></label></span>
						</div>
					</div>
					<div class="controls2">
						<input type="button" class="move" value="&#x2190;"/>
					</div>
				</div>
				<div id="devices" class="objectListWrapper">
					<div class="listWithControlsWrapper">
						<div class="caption"><?=__("Devices");?></div>
						<img src="/sdi/admin/img/url.png" style="float: left;" title='Filter'>
						<input type="text" class="objectFilter" value=""/>
						<select class="objectList" multiple="true">
						</select>
						<div class="controls">
							<!--<input type="button" class="delete" value="-"/>-->
							<!--<input type="button" class="edit" value="E"/>-->
						</div>
					</div>
					<div class="controls2">
						<input type="button" class="move" value="&#x2190;"/>
					</div>
				</div>

				<div id="user2role" class="objectListWrapper">
					<div class="listWithControlsWrapper">
						<div class="caption"><?=__("Users(Roles) from(to) Role(User)");?></div>
						<select class="objectList" multiple="true">
						</select>
						<div class="controls">
							<input type="button" class="add" value="<?=__("Add");?>"/>
							<input type="button" class="delete" value="<?=__("Delete");?>"/>
							<input type="button" class="edit" value="<?=__("Edit");?>"/>
						</div>
					</div>
					<div class="controls2">
						<input type="button" class="move" value="&#x2192;"/>
					</div>
				</div>
				<div id="set2role" class="objectListWrapper">
					<div class="listWithControlsWrapper">
						<div class="caption"><?=__("Sets(Roles) from(to) Role(Set)");?></div>
						<select class="objectList" multiple="true">
						</select>
						<div class="controls">
							<input type="button" class="add" value="<?=__("Add");?>"/>
							<input type="button" class="delete" value="<?=__("Delete");?>"/>
							<input type="button" class="edit" value="<?=__("Edit");?>"/>
							<span class="permission"></span>
							<br />
							<span class="special_credentials">
								<label><input id="scEmailOnEvent" data-credential="I" type="checkbox"/> <?=__("email on event");?></label><br/>
								<label><input id="scUserRoleSet" data-credential="U" type="checkbox"/> <?=__("user/role/set management");?></label><br/>
								<label><input id="scUsers" data-credential="u" type="checkbox"/> <?=__("user management");?></label><br/>
								<label><input id="scFullDevice" data-credential="F" type="checkbox"/> <?=__("full device management");?></label><br/>
								<label><input id="scDeviceSettings" data-credential="f" type="checkbox"/> <?=__("device settings management");?></label><br/>
								<label><input id="scDevicePolicy" data-credential="R" type="checkbox"/> <?=__("device policy management");?></label><br/>
								<label><input id="scDeviceAnalytics" data-credential="E" type="checkbox"/> <?=__("camera analytics management");?></label>
							</span>
						</div>
					</div>
					<div class="controls2">
						<input type="button" class="move" value="&#x2192;"/>
					</div>
				</div>
				<div id="device2set" class="objectListWrapper">
					<div class="listWithControlsWrapper">
						<div class="caption"><?=__("Devices from Set");?></div>
						<img src="/sdi/admin/img/url.png" style="float: left;" title='Filter'>
						<input type="text" class="objectFilter" value=""/>
						<select class="objectList" multiple="true">
						</select>
						<div class="controls">
							<input type="button" class="add" value="<?=__("Add");?>"/>
							<input type="button" class="delete" value="<?=__("Delete");?>"/>
							<input type="button" class="edit" value="<?=__("Edit");?>"/>
						</div>
					</div>
					<div class="controls2">
						<input type="button" class="move" value="&#x2192;"/>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="tabs_footer"></div>
</div>
