<?php
/**
 * @version $Id: Node.php 20088 2010-09-11 21:36:41Z starostin $
 * ------------------------------------------------------------------------------
 * This class contains logic for Node
 * ------------------------------------------------------------------------------
 * @author Serge Tsybulsky
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Digital Signature');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/jquery.mask.js"></script>
	<script src="/sdi/lib/js/log.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="js/certificate.js"></script>
</head>
<body>
	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?php print __("Digital Signature");?>
				</div>
			</div>
		</div>


		<div id="certificate_content" class="tabs_content" style="padding:10px;">
			<div id="certificatemanage" class="columns">
				<p><?php echo __('You have to install Encryption Certificate to enable Media Export Signatures.');?></p>
				<p><?php echo __('The procedure is: ');?></p>
				<p><?php echo " 1. " . __('Create a Certificate Request with form in "Get new Request".');?></p>
				<p><?php echo " 2. " . __('Resulting Request should be sent to the Certification Authority.');?></p>
				<p><?php echo " 3. " . __('Install Certificate from Certification Authority.');?></p>
				<p><?php echo " 4. " . __('You will have to download and install Validation Utility from next links:');?></p>
				<ul>
					<li>
						<?php echo __('Validation Utility for Microsoft Windows:');?>
						<a href="/wheels/vCrypt/vCrypt.exe"style="color:blue;"> vCrypt.exe</a>
					</li>
					<li>
						<?php echo __('Validation Utility for MacOS:');?>
						<a href="/wheels/vCrypt/vCrypt.dmg"style="color:blue;"> vCrypt.dmg</a>
					</li>
				</ul>

				<br>
				<div id="nocertificate"><?php echo __('Certificate is not installed.');?></div>
				<div id="iscertificate">
					<p><b><?php echo __('Certificate info:');?></b></p>
					<div id='certificate_info_field'></div>
				</div>
				<br />
				<input type="button" value="<?php echo __('Show Request');?>" id="SHOW_REQUEST"style="width:20%"/>
				<input type="button" value="<?php echo __('Get new Request');?>" id="SHOW_REGISTRATION" style="width:20%"/>
				<input type="button" value="<?php echo __('Install Certificate');?>" id="SHOW_CERTIFICATE_INPUT" style="width:20%"/>
			</div>
			<div id="registration">
				<div class="help">
					<?php echo __('Please provide your (All fields mandatory!):');?>

					<br /><?php echo __('Server Common Name:');?>
					<br /><input type="text" value="" size="50" id="user_domain_field"/>
					<br /><?php echo __('Email address:');?>
					<br /><input type="text" value="" size="50" id="user_email_field"/>
					<br /><?php echo __('Country:');?>
					<br /><select size="1" id="user_country_field" style="width:300px;">
								<option value="AF"><?=__('AFGHANISTAN');?></option>
								<option value="AX"><?=__('ALAND ISLANDS');?></option>
								<option value="AL"><?=__('ALBANIA');?></option>
								<option value="DZ"><?=__('ALGERIA');?></option>
								<option value="AS"><?=__('AMERICAN SAMOA');?></option>
								<option value="AD"><?=__('ANDORRA');?></option>
								<option value="AO"><?=__('ANGOLA');?></option>
								<option value="AI"><?=__('ANGUILLA');?></option>
								<option value="AQ"><?=__('ANTARCTICA');?></option>
								<option value="AG"><?=__('ANTIGUA AND BARBUDA');?></option>
								<option value="AR"><?=__('ARGENTINA');?></option>
								<option value="AM"><?=__('ARMENIA');?></option>
								<option value="AW"><?=__('ARUBA');?></option>
								<option value="AU"><?=__('AUSTRALIA');?></option>
								<option value="AT"><?=__('AUSTRIA');?></option>
								<option value="AZ"><?=__('AZERBAIJAN');?></option>
								<option value="BS"><?=__('BAHAMAS');?></option>
								<option value="BH"><?=__('BAHRAIN');?></option>
								<option value="BD"><?=__('BANGLADESH');?></option>
								<option value="BB"><?=__('BARBADOS');?></option>
								<option value="BY"><?=__('BELARUS');?></option>
								<option value="BE"><?=__('BELGIUM');?></option>
								<option value="BZ"><?=__('BELIZE');?></option>
								<option value="BJ"><?=__('BENIN');?></option>
								<option value="BM"><?=__('BERMUDA');?></option>
								<option value="BT"><?=__('BHUTAN');?></option>
								<option value="BO"><?=__('BOLIVIA');?></option>
								<option value="BA"><?=__('BOSNIA AND HERZEGOVINA');?></option>
								<option value="BW"><?=__('BOTSWANA');?></option>
								<option value="BV"><?=__('BOUVET ISLAND');?></option>
								<option value="BR"><?=__('BRAZIL');?></option>
								<option value="IO"><?=__('BRITISH INDIAN OCEAN TERRITORY');?></option>
								<option value="BN"><?=__('BRUNEI DARUSSALAM');?></option>
								<option value="BG"><?=__('BULGARIA');?></option>
								<option value="BF"><?=__('BURKINA FASO');?></option>
								<option value="BI"><?=__('BURUNDI');?></option>
								<option value="KH"><?=__('CAMBODIA');?></option>
								<option value="CM"><?=__('CAMEROON');?></option>
								<option value="CA"><?=__('CANADA');?></option>
								<option value="CV"><?=__('CAPE VERDE');?></option>
								<option value="KY"><?=__('CAYMAN ISLANDS');?></option>
								<option value="CF"><?=__('CENTRAL AFRICAN REPUBLIC');?></option>
								<option value="TD"><?=__('CHAD (Tchad)');?></option>
								<option value="CL"><?=__('CHILE');?></option>
								<option value="CN"><?=__('CHINA');?></option>
								<option value="CX"><?=__('CHRISTMAS ISLAND');?></option>
								<option value="CC"><?=__('COCOS (KEELING) ISLANDS');?></option>
								<option value="CO"><?=__('COLOMBIA');?></option>
								<option value="KM"><?=__('COMOROS');?></option>
								<option value="CG"><?=__('CONGO, REPUBLIC OF');?></option>
								<option value="CD"><?=__('CONGO, THE DEMOCRATIC REPUBLIC OF THE (formerly Zaire)');?></option>
								<option value="CK"><?=__('COOK ISLANDS');?></option>
								<option value="CR"><?=__('COSTA RICA');?></option>
								<option value="HR"><?=__('CROATIA');?></option>
								<option value="CU"><?=__('CUBA');?></option>
								<option value="CY"><?=__('CYPRUS');?></option>
								<option value="CZ"><?=__('CZECH REPUBLIC');?></option>
								<option value="DK"><?=__('DENMARK');?></option>
								<option value="DJ"><?=__('DJIBOUTI');?></option>
								<option value="DM"><?=__('DOMINICA');?></option>
								<option value="DO"><?=__('DOMINICAN REPUBLIC');?></option>
								<option value="EC"><?=__('ECUADOR');?></option>
								<option value="EG"><?=__('EGYPT');?></option>
								<option value="SV"><?=__('EL SALVADOR');?></option>
								<option value="GQ"><?=__('EQUATORIAL GUINEA');?></option>
								<option value="ER"><?=__('ERITREA');?></option>
								<option value="EE"><?=__('ESTONIA');?></option>
								<option value="ET"><?=__('ETHIOPIA');?></option>
								<option value="FO"><?=__('FAEROE ISLANDS');?></option>
								<option value="FK"><?=__('FALKLAND ISLANDS (MALVINAS)');?></option>
								<option value="FJ"><?=__('FIJI');?></option>
								<option value="FI"><?=__('FINLAND');?></option>
								<option value="FR"><?=__('FRANCE');?></option>
								<option value="GF"><?=__('FRENCH GUIANA');?></option>
								<option value="PF"><?=__('FRENCH POLYNESIA');?></option>
								<option value="TF"><?=__('FRENCH SOUTHERN TERRITORIES');?></option>
								<option value="GA"><?=__('GABON');?></option>
								<option value="GM"><?=__('GAMBIA');?></option>
								<option value="GE"><?=__('GEORGIA');?></option>
								<option value="DE"><?=__('GERMANY');?></option>
								<option value="GH"><?=__('GHANA');?></option>
								<option value="GI"><?=__('GIBRALTAR');?></option>
								<option value="GB"><?=__('GREAT BRITAIN');?></option>
								<option value="GR"><?=__('GREECE');?></option>
								<option value="GL"><?=__('GREENLAND');?></option>
								<option value="GD"><?=__('GRENADA');?></option>
								<option value="GP"><?=__('GUADELOUPE');?></option>
								<option value="GU"><?=__('GUAM');?></option>
								<option value="GT"><?=__('GUATEMALA');?></option>
								<option value="GG"><?=__('GUERNSEY');?></option>
								<option value="GN"><?=__('GUINEA');?></option>
								<option value="GW"><?=__('GUINEA-BISSAU');?></option>
								<option value="GY"><?=__('GUYANA');?></option>
								<option value="HT"><?=__('HAITI');?></option>
								<option value="HM"><?=__('HEARD ISLAND AND MCDONALD ISLANDS');?></option>
								<option value="HN"><?=__('HONDURAS');?></option>
								<option value="HK"><?=__('HONG KONG (Special Administrative Region of China)');?></option>
								<option value="HU"><?=__('HUNGARY');?></option>
								<option value="IS"><?=__('ICELAND');?></option>
								<option value="IN"><?=__('INDIA');?></option>
								<option value="ID"><?=__('INDONESIA');?></option>
								<option value="IR"><?=__('IRAN (Islamic Republic of Iran)');?></option>
								<option value="IQ"><?=__('IRAQ');?></option>
								<option value="IE"><?=__('IRELAND');?></option>
								<option value="IM"><?=__('ISLE OF MAN');?></option>
								<option value="IL"><?=__('ISRAEL');?></option>
								<option value="IT"><?=__('ITALY');?></option>
								<option value="JM"><?=__('JAMAICA');?></option>
								<option value="JP"><?=__('JAPAN');?></option>
								<option value="JE"><?=__('JERSEY');?></option>
								<option value="JO"><?=__('JORDAN (Hashemite Kingdom of Jordan)');?></option>
								<option value="KZ"><?=__('KAZAKHSTAN');?></option>
								<option value="KE"><?=__('KENYA');?></option>
								<option value="KI"><?=__('KIRIBATI');?></option>
								<option value="KP"><?=__('KOREA (Democratic Peoples Republic of [North] Korea)');?></option>
								<option value="KR"><?=__('KOREA (Republic of [South] Korea)');?></option>
								<option value="KW"><?=__('KUWAIT');?></option>
								<option value="KG"><?=__('KYRGYZSTAN');?></option>
								<option value="LA"><?=__('LAO PEOPLES DEMOCRATIC REPUBLIC');?></option>
								<option value="LV"><?=__('LATVIA');?></option>
								<option value="LB"><?=__('LEBANON');?></option>
								<option value="LS"><?=__('LESOTHO');?></option>
								<option value="LR"><?=__('LIBERIA');?></option>
								<option value="LY"><?=__('LIBYA (Libyan Arab Jamahirya)');?></option>
								<option value="LI"><?=__('LIECHTENSTEIN (Furstentum Liechtenstein)');?></option>
								<option value="LT"><?=__('LITHUANIA');?></option>
								<option value="LU"><?=__('LUXEMBOURG');?></option>
								<option value="MO"><?=__('MACAO (Special Administrative Region of China)');?></option>
								<option value="MK"><?=__('MACEDONIA (Former Yugoslav Republic of Macedonia)');?></option>
								<option value="MG"><?=__('MADAGASCAR');?></option>
								<option value="MW"><?=__('MALAWI');?></option>
								<option value="MY"><?=__('MALAYSIA');?></option>
								<option value="MV"><?=__('MALDIVES');?></option>
								<option value="ML"><?=__('MALI');?></option>
								<option value="MT"><?=__('MALTA');?></option>
								<option value="MH"><?=__('MARSHALL ISLANDS');?></option>
								<option value="MQ"><?=__('MARTINIQUE');?></option>
								<option value="MR"><?=__('MAURITANIA');?></option>
								<option value="MU"><?=__('MAURITIUS');?></option>
								<option value="YT"><?=__('MAYOTTE');?></option>
								<option value="MX"><?=__('MEXICO');?></option>
								<option value="FM"><?=__('MICRONESIA (Federated States of Micronesia)');?></option>
								<option value="MD"><?=__('MOLDOVA');?></option>
								<option value="MC"><?=__('MONACO');?></option>
								<option value="MN"><?=__('MONGOLIA');?></option>
								<option value="ME"><?=__('MONTENEGRO');?></option>
								<option value="MS"><?=__('MONTSERRAT');?></option>
								<option value="MA"><?=__('MOROCCO');?></option>
								<option value="MZ"><?=__('MOZAMBIQUE');?></option>
								<option value="MM"><?=__('MYANMAR');?></option>
								<option value="NA"><?=__('NAMIBIA');?></option>
								<option value="NR"><?=__('NAURU');?></option>
								<option value="NP"><?=__('NEPAL');?></option>
								<option value="NL"><?=__('NETHERLANDS');?></option>
								<option value="AN"><?=__('NETHERLANDS ANTILLES');?></option>
								<option value="NC"><?=__('NEW CALEDONIA');?></option>
								<option value="NZ"><?=__('NEW ZEALAND');?></option>
								<option value="NI"><?=__('NICARAGUA');?></option>
								<option value="NE"><?=__('NIGER');?></option>
								<option value="NG"><?=__('NIGERIA');?></option>
								<option value="NU"><?=__('NIUE');?></option>
								<option value="NF"><?=__('NORFOLK ISLAND');?></option>
								<option value="MP"><?=__('NORTHERN MARIANA ISLANDS');?></option>
								<option value="NO"><?=__('NORWAY');?></option>
								<option value="OM"><?=__('OMAN');?></option>
								<option value="PK"><?=__('PAKISTAN');?></option>
								<option value="PW"><?=__('PALAU');?></option>
								<option value="PS"><?=__('PALESTINIAN TERRITORIES');?></option>
								<option value="PA"><?=__('PANAMA');?></option>
								<option value="PG"><?=__('PAPUA NEW GUINEA');?></option>
								<option value="PY"><?=__('PARAGUAY');?></option>
								<option value="PE"><?=__('PERU');?></option>
								<option value="PH"><?=__('PHILIPPINES');?></option>
								<option value="PN"><?=__('PITCAIRN');?></option>
								<option value="PL"><?=__('POLAND');?></option>
								<option value="PT"><?=__('PORTUGAL');?></option>
								<option value="PR"><?=__('PUERTO RICO');?></option>
								<option value="QA"><?=__('QATAR');?></option>
								<option value="RE"><?=__('REUNION');?></option>
								<option value="RO"><?=__('ROMANIA');?></option>
								<option value="RU"><?=__('RUSSIAN FEDERATION');?></option>
								<option value="RW"><?=__('RWANDA');?></option>
								<option value="BL"><?=__('SAINT BARTHELEMY');?></option>
								<option value="SH"><?=__('SAINT HELENA');?></option>
								<option value="KN"><?=__('SAINT KITTS AND NEVIS');?></option>
								<option value="LC"><?=__('SAINT LUCIA');?></option>
								<option value="MF"><?=__('SAINT MARTIN (French portion)');?></option>
								<option value="PM"><?=__('SAINT PIERRE AND MIQUELON');?></option>
								<option value="VC"><?=__('SAINT VINCENT AND THE GRENADINES');?></option>
								<option value="WS"><?=__('SAMOA (formerly Western Samoa)');?></option>
								<option value="SM"><?=__('SAN MARINO (Republic of)');?></option>
								<option value="ST"><?=__('SAO TOME AND PRINCIPE');?></option>
								<option value="SA"><?=__('SAUDI ARABIA (Kingdom of Saudi Arabia)');?></option>
								<option value="SN"><?=__('SENEGAL');?></option>
								<option value="RS"><?=__('SERBIA (Republic of Serbia)');?></option>
								<option value="SC"><?=__('SEYCHELLES');?></option>
								<option value="SL"><?=__('SIERRA LEONE');?></option>
								<option value="SG"><?=__('SINGAPORE');?></option>
								<option value="SK"><?=__('SLOVAKIA (Slovak Republic)');?></option>
								<option value="SI"><?=__('SLOVENIA');?></option>
								<option value="SB"><?=__('SOLOMON ISLANDS');?></option>
								<option value="SO"><?=__('SOMALIA');?></option>
								<option value="ZA"><?=__('SOUTH AFRICA (Zuid Afrika)');?></option>
								<option value="GS"><?=__('SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS');?></option>
								<option value="ES"><?=__('SPAIN');?></option>
								<option value="LK"><?=__('SRI LANKA (formerly Ceylon)');?></option>
								<option value="SD"><?=__('SUDAN');?></option>
								<option value="SR"><?=__('SURINAME');?></option>
								<option value="SJ"><?=__('SVALBARD AND JAN MAYEN');?></option>
								<option value="SZ"><?=__('SWAZILAND');?></option>
								<option value="SE"><?=__('SWEDEN');?></option>
								<option value="CH"><?=__('SWITZERLAND (Confederation of Helvetia)');?></option>
								<option value="SY"><?=__('SYRIAN ARAB REPUBLIC');?></option>
								<option value="TW"><?=__('TAIWAN ("Chinese Taipei" for IOC)');?></option>
								<option value="TJ"><?=__('TAJIKISTAN');?></option>
								<option value="TZ"><?=__('TANZANIA');?></option>
								<option value="TH"><?=__('THAILAND');?></option>
								<option value="TL"><?=__('TIMOR-LESTE (formerly East Timor)');?></option>
								<option value="TG"><?=__('TOGO');?></option>
								<option value="TK"><?=__('TOKELAU');?></option>
								<option value="TO"><?=__('TONGA');?></option>
								<option value="TT"><?=__('TRINIDAD AND TOBAGO');?></option>
								<option value="TN"><?=__('TUNISIA');?></option>
								<option value="TR"><?=__('TURKEY');?></option>
								<option value="TM"><?=__('TURKMENISTAN');?></option>
								<option value="TC"><?=__('TURKS AND CAICOS ISLANDS');?></option>
								<option value="TV"><?=__('TUVALU');?></option>
								<option value="UG"><?=__('UGANDA');?></option>
								<option value="UA"><?=__('UKRAINE');?></option>
								<option value="AE"><?=__('UNITED ARAB EMIRATES');?></option>
								<option value="GB"><?=__('UNITED KINGDOM (Great Britain)');?></option>
								<option value="US"><?=__('UNITED STATES');?></option>
								<option value="UM"><?=__('UNITED STATES MINOR OUTLYING ISLANDS');?></option>
								<option value="UY"><?=__('URUGUAY');?></option>
								<option value="UZ"><?=__('UZBEKISTAN');?></option>
								<option value="VU"><?=__('VANUATU');?></option>
								<option value="VA"><?=__('VATICAN CITY (Holy See)');?></option>
								<option value="VE"><?=__('VENEZUELA');?></option>
								<option value="VN"><?=__('VIET NAM');?></option>
								<option value="VG"><?=__('VIRGIN ISLANDS, BRITISH');?></option>
								<option value="VI"><?=__('VIRGIN ISLANDS, U.S.');?></option>
								<option value="WF"><?=__('WALLIS AND FUTUNA');?></option>
								<option value="EH"><?=__('WESTERN SAHARA (formerly Spanish Sahara)');?></option>
								<option value="YE"><?=__('YEMEN (Yemen Arab Republic)');?></option>
								<option value="ZM"><?=__('ZAMBIA (formerly Northern Rhodesia)');?></option>
								<option value="ZW"><?=__('ZIMBABWE');?></option>
							</select>
					<br /><?php echo __('State, province:');?>
					<br /><input type="text" value="" size="50" id="user_state_or_province_field"/>
					<br /><?php echo __('Locality Name (eg, city):');?>
					<br /><input type="text" value="" size="50" id="user_localityName_field"/>
					<br /><?php echo __('Organization (eg. company):');?>
					<br /><input type="text" value="" size="50" id="user_organization_field"/>
					<br /><?php echo __('Organizational Unit Name (eg, section):');?>
					<br /><input type="text" value="" size="50" id="user_organizationalUnitName_field"/>
					<br />
					<br/>
					<input type="button" value="<?php echo __('Confirm');?>" id="REQUEST_CONFIRM" style="width:20%"/>
					<input type="button" value="<?php echo __('Back');?>" name="BACK_BUTTON" style="width:20%"/>
				</div>
			</div>
			<div id="certificate_install" style='display:block;'>
				<div class="help">
					<p><?php echo __('Please input your certificate');?></p>
						<textarea id='certificate_field' cols=90 rows=20></textarea>
					</p>
					<br/><br/>
					<input type="button" value="<?php echo __('Install');?>" id="INSTALL_CERTIFICATE" style="width:20%"/>
					<input type="button" value="<?php echo __('Back');?>" name="BACK_BUTTON" style="width:20%"/>
				</div>
			</div>
			<div id="request_info" style='display:block;'>
					<p><?php echo __('Your certificate request');?></p>
					<textarea id='certificate_request_field' cols=90 rows=20></textarea>
				<br/><br/>
				<input type="button" id="OK_BUTTON" value="<?php echo __('Ok');?>" style="width:20%; display:none;"/>
				<input type="button" value="<?php echo __('Back');?>" name="BACK_BUTTON" style="width:20%"/>
			</div>
		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
