<?php
/**
 * @version $Id: index.php 23385 2011-08-15 17:45:43Z stsibulskiy $
 * ------------------------------------------------------------------------------
 * Manual license installation
 * ------------------------------------------------------------------------------
 * @author John Doe
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$ok = false;
$SERIAL_NO = Identity::getAttribute("SERIAL_NO");

$de = va_de();
$dt = '';

if ($de)
{
	$ok = true;

	// Extract year, month and day from value
	$dt = date("m/d/Y", va_de());
}

?>
<!DOCTYPE html>
<html>
<head>
	<TITLE>videoNEXT surveillance</TITLE>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/jquery-ajaxfileupload.js"></script>
	<script src="/sdi/lib/js/log.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="js/about_script.js"></script>
</head>
<body>
	<div class="tabs" id="manual_registration" style="display:none">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
				<?=__("Manual Registration");?>

				</div>
			</div>
		</div>
		<div class="tabs_content">
		  	<table width="100%" border="0" cellpadding="5" cellspacing="0">
            		    <tr>
            			<td>
                		    <div align="center">
                    			<p><?=__("You don't have an internet connection to the license server. Therefore, you must manually make the licensing process.");?></p>
                		    </div>
				    <div align="center">
                			<blockquote>
							<?php if (!$SERIAL_NO) { ?>
								<h3><span id="sserial"><?php echo __("Serial Number"); ?></span>
								<input id="input_serial" type="text" class="textfield" value="<?php echo $SERIAL_NO; ?>">&nbsp;&nbsp;&nbsp;
								<input id="save_serial" class="button" type="button" value="<?php echo __("Save");?>"></h3>
							<?php } else { ?>
								<h3><span id="sserial"><?php echo __("Serial Number") . " " . $SERIAL_NO; ?></span></h3>
							<?php } ?>
                        		    <input id="install_license" class="button_long" type="button" value="<?php echo __("Install license");?>"></h3>
					</blockquote>
                		    </div>
				</td>
			    </tr>
        		</table>
		</div>

		<div class="tabs_footer"></div>
	</div>


	<div class="tabs" id="no_serial_number" style="display:none">
	    <div class="tabs_menu">
		<div class="single_tab">
    		    <div class="tab_text"></div>
                </div>
            </div>
            <div class="tabs_content">
        	<h3 align="center"><?php echo __("Serial number is absent");?></h3>
        	<p align="center">Please set serial number on <a href="/sdi/about/manual_licensing.php"><?php echo __("Manual Registration");?></a> page first. </p>
                <div style="height: 1px;"></div>
            </div>
            <div class="tabs_footer"></div>
        </div>


        <div class="tabs" id="license_installation" style="display:none">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?php echo __("Current License Expires on"); ?> <?php echo $dt; ?>
				</div>
			</div>
		</div>
		<div class="tabs_content">
			<div style="margin-left:15px;">
				<div style="height: 1px;"></div>
				<p align="left"><?php echo __('If you obtained a new license, please upload it using control down below(click "Browse", select a file and then click "Upload").'); ?></p>
				<p align="left"><?php echo __("To obtain a license:");?>:</p>
				<ol>
				<li><?php echo __("You need to download this");?> <a style="color: #111199;" href="/sdi/about/getpcid.php">[pcid.bin file]</a></li>
				<li><?php echo __("Submit it to license activation page here"); ?>: <a style="color: #111199; " href="http://licenses.videonext.com/SLM/upload_pcid.php">[link]</a></li>
				<li><?php echo __("You will be given License File, which you have to download and save on your workstations and upload using control down below");?>:</li>
				</ol>
				<br/>
				<table width="440" border="0" cellpadding="5" cellspacing="0">
				  <tr>
					<td>
					<input id="license_file" name="license_file" type="file" onclick='doEnabledUpploadButton();'>
					<input id="button_upload_license" type="button" value="<?php echo ("Upload");?>" disabled="true">
					</td>
				  </tr>
				</table>
			</div>
		</div>
		<div class="tabs_footer"></div>
	</div>

	<div class="tabs" id="eula_block" style="display:none; width:720px">
	    <div class="tabs_menu">
		<div class="single_tab">
    		    <div class="tab_text"></div>
                </div>
            </div>
            <div class="tabs_content" align="center">
        		<div style="text-align: center; height: 470px; width: 690px;" id="license_frame">
				<iframe width="690" scrolling="auto" height="450" align="left" style="border: 2px groove #aaa;" src="/common/sla.htm"></iframe>
			</div>
            </div>
            <div style="background-color: #676767; clear:both; text-align:center; overflow:hidden; width:100%">
			<span style="padding-right: 30px"> <input type="button" id="eula_notagree" value="<?php echo __("I do NOT Agree"); ?>"> </span>
			<span> <input type="button" id="eula_agree" value="<?php echo __("I Agree"); ?>"> </span>
	    </div>
	    <div class="tabs_footer"></div>
        </div>

</body>

</html>
