/*
#------------------------------------------------------------------------------
# License management
#------------------------------------------------------------------------------
# Author: Alexey Tsibulnik
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2011
#-----------------------------------------------------------------------------
*/
	$(document).ready(
		function()
		{
			addEvents();
			$("#install_license").trigger("click");
		}
	);


	function addEvents()
	{
		$("#save_serial").click(
			function()
			{
				var serialno = $("#input_serial").val();

				$.ajax({
					type: "POST",
					url: "call.php",
					data: { 'function' : "saveSerial", 'serial' : serialno },
					dataType: "json",
					success: function(data)
					{
						var list = eval(data);
						if (list[0]["error"] != "")
						{
							Log.error(__("Error saving serial number") + "\n" + list[0]["error"]);
						}
					}
				});
			}
		);

		$("#install_license").click(
			function()
			{
				$.ajax({
					cache: false,
					url: "call.php",
					data: { 'function' : "getSerial" },
					dataType: "json",
					success: function(data)
					{
						var list = eval(data);
						if (list[0]["error"] != "")
						{
							Log.error(__("Cannot get serial number") + "\n" + list[0]["error"]);
						}
						else {
							var serialno = list[0]["serialno"];
							$("#manual_registration").hide();
							$("#eula_block").hide();
							if (serialno) {
							    $("#no_serial_number").hide();
							    $("#license_installation").show();
							}
							else {
							    $("#no_serial_number").show();
							    $("#license_installation").hide();
							}
						}
					}
				});
			}
		);

		$("#button_upload_license").click(
			function()
			{
				$("#manual_registration").hide();
				$("#no_serial_number").hide();
				$("#license_installation").hide();

				$("#eula_block").show();
			}
		);

		$("#eula_agree").click(
			function()
			{
				licenseFileUpload();
			}
		);

		$("#eula_notagree").click(
			function()
			{
				$("#manual_registration").hide();
				$("#no_serial_number").hide();
				$("#license_installation").show();
				$("#eula_block").hide();
			}
		);

	}

	function doEnabledUpploadButton()
	{
		$("#button_upload_license").prop("disabled", false);
	}

	function licenseFileUpload()
	{
		$.ajaxFileUpload(
			{
				url : 'uploadlicense.php',
				secureuri : false,
				fileElementId : 'license_file',
				dataType : 'json',
				success :	function(data, status)
							{
								if(typeof(data.error) != 'undefined')
								{
									if(data.error !== '')
									{
										alert(data.error);
									} else
									{
										var filename = data.filename;
										var filename_location = data.filename_location;
										installLicense(filename, filename_location);
									}
								}
							},
				error :		function(data, status, e)
							{
								alert(e);
							}
			}
		);
		return false;
	}

	function installLicense(filename, filename_location)
	{
		$.ajax({
			url: "call.php",
			dataType: "json",
			async: true,
			cache: false,
			data: {	'function' : 'installLicense',
				'filename' : filename,
				'filename_location' : filename_location },
			success: function(data)
			{
				var list = eval(data);
				if (list[0]["error"] != "")
				{
					alert(__('Error: License not uploaded. ') + list[0]["error"]);
				}
				else
				{
					if (list[0]["warning"] != "")
					{
						Log.warning(__('Warning: ') + list[0]["warning"]);
					}
					//insert code for refresh screen
					Log.info(__("The licence is successfully changed."));
					function fade()
					{
						var maskHeight = $(top.document).height();
						var maskWidth = $(top.window).width();

						$(top.document.getElementById("maskdiv")).css({'width':maskWidth,'height':maskHeight});
						$(top.document.getElementById("maskdiv")).fadeTo("fast",0.1);
					}

					fade();
					function doReload(){
						$(top.document.getElementById("maskdiv")).hide();
						top.location.reload();
					}
					top.setTimeout(
						doReload,
					2500);

				}
			}
		});
	}
