<?php
/**
 * @version $Id: downloadbackup.php 22408 2011-04-04 16:38:57Z teetov $
 * ------------------------------------------------------------------------------
 * Return file to user
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$user = new User();
if (!$user->isAdmin($_SESSION[SESSION_USERID]))
{
	exit("Not enough rights");
}

include("functions.php");

$pcid_path = $_SERVER["APL_VAR"] . "/license/pcid.bin";

if (!is_file($pcid_path))
{
	header('HTTP/1.0 404 Not Found');
	echo __("pcid.bin file not found\n");
	exit;
}

set_time_limit(0);
header('Cache-Control: private');
header('Content-Type: application/x-force-download; name="pcid.bin"');
header('Content-Disposition: attachment; filename="pcid.bin"');
header('Content-Transfer-Encoding: binary');
header('Accept-Ranges: bytes');

$range = 0;
$file = $pcid_path;
if (isset($_SERVER['HTTP_RANGE']) && ($range = $_SERVER['HTTP_RANGE']))
{
	$range = str_replace('bytes=', '', $range);
	$range = intval(str_replace('-', '', $range), 10);
	$size = filesize($file);

	header('HTTP/1.0 206 Partial Content');
	header('Content-Length: ' . ($size - $range));
	header('Content-Range: bytes ' . $range . '-' . ($size - 1) . '/' . $size);
} else {
	header('HTTP/1.0 200 OK');
	header('Content-Length: ' . filesize($file));
}

$file = fopen($file, 'rb');
fseek($file, (int) $range);

while (!feof($file) and !connection_status())
{
	echo fread($file, (1024 * 8));
	flush();
	ob_flush();
}
