<?php
/*
# $Id: functions.php 11677 2008-08-05 15:27:55Z starostin $
#------------------------------------------------------------------------------
# License manager
#------------------------------------------------------------------------------
# Author: Alexey Tsibulnik
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$license_dir = $_SERVER["APL_VAR"]."/license";

function getSerial()
{
	$list = array();
	$serialno = '';

	$resp = DB::select("SELECT val FROM _obj_attr WHERE obj=53 AND attr='SERIAL_NO'");
	if (count($resp) > 0) {
		$serialno = $resp[0]['val'];
	}

	$list[0]["serialno"] = $serialno;
	$list[0]["error"] = "";
	return $list;
}

function saveSerial($serialno)
{
    	$list = array();

	$resp = DB::query("UPDATE _obj_attr SET val=? WHERE obj=53 AND attr='SERIAL_NO'", array($serialno));

	$list[0]["error"] = "";
	return $list;
}

function installLicense($filename, $filename_location)
{
	$list = array();
	$error = "";
	$warning= "";
	$filename_location = escapeshellcmd($filename_location);

	global $license_dir;

	if (is_file($filename_location)) {
		$sign_ok = va_sign_ok($filename_location);
		if ($sign_ok) {
		    $license_content = file_get_contents($filename_location);
		    @unlink($filename_location);
		    $encoded_content = base64_encode($license_content);
		    Identity::setAttributes(array("LICENSE_KEY" => $encoded_content));
		    DB::query(
			"UPDATE _objs SET stime=now() AT TIME ZONE 'UTC' WHERE otype='D' and subtype='N' and deleted=0"
		    );
		}
		else {
		    $error = __("Sorry, file you are trying to upload is not a license file");
		    @unlink($filename_location);
		}
	}
	else {
		$error = __("Cannot find uploaded license file");
	}

	$list[0]["error"] = $error;
	$list[0]["warning"] = $warning;
	return $list;
}

?>
