DocumentRoot /opt/sarch/sdi/html/

AliasMatch ^/sdi/(?!vae)(.*)$ /opt/sarch/sdi/html/$1

# login screen
Alias /favicon.ico /opt/sarch/sdi/html/login/favicon.ico
Alias /robots.txt /opt/sarch/sdi/html/login/robots.txt
AliasMatch /index.html?$ /opt/sarch/sdi/html/login/index.html

<Location /sdi/login/ev.php>
    php_flag zlib.output_compression Off
    php_flag implicit_flush On
    php_flag output_buffering 0
</Location>

<Directory /opt/sarch/sdi/html>
    AllowOverride None
    # SymLinksIfOwnerMatch due to RewriteRule
    Options -ExecCGI -FollowSymLinks +SymLinksIfOwnerMatch -MultiViews -Indexes -IncludesNOEXEC
    Require all granted
    <IfModule mod_rewrite.c>
        RewriteEngine On
        RewriteBase /sdi/
        RewriteRule ^admin/js/([^/]*)/(([^/]*)/)?validate\.js$ /sdi/admin/js/validate.php?type=$1&model=$2 [L]
        RewriteRule ^elpr/([0-9]+)$ elpr/index.php?id=$1
    </IfModule>
</Directory>

<IfModule mod_php5.c>
    php_value upload_max_filesize 600M
    php_value post_max_size 600M
	LimitRequestBody 600000000
</IfModule>
