<?php
/**
 * @version $Id: template.php 26714 2012-09-05 14:52:33Z teetov $
 * ------------------------------------------------------------------------------
 * Interface template
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('Template title');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<!--[if lt IE 9]>
	    <script src="/sdi/lib/js/html5.js"></script>
	<![endif]-->
	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/api/scripts/Gettext.js"></script>
	<script src="/api/scripts/i18n.js"></script>
	<script src="js/template_script.js"></script>
	<script>
		$(function(){
			$("#go").click(function(){
				var obj = $("#obj").val();

				var command = "";

				var hfov = $("#hfov").val();
				if (hfov != "")
				{
					command = "<PTZ_Command>do.ptz?dev=" + obj + "&mode=abs&hfov=" + hfov + "</PTZ_Command>";
					send(command);
				}

				var pan = $("#angle").val();
				var tilt = $("#tilt").val();
				if (pan != "" && tilt != "")
				{
					command = "<PTZ_Command>do.ptz?dev=" + obj + "&mode=abs&pt=" + pan + "," + tilt + "</PTZ_Command>";
					send(command);
				}
			});
		});

		function send(command)
		{
			$.ajax({
				url: '/ptz/cgi-bin/send_message.pl',
				data: {
					'data': command
				},
				success: function(data, status, request)
				{
				}
			});
		}
	</script>
	<style>
		label {
			display: block;
		}
		input[type="text"] {
			display: block;
		}
	</style>
</head>
<body>
	<label>Obj<input id="obj" type="text"/></label>
	<label>Pan<input id="pan" type="text"/></label>
	<label>Tilt<input id="tilt" type="text"/></label>
	<label>HFOV<input id="hfov" type="text"/></label>
	<input id="go" type="button" value="Go"/>
</body>
</html>
