<?php
/**
 * @version $Id: ptzCalibrator.php 31894 2015-03-09 14:49:38Z atsybulnik $
 * ------------------------------------------------------------------------------
 * Interface template
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2013
 * ------------------------------------------------------------------------------
 */
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

$obj = 0;
if (!empty($_GET["obj"]))
{
	$obj = Purifier::clean($_GET["obj"]);
}
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo /* i18n: Page tittle */ __('PTZ Calibrator');?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<link href="/sdi/global/global.css" rel="stylesheet" type="text/css"/>
	<link href="style.css" rel="stylesheet" type="text/css"/>

	<script src="/sdi/lib/js/require.js"></script>
	<script>
		require(["ptzcalibrator"], function(){
			var PTZCalibrator = require("ptzcalibrator");
			var ptzCalibrator;
			$(document).ready(function(){
				ptzCalibrator = new PTZCalibrator();
				ptzCalibrator.init(<?=$obj?>);
			});
		});
	</script>
</head>
<body>
	<div class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?php print __("PTZ Calibrator");?>
				</div>
			</div>
		</div>
		<div class="tabs_content">
			<div class="buttons">
				<button class="back">Back</button>
				<button class="cancel">Cancel</button>
				<button class="apply">Apply</button>
			</div>
			<div class="players">
				<div id="player1" class="player">
					<p>Click, to create new point</p>
					<div class="video"></div>
					<input class="timestamp" readonly="true"/>
					<div class="click"></div>
					<div class="pointList">
						<fieldset>
							<legend>Point list</legend>
							<div>
								<button class="remove">Remove</button>
								<button class="apply">Apply position</button>
							</div>
							<select class="list" multiple="multiple"></select>
						</fieldset>
						<fieldset>
							<legend>Limit</legend>
							<div class="limitList">
								<input class="pan_limit" readonly="true"/>
								<input class="tilt_limit" readonly="true"/>
								<input class="hfov_limit" readonly="true"/>
							</div>
						</fieldset>
					</div>
				</div>
				<div id="player2" class="player">
					<p>Position to selected point</p>
					<div class="video"></div>
					<input class="timestamp" readonly="true"/>
					<div class="click"></div>
					<div class="playerPTZControls">
						<label>
							Step
							<select class="ptz_step">
								<option value="0.25">0.25</option>
								<option value="1">1</option>
								<option value="5" selected="selected">5</option>
								<option value="10">10</option>
								<option value="20">20</option>
							</select>
						</label>
						<fieldset>
							<legend>Camera move</legend>
							<div class="controls">
								<button class="ptz_left">&#x2190;</button>
								<button class="ptz_top">&#x2191;</button>
								<button class="ptz_bottom">&#x2193;</button>
								<button class="ptz_right">&#x2192;</button>
							</div>
							<div class="move_pan_tilt">
								<div><label>Pan (degree)<input class="pan" type="text" value="0"/></label></div>
								<div><label>Tilt (degree)<input class="tilt" type="text" value="0"/></label></div>
								<div><button class="move">Move</button></div>
							</div>
						</fieldset>
						<fieldset>
							<legend>Camera zoom</legend>
							<div class="controls">
								<button class="ptz_zoom_in">+</button>
								<button class="ptz_zoom_out">-</button>
							</div>
							<div class="move_fov">
								<div><label>HFOV <input class="hfov" type="text" value="0"/></label></div>
								<div><button class="move">Zoom</button></div>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
