	/**
 * @version $Id: hwjCalibrator.js 33597 2016-02-16 16:00:29Z astarostin $
 * ------------------------------------------------------------------------------
 * Script adds and redeclares some methods of HWJoystick object from hwj.js
 * New methods provide joystick calibrator functionality
 * ------------------------------------------------------------------------------
 * @author Sergey Koloney
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 *
 */

define("hwjCalibrator", ["hwj", "jquery", "jquery.mask", "i18n", "log", "api", "utils"], function(){
	"use strict";

	var HWJoystick = window.HWJoystick;

	$(document).ready(function() {
		$("#waitindicator")
			.show()
			.mask();

		HWJoystick.onLoad = function(success)
		{
			if (success)
			{
				Log.info("Joystick created");
				HWJoystick.createCalibrator("hwjCalibrator") && Log.info("Calibrator created");
			} else {
				Log.error("No joystick found");
			}

			$("#waitindicator")
				.hide()
				.unmask();
		};
		HWJoystick.init()
			.fail(function(){
				Log.error("Hardware joystick plugin not installed");
			});
	});

	// Add blinking on axis and buttons
	HWJoystick.onAxis = function(axis, data)
	{
		console.log(axis, data);
		if (HWJoystick.hwjCalibratorId)
		{
			HWJoystick.blink($("#" + HWJoystick.hwjCalibratorId + " .axis_" + axis));
		}

		if (data !== undefined)
		{
			$("#" + HWJoystick.hwjCalibratorId + " .axis_" + axis + "_value").text(data);
		}
	};

	HWJoystick.onButton = function (button)
	{
		if (HWJoystick.hwjCalibratorId)
		{
			HWJoystick.blink($("#" + HWJoystick.hwjCalibratorId + " .button_" + button));
		}
	};

	/**
	 * Blink on axis or button element
	 */
	HWJoystick.blink = function(element)
	{
		if (!element.data('blink'))
		{
			element.data('blink', true);
			element.css("background-color", "#FF0000");
			setTimeout(
				function()
				{
					element.css("background-color", "");
					element.data('blink', false);
				},
				100
			);
		}
	};

	/**
	 * Send command for applet to start deadzone calibration
	 *
	 * @param {Boolean} needSave
	 */
	HWJoystick.startDeadZoneCalibrate = function(needSave)
	{
		// TODO: turn on dead zone calibration
		/*
		if (HWJoystick.hwj)
		{
			Log.warning(__("DeadZone calibrating started, please, don't move joystick for 5 seconds"));
			HWJoystick.hwj.startDeadZoneCalibrate();
		}
		*/

		if (needSave)
		{
			// set flag that settings must be saved after calibration finish
			HWJoystick.needSave = 1;
		}

		HWJoystick.onEndDeadZoneCalibrate({});
	};

	/**
	 * Receive deadzone info from applet and save it to the commands preset
	 */
	HWJoystick.onEndDeadZoneCalibrate = function(data)
	{
		// TODO: turn on dead zone calibration
		/*
		// gather information about deadzone
		HWJoystick.commandPreset.deadzone = {};

		data = $.parseJSON(data);

		if (data.axis)
		{
			for (var name in data.axis)
			{
				if (!data.axis.hasOwnProperty(name))
					continue;

				// If "sensitivity" axis, don't set deadzone for it
				if (HWJoystick.commandPreset.axis[name] && HWJoystick.commandPreset.axis[name].indexOf("sensitivity") != -1)
					continue;
				HWJoystick.commandPreset.axis.deadzone[name] = data.axis[name];
			}
		}

		Log.info(__("Complete calibrating DeadZone"));
		HWJoystick.setDeadZone(HWJoystick.commandPreset.deadzone);
		HWJoystick.startWaitEvents();
		*/
		if (HWJoystick.needSave)
		{
			HWJoystick.saveCommandPresets();
		}
	};

	/**
	 * Save command presets into database
	 */
	HWJoystick.saveCommandPresets = function()
	{
		var info = HWJoystick.getInfo();
		HWJoystick.commandPresets[info.name] = HWJoystick.commandPreset;

		var attributes = {
			JOYSTICK_PRESETS: HWJoystick.commandPresets
		};

		var api = new API();
		api.setIdentityAttributes({
			attributes: JSON.stringify(attributes)
		})
			.fail(function(code, message){
				Log.error("[" + code + "] " + __(message));
			})
			.done(function(){
				Log.info(__("Joystick scheme is saved"));
			});

		// If calibrator was called from matrix, apply changes to matrix HWJoystick
		if (window.opener && window.opener.parent && window.opener.parent.HWJoystick)
		{
			if (HWJoystick.isDebug) {
				console.log('parent window HWJoystick found, set command preset');
			}
			window.opener.parent.HWJoystick.setCommandPreset(HWJoystick.commandPreset);
		}
	};

	/**
	 * Create calibrator in div#id
	 */
	HWJoystick.createCalibrator = function(id)
	{
		var yAxisSelector = [
			'<select>',
				'<option value="tilt">'  + __("Y") + '</option>',
				'<option value="-tilt">' + __("Reversed Y") + '</option>',
			'</select>'
		].join('');

		var povAxisSelector = [

		].join('');

		// Selector for axis
		var axisSelector = [
			'<select>',
				'<option value=""></option>',
				'<option value="sensitivity">'       + __("Sensitivity")          + '</option>',
				'<option value="-sensitivity">'      + __("Reversed sensitivity") + '</option>',
				'<option value="mode=speed&zoom=">'  + __("Zoom")                 + '</option>',
				'<option value="mode=speed&zoom=-">' + __("Reversed zoom")        + '</option>',
			'</select>'
		].join('');

		// Selector for buttons
		var buttonsSelector = [
			'<select>',
				'<option value=""></option>',
				'<option value="preset">' + __("Preset") + '</option>',
				'<option value="mode=step&zoom=in">'  + __("Zoom in")  + '</option>',
				'<option value="mode=step&zoom=out">' + __("Zoom out") + '</option>',
				'<option value="mode=step&iris=open">'  + __("Iris open")  + '</option>',
				'<option value="mode=step&iris=close">' + __("Iris close") + '</option>',
				'<option value="mode=step&focus=near">' + __("Focus near") + '</option>',
				'<option value="mode=step&focus=far">'  + __("Focus far")  + '</option>',
				'<option value="mode=step&gain=up">'    + __("Gain up")    + '</option>',
				'<option value="mode=step&gain=down">'  + __("Gain down")  + '</option>',
				'<option value="command">' + __("Command") + '</option>',
			'</select>'
		].join('');

		var found = id && HWJoystick.hwj;
		if (found)
		{
			HWJoystick.hwjCalibratorId = id;

			var info = HWJoystick.getInfo();
			if ($.isEmptyObject(info))
			{
				found = false;
			} else {
				var axis = info.axis;
				var button = info.button;
				var hwjCalibratorHTML = [];

				hwjCalibratorHTML.push('<div class="name">' + Gettext.strargs(__("Joystick name: %1"), [info.name]) + '</div>');
				// hwjCalibratorHTML.push('<div class="calibrateDeadZone">' + __("Calibrate DeadZone") + '</div>');

				hwjCalibratorHTML.push('<br><table>');

				var i, name;

				// create list of axis
				hwjCalibratorHTML.push('<tr><td colspan="2" align="center">' + __("Axis") + '</td><td></td></tr>');
				for (i = 0; i < axis; i++)
				{
					name = i;

					var selector = axisSelector;
					if (name === 0) selector = '&nbsp;';
					if (name === 1) selector = yAxisSelector;
					//if (!axis[i].isAnalog) selector = povAxisSelector;

					hwjCalibratorHTML.push(
						'<tr id="axis_' + name +'">' +
							'<td class="axis_' + name + '">' + name + '</td>' +
							'<td>' + selector + '</td>' +
							'<td class="axis_' + name + '_value"></td>' +
						'</tr>'
					);
				}

				// create list of buttons
				hwjCalibratorHTML.push('<tr><td colspan="2" align="center">' + __("Buttons") + '</td></tr>');
				for (i = 0; i < button; i++)
				{
					name = i;
					var row = [
						'<tr id="button_' + name +'">',
							'<td class="button_' + name + '">' + name + '</td>',
							'<td id="button_' + name + '_selector">' + buttonsSelector + '</td>',
							'<td id="button_' + name + '_preset" class="preset_value"><input type="text" value=""/></td>',
							'<td id="button_' + name + '_command" class="preset_value"><input type="text" value=""/></td>',
						'</tr>'
					];
					hwjCalibratorHTML.push(row.join(''));
				}
				hwjCalibratorHTML.push('</table>');

				if (!HWJoystick.commandPresets[info.name])
				{
					hwjCalibratorHTML.push(__("There was no command presets for your joystick. Default scheme used.") + '<br>');
				}
				hwjCalibratorHTML.push('<button id="save_commands">' + __("Save") + '</button>');

				$("#" + id).html(hwjCalibratorHTML.join(''));

				// Set values to selectors in calibrator
				for (var control in HWJoystick.commandPreset)
				{
					if (control == "deadzone")
						continue;

					for (var name in HWJoystick.commandPreset[control])
					{
						var command = HWJoystick.commandPreset[control][name];
						if (command == "")
							continue;

						if (control == "button")
						{
							$('#' + control + "_" + name + '_command input').val(command);

							var match;
							if (match = command.match(/mode=preset&goto=(\d+)/))
							{
								$('#' + control + "_" + name + '_selector select').val("preset");
								$('#' + control + "_" + name + '_preset input').val(match[1]);
								$('#' + control + "_" + name + '_preset').show();
							} else
							if (match = command.match(/mode=step&(zoom|iris|focus|gain)=/) && $('#' + control + "_" + name + '_selector select option[value="' + command + '"]').length > 0)
							{
								$('#' + control + "_" + name + '_selector select').val(command);
							} else {
								$('#' + control + "_" + name + '_selector select').val("command");
								$('#' + control + "_" + name + '_command').show();
							}
						} else
						if (control == "axis")
						{
							$('#' + control + "_" + name + ' select').val(command);
						}
					}
				}

				// Set onchange handlers to selectors
				$('#' + id + ' select').change(function() {
					var id = $(this).parent().parent().attr('id');

					var match = id.match(/^(.+)_(.+)$/);
					var control = match[1];
					var name = match[2];

					if (this.value.match(/preset/))
					{
						$("#" + id + "_command").hide();
						$("#" + id + "_preset").show();

						var number = parseInt($("#" + id + "_preset input").val(), 10);
						if (!isNaN(number))
							HWJoystick.commandPreset[control][name] = "mode=preset&goto=" + number;
					} else
					if (this.value.match(/command/))
					{
						$("#" + id + "_command").show();
						$("#" + id + "_preset").hide();

						HWJoystick.commandPreset[control][name] = $("#" + id + "_command input").val();
					} else {
						$("#" + id + "_command").hide();
						$("#" + id + "_preset").hide();

						HWJoystick.commandPreset[control][name] = this.value;
					}
				});

				$('#' + id + ' input').keyup(function() {
					var id = $(this).parent().parent().attr('id');

					var match = id.match(/^(.+)_(.+)$/);
					var control = match[1];
					var name = match[2];

					var selectValue = $('#' + id + ' select').val();

					if (selectValue.match(/preset/))
					{
						if (!this.value.match(/^\d+$/))
						{
							this.value = "";
						} else
						if(this.value == 95)
						{
							this.value = "";
							alert("Preset 95 not available!");
						} else {
							var number = parseInt($("#" + id + "_preset input").val(), 10);
							if (!isNaN(number))
							{
								HWJoystick.commandPreset[control][name] = "mode=preset&goto=" + number;
							}
						}
					} else
					if (selectValue.match(/command/))
					{
						HWJoystick.commandPreset[control][name] = $("#" + id + "_command input").val();
					}
				});

				$('#save_commands').click(function() {HWJoystick.startDeadZoneCalibrate(1)});

				return true;
			}
		}

		if (!found)
		{
			HWJoystick.destroy();
			$("#" + id).html(__("Cannot find joystick in your system"));
		}

		return false;
	};

});
