<?php
header("Content-type: text/xml");
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
require_once $_SERVER['APL'] . '/api/lib/php/check_login.php';
?>

<!--?xml version="1.0"?-->
<!--MRTI-->
<!--This XML document describes which controls are applicable to particular camera-->
<camera_controls>
    <settings>
        <window_size width="225" height="585" />
    </settings>

    <tab id="tab_settings" label="<?php echo __("SETTINGS");?>">
	<_width>75</_width>
	<label id="settings_ir" visible="1">
		<text><?php echo __("IR Settings");?></text>
		<_x>10</_x>
		<_y>10</_y>
            <color>0x2C293A</color>
            <fontSize>16</fontSize>
        </label>
        <group id="grp_turb" label="<?php echo __("Turbulence");?>">
            <_x>10</_x>
            <_y>50</_y>
            <group_element id="grp_turb_off">
                <Label><?php echo __("Off");?></Label>
                <ActionURL>mode=settings&amp;turbulence=off</ActionURL>
            </group_element>
            <group_element id="grp_turb_low">
                <Label><?php echo __("Low");?></Label>
                <ActionURL>mode=settings&amp;turbulence=low</ActionURL>
            </group_element>
            <group_element id="grp_turb_mild">
                <Label><?php echo __("Mild");?></Label>
                <ActionURL>mode=settings&amp;turbulence=mild</ActionURL>
            </group_element>
            <group_element id="grp_turb_med">
                <Label><?php echo __("Medium");?></Label>
                <ActionURL>mode=settings&amp;turbulence=medium</ActionURL>
            </group_element>
            <group_element id="grp_turb_high">
                <Label><?php echo __("High");?></Label>
                <ActionURL>mode=settings&amp;turbulence=high</ActionURL>
            </group_element>
            <group_element id="grp_turb_ex">
                <Label><?php echo __("Extreme");?></Label>
                <ActionURL>mode=settings&amp;turbulence=extreme</ActionURL>
            </group_element>
        </group>
        <group id="grp_LAC" label="<?php echo __("Manual LAC");?>">
            <_x>10</_x>
            <_y>280</_y>
            <group_element id="grp_lac_off">
                <Label><?php echo __("Off");?></Label>
                <ActionURL>mode=settings&amp;lac=off</ActionURL>
            </group_element>
            <group_element id="grp_lac_normal">
                <Label><?php echo __("Normal");?></Label>
                <ActionURL>mode=settings&amp;lac=normal</ActionURL>
            </group_element>
            <group_element id="grp_lac_aggressive">
                <Label><?php echo __("Agressive");?></Label>
                <ActionURL>mode=settings&amp;lac=aggressive</ActionURL>
            </group_element>
        </group>
        <group id="grp_stab" label="<?php echo __("Stabilize");?>">
            <_x>10</_x>
            <_y>370</_y>
            <group_element id="grp_stab_off">
                <Label><?php echo __("Off");?></Label>
                <ActionURL>mode=settings&amp;stab=off</ActionURL>
            </group_element>
            <group_element id="grp_stab_on">
                <Label><?php echo __("On");?></Label>
                <ActionURL>mode=settings&amp;stab=on</ActionURL>
            </group_element>
        </group>
        <group id="grp_nuc" label="<?php echo __("5pt NUC");?>">
            <_x>110</_x>
            <_y>280</_y>
            <group_element id="grp_nuc_on">
                <Label><?php echo __("Run NUC");?></Label>
                <ActionURL>mode=settings&amp;nuc=on</ActionURL>
            </group_element>
        </group>
        <group id="grp_edge" label="<?php echo __("Edge Enh");?>">
            <_x>110</_x>
            <_y>135</_y>
            <group_element id="grp_edge_en_off">
                <Label><?php echo __("Off");?></Label>
                <ActionURL>mode=settings&amp;edge=off</ActionURL>
            </group_element>
            <group_element id="grp_edge_en_on">
                <Label><?php echo __("On");?></Label>
                <ActionURL>mode=settings&amp;edge=on</ActionURL>
            </group_element>
        </group>
        <group id="grp_ezoom" label="<?php echo __("EZoom");?>">
            <_x>110</_x>
            <_y>50</_y>
            <group_element id="grp_ezoom_off">
                <Label><?php echo __("Off");?></Label>
                <ActionURL>mode=settings&amp;ezoom=off</ActionURL>
            </group_element>
            <group_element id="grp_ezoom_in">
                <Label><?php echo __("In");?></Label>
                <ActionURL>mode=settings&amp;ezoom=in</ActionURL>
            </group_element>
            <group_element id="grp_ezoom_out">
                <Label><?php echo __("Out");?></Label>
                <ActionURL>mode=settings&amp;ezoom=out</ActionURL>
            </group_element>
        </group>
        <group id="grp_irpwr" label="<?php echo __("IR Power");?>">
            <_x>115</_x>
            <_y>485</_y>
            <group_element id="grp_irpwr_on">
                <Label><?php echo __("On");?></Label>
                <ActionURL>mode=settings&amp;irpwr=on</ActionURL>
            </group_element>
            <group_element id="grp_irpwr_off">
                <Label><?php echo __("Off");?></Label>
                <ActionURL>mode=settings&amp;irpwr=off</ActionURL>
            </group_element>
        </group>
        <group id="grp_hot" label="<?php echo __("Thermal");?>">
            <_x>10</_x>
            <_y>205</_y>
            <group_element id="btn_hot_black" hwJstkBtn="10">
                <Label><?php echo __("black hot");?></Label>
                <ActionURL>mode=settings&amp;hot=black</ActionURL>
            </group_element>
            <group_element id="btn_hot_white" hwJstkBtn="9">
                <Label><?php echo __("white hot");?></Label>
                <ActionURL>mode=settings&amp;hot=white</ActionURL>
            </group_element>
        </group>
        <group id="grp_afocus" label="<?php echo __("Auto Focus");?>">
            <_x>115</_x>
            <_y>205</_y>
            <group_element id="grp_autofocus_on">
                <Label><?php echo __("refocus");?></Label>
                <ActionURL>mode=settings&amp;autofocus=on</ActionURL>
            </group_element>
            <group_element id="grp_autofocus_auto">
                <Label><?php echo __("auto");?></Label>
                <ActionURL>mode=settings&amp;autofocus=auto</ActionURL>
            </group_element>
        </group>
    </tab>

    <tab id="tab_controls" label="<?php echo __("CONTROLS");?>">
        <_width>75</_width>
		<group id="grp_lrf" label="">
			<_x>130</_x>
			<_y>95</_y>
			<group_element id="grp_fire_lrf">
				<Label><?php echo __("LRF");?></Label>
				<autoSize>true</autoSize>
				<_height>16</_height>
				<ActionURL>mode=settings&lrf=1</ActionURL>
			</group_element>
		</group>
	<!--
        <label id="ir_label" visible="1">
            <text><?php echo __("I R");?></text>
            <_x>95</_x>
            <_y>135</_y>
            <color>0x2C293A</color>
            <fontSize>16</fontSize>
        </label>
	-->
        <label id="tv_label" visible="1">
            <text><?php echo __("T V Settings");?></text>
            <_x>65</_x>
            <_y>430</_y>
            <color>0x2C293A</color>
            <fontSize>16</fontSize>
        </label>
        <group id="grp_active" label="<?php echo __("Set Active");?>">
            <_x>60</_x>
            <_y>295</_y>
            <group_element id="grp_active_ir">
                <Label><?php echo __("IR");?></Label>
                <ActionURL>mode=settings&amp;active=ir</ActionURL>
            </group_element>
            <group_element id="grp_active_tv">
                <Label><?php echo __("Color");?></Label>
                <ActionURL>mode=settings&amp;active=tv</ActionURL>
            </group_element>
        </group>
        <group id="grp_2x" label="<?php echo __("2X Lens");?>">
            <_x>10</_x>
            <_y>485</_y>
            <group_element id="grp_2x_out">
                <Label><?php echo __("Out");?></Label>
                <ActionURL>mode=settings&amp;2x=out</ActionURL>
            </group_element>
            <group_element id="grp_2x_in">
                <Label><?php echo __("In");?></Label>
                <ActionURL>mode=settings&amp;2x=in</ActionURL>
            </group_element>
        </group>
        <group id="grp_tvfocus" label="<?php echo __("Auto Focus");?>">
            <_x>115</_x>
            <_y>485</_y>
            <group_element id="grp_tvfocus_on">
                <Label><?php echo __("refocus");?></Label>
                <ActionURL>mode=settings&amp;tvfocus=on</ActionURL>
            </group_element>
        </group>
	<handle id="focus"  visible="1">
	    <_x>150</_x>
	    <_y>230</_y>
	    <Label><?php echo __("Focus");?></Label>
	    <Up>mode=step&amp;focus=near</Up>
	    <Down>mode=step&amp;focus=far</Down>
	</handle>
	<handle id="zoom" visible="1">
	    <_x>65</_x>
	    <_y>230</_y>
	    <Label><?php echo __("Zoom");?></Label>
	    <Up>mode=step&amp;zoom=in</Up>
	    <Down>mode=step&amp;zoom=out</Down>
	</handle>
        <joystick id="joystick" visible="1">
            <_x>109</_x>
            <_y>70</_y>
            <_width>128</_width>
            <_height>126</_height>
        </joystick>
    </tab>
    <tab id="tab_ptz" label="<?php echo __("P T Z");?>">
		<label id="presetPos" visible="1">
			<text><?php echo __("Preset ID:");?></text>
			<_x>10</_x>
			<_y>440</_y>
			<color>0x2C293A</color>
			<fontSize>12</fontSize>
		</label>
		<input_text id="input_text1">
			<_x>10</_x>
			<_y>460</_y>
			<_width>150</_width>
		</input_text>
		<btn_pres_manage id="btn_pres_manage1">
			<btnLabel>Save</btnLabel>
			<ActionURL>save</ActionURL>
			<_x>0</_x>
			<_y>480</_y>
		</btn_pres_manage>
		<btn_pres_manage id="btn_pres_manage2">
			<btnLabel>Load</btnLabel>
			<ActionURL>goto</ActionURL>
			<_x>50</_x>
			<_y>480</_y>
		</btn_pres_manage>
        <_width>75</_width>

        <joystick id="joystick" visible="1">
            <_x>109</_x>
            <_y>70</_y>
            <_width>128</_width>
            <_height>126</_height>
        </joystick>

        <label id="presetPositions" visible="1">
            <text><?php echo __("Preset positions");?></text>
            <_x>42</_x>
            <_y>160</_y>
            <color>0x2C293A</color>
            <fontSize>12</fontSize>
        </label>

		<group id="grp_ptz_tour" label="">
			<_x>42</_x>
			<_y>300</_y>
			<group_element id="grp_toggle_ptz_tour">
				<Label><?php echo __("PTZ tour");?></Label>
				<autoSize>true</autoSize>
				<_height>16</_height>
				<ActionURL>mode=manageptztour&presets=100</ActionURL>
			</group_element>
		</group>
		<group id="grp_lrf" label="">
			<_x>130</_x>
			<_y>95</_y>
			<group_element id="grp_fire_lrf">
				<Label><?php echo __("LRF");?></Label>
				<autoSize>true</autoSize>
				<_height>16</_height>
				<ActionURL>mode=settings&lrf=1</ActionURL>
			</group_element>
		</group>

        <save_preset id="save_preset">
            <_x>42</_x>
            <_y>295</_y>
        </save_preset>

        <btn_preset id="btn_preset1">
            <btnLabel>1</btnLabel>
            <ActionURL>1</ActionURL>
            <_x>42</_x>
            <_y>180</_y>
        </btn_preset>
        <btn_preset id="btn_preset2">
            <btnLabel>2</btnLabel>
            <ActionURL>2</ActionURL>
            <_x>87</_x>
            <_y>180</_y>
        </btn_preset>
        <btn_preset id="btn_preset3">
            <btnLabel>3</btnLabel>
            <ActionURL>3</ActionURL>
            <_x>132</_x>
            <_y>180</_y>
        </btn_preset>
        <btn_preset id="btn_preset4">
            <btnLabel>4</btnLabel>
            <ActionURL>4</ActionURL>
            <_x>42</_x>
            <_y>220</_y>
        </btn_preset>
        <btn_preset id="btn_preset5">
            <btnLabel>5</btnLabel>
            <ActionURL>5</ActionURL>
            <_x>87</_x>
            <_y>220</_y>
        </btn_preset>
        <btn_preset id="btn_preset6">
            <btnLabel>6</btnLabel>
            <ActionURL>6</ActionURL>
            <_x>132</_x>
            <_y>220</_y>
        </btn_preset>
		<btn_preset id="btn_preset7">
            <btnLabel>7</btnLabel>
            <ActionURL>7</ActionURL>
            <_x>42</_x>
            <_y>260</_y>
        </btn_preset>
        <btn_preset id="btn_preset8">
            <btnLabel>8</btnLabel>
            <ActionURL>8</ActionURL>
            <_x>87</_x>
            <_y>260</_y>
        </btn_preset>
        <btn_preset id="btn_preset9">
            <btnLabel>9</btnLabel>
            <ActionURL>9</ActionURL>
            <_x>132</_x>
            <_y>260</_y>
        </btn_preset>
	</tab>
</camera_controls>
