<?php
header("Content-type: text/xml");
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
?>

<!--?xml version="1.0"?-->
<!--$Id: ptcr20bae.xml 6458 2006-11-20 00:55:13Z teetov $ -->
<!--This XML document describes which controls are applicable to particular camera-->
<camera_controls>
    <settings>
        <window_size width="240" height="550" />
    </settings>

	<tab id="tab_presets" label="<?php echo __("PRES");?>">
		<_width>40</_width>

		<label id="presetPos" visible="1">
			<text><?php echo __("Preset ID:");?></text>
			<_x>10</_x>
			<_y>10</_y>
			<color>0x2C293A</color>
			<fontSize>12</fontSize>
		</label>
		<input_text id="input_text1">
			<_x>10</_x>
			<_y>30</_y>
			<_width>150</_width>
		</input_text>
		<btn_pres_manage id="btn_pres_manage1">
			<btnLabel>Save</btnLabel>
			<ActionURL>save</ActionURL>
			<_x>0</_x>
			<_y>50</_y>
		</btn_pres_manage>
		<btn_pres_manage id="btn_pres_manage2">
			<btnLabel>Load</btnLabel>
			<ActionURL>goto</ActionURL>
			<_x>50</_x>
			<_y>50</_y>
		</btn_pres_manage>
	</tab>

    <tab id="tab_antispoof" label="<?php echo __("ANTI-SPOOF");?>">
        <_width>80</_width>
        <group id="grp_set1" label="<?php echo __("Sequence 1");?>">
            <_x>10</_x>
            <_y>5</_y>
            <group_element id="grp_spoof1">
                <Label><?php echo __("L U R D");?></Label>
                <ActionURL>mode=antispoof&amp;seq=LLLLUUUURRRRDDDD</ActionURL>
            </group_element>
        </group>
        <group id="grp_set2" label="<?php echo __("Sequence 2");?>">
            <_x>10</_x>
            <_y>65</_y>
            <group_element id="grp_spoof2">
                <Label><?php echo __("R D L U");?></Label>
                <ActionURL>mode=antispoof&amp;seq=RRRRDDDDLLLLUUUU</ActionURL>
            </group_element>
        </group>
        <group id="grp_set3" label="<?php echo __("Sequence 3");?>">
            <_x>10</_x>
            <_y>130</_y>
            <group_element id="grp_spoof3">
                <Label><?php echo __("U R D L");?></Label>
                <ActionURL>mode=antispoof&amp;seq=UUUURRRRDDDDLLLL</ActionURL>
            </group_element>
        </group>
        <group id="grp_set4" label="<?php echo __("Sequence 4");?>">
            <_x>140</_x>
            <_y>5</_y>
            <group_element id="grp_spoof4">
                <Label><?php echo __("D L U R");?></Label>
                <ActionURL>mode=antispoof&amp;seq=DDDDLLLLUUUURRRR</ActionURL>
            </group_element>
        </group>
        <group id="grp_set5" label="<?php echo __("Sequence 5");?>">
            <_x>140</_x>
            <_y>65</_y>
            <group_element id="grp_spoof5">
                <Label><?php echo __("R U");?></Label>
                <ActionURL>mode=antispoof&amp;seq=RRRRUUUU</ActionURL>
            </group_element>
        </group>
        <group id="grp_set6" label="<?php echo __("Sequence 6");?>">
            <_x>140</_x>
            <_y>130</_y>
            <group_element id="grp_spoof6">
                <Label><?php echo __("D L");?></Label>
                <ActionURL>mode=antispoof&amp;seq=DDDDLLLL</ActionURL>
            </group_element>
        </group>
        <group id="tour_360" label="<?php echo __("Tour 360");?>">
            <_x>10</_x>
            <_y>195</_y>
            <group_element id="start360">
                <Label><?php echo __("start 360");?></Label>
                <ActionURL>mode=antispoof&amp;pt=360,0</ActionURL>
            </group_element>
        </group>
        <group id="tour_Zone" label="<?php echo __("Tour Zone");?>">
            <_x>140</_x>
            <_y>195</_y>
            <group_element id="zone">
                <Label><?php echo __("Zone");?></Label>
                <ActionURL>mode=antispoof&amp;seq=3456</ActionURL>
            </group_element>
        </group>
    </tab>
    <tab id="tab_settings" label="<?php echo __("SETTINGS");?>">
        <_width>75</_width>
        <group id="grp_polarity" label="<?php echo __("Polarity");?>">
            <_x>10</_x>
            <_y>5</_y>
            <group_element id="grp_polarity_black">
                <Label><?php echo __("normal");?></Label>
                <ActionURL>mode=settings&amp;polarity=black</ActionURL>
            </group_element>
            <group_element id="grp_polarity_white">
                <Label><?php echo __("negative");?></Label>
                <ActionURL>mode=settings&amp;polarity=white</ActionURL>
            </group_element>
        </group>

        <group id="grp_autogain" label="<?php echo __("Autogain");?>">
            <_x>10</_x>
            <_y>100</_y>
            <group_element id="grp_autogain_on">
                <Label><?php echo __("on");?></Label>
                <ActionURL>mode=settings&amp;autogain=on</ActionURL>
            </group_element>
            <group_element id="grp_autogain_off">
                <Label><?php echo __("off");?></Label>
                <ActionURL>mode=settings&amp;autogain=off</ActionURL>
            </group_element>
        </group>

        <group id="grp_autoiris" label="<?php echo __("Autoiris");?>">
            <_x>140</_x>
            <_y>5</_y>
            <group_element id="grp_autolevel_on">
                <Label><?php echo __("on");?></Label>
                <ActionURL>mode=settings&amp;autoiris=on</ActionURL>
            </group_element>
            <group_element id="grp_autolevel_off">
                <Label><?php echo __("off");?></Label>
                <ActionURL>mode=settings&amp;autoiris=off</ActionURL>
            </group_element>
        </group>

        <group id="grp_autofocus" label="<?php echo __("Auto focus");?>">
            <_x>140</_x>
            <_y>100</_y>
            <group_element id="grp_autofocus_on">
                <Label><?php echo __("on");?></Label>
                <ActionURL>mode=settings&amp;autofocus=on</ActionURL>
            </group_element>
            <group_element id="grp_autofocus_off">
                <Label><?php echo __("off");?></Label>
                <ActionURL>mode=settings&amp;autofocus=off</ActionURL>
            </group_element>
        </group>
        <group id="grp_autoir" label="<?php echo __("Auto IR mode");?>">
            <_x>10</_x>
            <_y>195</_y>
            <group_element id="grp_autoir_on">
                <Label><?php echo __("on");?></Label>
                <ActionURL>mode=settings&amp;autoir=on</ActionURL>
            </group_element>
            <group_element id="grp_autoir_off">
                <Label><?php echo __("off");?></Label>
                <ActionURL>mode=settings&amp;autoir=off</ActionURL>
            </group_element>
        </group>
        <group id="grp_pictflip" label="<?php echo __("Picture flip");?>">
            <_x>140</_x>
            <_y>195</_y>
            <group_element id="grp_pictflip_on">
                <Label><?php echo __("on");?></Label>
                <ActionURL>mode=settings&amp;pictflip=on</ActionURL>
            </group_element>
            <group_element id="grp_pictflip_off">
                <Label><?php echo __("off");?></Label>
                <ActionURL>mode=settings&amp;pictflip=off</ActionURL>
            </group_element>
        </group>
    </tab>

    <tab id="tab_ptz" label="<?php echo __("PTZ");?>">
        <_width>40</_width>
        <label id="presetPositions" visible="1">
            <text><?php echo __("Preset positions");?></text>
            <_x>20</_x>
            <_y>400</_y>
            <color>0x2C293A</color>
            <fontSize>12</fontSize>
        </label>

		<group id="grp_ptz_tour" label="">
			<_x>20</_x>
			<_y>450</_y>
			<group_element id="grp_toggle_ptz_tour">
				<Label><?php echo __("PTZ tour");?></Label>
				<autoSize>true</autoSize>
				<_height>16</_height>
				<ActionURL>mode=manageptztour&presets=100</ActionURL>
			</group_element>
		</group>

        <save_preset id="save_preset">
            <_x>20</_x>
            <_y>455</_y>
        </save_preset>
        <btn_preset id="btn_preset6">
            <btnLabel>6</btnLabel>
            <ActionURL>6</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset5">
            <btnLabel>5</btnLabel>
            <ActionURL>5</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset4">
            <btnLabel>4</btnLabel>
            <ActionURL>4</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset3">
            <btnLabel>3</btnLabel>
            <ActionURL>3</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset2">
            <btnLabel>2</btnLabel>
            <ActionURL>2</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset1">
            <btnLabel>1</btnLabel>
            <ActionURL>1</ActionURL>
            <_x>20</_x>
            <_y>420</_y>
        </btn_preset>

        <joystick id="joystick" visible="1">
            <_x>120</_x>
            <_y>75</_y>
            <_width>128</_width>
            <_height>126</_height>
        </joystick>

        <handle id="gain" visible="1">
            <_x>60</_x>
            <_y>210</_y>
            <Label><?php echo __("Gain");?></Label>
            <Up>mode=step&amp;gain=up</Up>
            <Down>mode=step&amp;gain=down</Down>
        </handle>

        <handle id="iris" visible="1">
            <_x>180</_x>
            <_y>210</_y>
            <Label><?php echo __("Iris");?></Label>
            <Up>mode=step&amp;iris=up</Up>
            <Down>mode=step&amp;iris=down</Down>
        </handle>

        <handle id="focus"  visible="1">
            <_x>60</_x>
            <_y>330</_y>
            <Label><?php echo __("Focus");?></Label>
            <Up hwJstkBtn="5">mode=step&amp;focus=near</Up>
            <Down hwJstkBtn="3">mode=step&amp;focus=far</Down>
        </handle>
        <handle id="zoom" visible="1">
            <_x>180</_x>
            <_y>330</_y>
            <Label><?php echo __("Zoom");?></Label>
            <Up>mode=step&amp;zoom=in</Up>
            <Down>mode=step&amp;zoom=out</Down>
<!--            <Autorepeat>true</Autorepeat> -->
        </handle>

        <group id="ptz_reset" label="">
            <_x>300</_x>
            <_y>137</_y>
            <group_element id="ptz_reset">
                <Label><?php echo __("PTZ RESET");?></Label>
                <ActionURL>mode=settings&amp;reset=yes</ActionURL>
            </group_element>
        </group>
    </tab>
</camera_controls>

