<?php
header("Content-type: text/xml");
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
?>

<!--?xml version="1.0"?-->
<!-- QPT-50 / FLIR -->
<!--This XML document describes which controls are applicable to particular camera-->
<camera_controls>
    <settings>
        <window_size width="225" height="550" />
    </settings>

	<tab id="tab_presets" label="<?php echo __("PRESETS");?>">
		<_width>75</_width>

		<label id="presetPos" visible="1">
			<text><?php echo __("Preset ID:");?></text>
			<_x>10</_x>
			<_y>10</_y>
			<color>0x2C293A</color>
			<fontSize>12</fontSize>
		</label>
		<input_text id="input_text1">
			<_x>10</_x>
			<_y>30</_y>
			<_width>150</_width>
		</input_text>
		<btn_pres_manage id="btn_pres_manage1">
			<btnLabel>Save</btnLabel>
			<ActionURL>save</ActionURL>
			<_x>0</_x>
			<_y>50</_y>
		</btn_pres_manage>
		<btn_pres_manage id="btn_pres_manage2">
			<btnLabel>Load</btnLabel>
			<ActionURL>goto</ActionURL>
			<_x>50</_x>
			<_y>50</_y>
		</btn_pres_manage>
	</tab>

    <tab id="tab_settings" label="<?php echo __("SETTINGS");?>">
        <_width>75</_width>
        <group id="grp_aspan" label="<?php echo __("Autospan");?>">
            <_x>10</_x>
            <_y>5</_y>
            <group_element id="grp_aspan_lin">
              <Label><?php echo __("Linear");?></Label>
              <ActionURL>mode=settings&amp;aspan=lin</ActionURL>
            </group_element>
            <group_element id="grp_aspan_hist">
              <Label><?php echo __("Histogram");?></Label>
              <ActionURL>mode=settings&amp;aspan=hist</ActionURL>
            </group_element>
        </group>

        <group id="grp_level" label="<?php echo __("Level");?>">
            <_x>120</_x>
            <_y>5</_y>
            <group_element id="grp_level_manual">
                <Label><?php echo __("Manual");?></Label>
                <ActionURL>mode=settings&amp;level=manual</ActionURL>
            </group_element>
            <group_element id="grp_level_automatic">
                <Label><?php echo __("Automatic");?></Label>
                <ActionURL>mode=settings&amp;level=automatic</ActionURL>
            </group_element>
        </group>

        <group id="grp_focus" label="<?php echo __("Focus");?>">
            <_x>10</_x>
            <_y>80</_y>
            <group_element id="grp_focus_near">
                <Label><?php echo __("Near");?></Label>
                <ActionURL>mode=settings&amp;focus=near</ActionURL>
            </group_element>
            <group_element id="grp_focus_far">
                <Label><?php echo __("Far");?></Label>
                <ActionURL>mode=settings&amp;focus=far</ActionURL>
            </group_element>
        </group>

        <group id="grp_nuc" label="<?php echo __("NUC");?>">
            <_x>120</_x>
            <_y>80</_y>
            <group_element id="grp_nuc_internal">
                <Label><?php echo __("Internal");?></Label>
                <ActionURL>mode=settings&amp;nuc=internal</ActionURL>
            </group_element>
        </group>

        <group id="grp_gain" label="<?php echo __("Gain");?>">
            <_x>10</_x>
            <_y>155</_y>
            <group_element id="grp_gain_manual">
                <Label><?php echo __("Manual");?></Label>
                <ActionURL>mode=settings&amp;gain=manual</ActionURL>
            </group_element>
            <group_element id="grp_gain_automatic">
                <Label><?php echo __("Automatic");?></Label>
                <ActionURL>mode=settings&amp;gain=automatic</ActionURL>
            </group_element>
        </group>

        <group id="grp_polarity" label="<?php echo __("Polarity");?>">
            <_x>120</_x>
            <_y>155</_y>
            <group_element id="grp_polarity_on">
                <Label><?php echo __("White");?></Label>
                <ActionURL>mode=settings&amp;polarity=off</ActionURL>
            </group_element>
            <group_element id="grp_polarity_off">
                <Label><?php echo __("Black");?></Label>
                <ActionURL>mode=settings&amp;polarity=on</ActionURL>
            </group_element>
        </group>

		<group id="grp_palette" label="<?php echo __("Palette");?>">
            <_x>10</_x>
            <_y>230</_y>
			<group_element id="grp_palette_gray">
				   <Label><?php echo __("Gray");?></Label>
				  <ActionURL>mode=settings&amp;palette=gray</ActionURL>
			</group_element>
			<group_element id="grp_palette_iron">
				   <Label><?php echo __("Iron");?></Label>
				  <ActionURL>mode=settings&amp;palette=iron</ActionURL>
			</group_element>
			<group_element id="grp_palette_rainbow">
				   <Label><?php echo __("Rainbow");?></Label>
				  <ActionURL>mode=settings&amp;palette=rainbow</ActionURL>
			</group_element>
        </group>

		<group id="grp_temporal" label="<?php echo __("Temporal");?>">
			  <_x>120</_x>
			  <_y>230</_y>
			  <group_element id="grp_temporal_on">
					  <Label><?php echo __("Filter on");?></Label>
					  <ActionURL>mode=settings&amp;temporal=on</ActionURL>
			  </group_element>
			  <group_element id="grp_temporal_off">
					  <Label><?php echo __("Filter off");?></Label>
					  <ActionURL>mode=settings&amp;temporal=off</ActionURL>
			  </group_element>
		</group>

        <group id="grp_hw_defaults" label=" ">
            <_x>10</_x>
            <_y>345</_y>
            <group_element id="grp_wb_manual">
                <Label><?php echo __("DEFAULTS");?></Label>
                <ActionURL>mode=hardware&amp;do=defaults</ActionURL>
            </group_element>
        </group>
    </tab>

    <tab id="tab_ptz" label="<?php echo __("P T Z");?>">
        <_width>75</_width>
        <label id="presetPositions" visible="1">
            <text><?php echo __("Preset positions");?></text>
            <_x>10</_x>
            <_y>150</_y>
            <color>0x2C293A</color>
            <fontSize>12</fontSize>
        </label>

		<group id="grp_ptz_tour" label="">
			<_x>10</_x>
			<_y>205</_y>
			<group_element id="grp_toggle_ptz_tour">
				<Label><?php echo __("PTZ tour");?></Label>
				<autoSize>true</autoSize>
				<_height>16</_height>
				<ActionURL>mode=manageptztour&presets=100</ActionURL>
			</group_element>
		</group>

        <save_preset id="save_preset">
            <_x>10</_x>
            <_y>210</_y>
        </save_preset>
        <btn_preset id="btn_preset6">
            <btnLabel>6</btnLabel>
            <ActionURL>6</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset5">
            <btnLabel>5</btnLabel>
            <ActionURL>5</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset4">
            <btnLabel>4</btnLabel>
            <ActionURL>4</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset3">
            <btnLabel>3</btnLabel>
            <ActionURL>3</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset2">
            <btnLabel>2</btnLabel>
            <ActionURL>2</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset1">
            <btnLabel>1</btnLabel>
            <ActionURL>1</ActionURL>
            <_x>10</_x>
            <_y>170</_y>
        </btn_preset>

		<group id="grp_sensitivity" label="<?php echo __("Sensitivity");?>">
            <_x>10</_x>
            <_y>260</_y>
			<group_element id="grp_sensitivity_low">
				   <Label><?php echo __("Low");?></Label>
				  <ActionURL>mode=settings&amp;sensitivity=low</ActionURL>
			</group_element>
			<group_element id="grp_sensitivity_med">
				   <Label><?php echo __("Medium");?></Label>
				  <ActionURL>mode=settings&amp;sensitivity=med</ActionURL>
			</group_element>
			<group_element id="grp_sensitivity_high">
				   <Label><?php echo __("High");?></Label>
				  <ActionURL>mode=settings&amp;sensitivity=high</ActionURL>
			</group_element>
        </group>

		<group id="grp_fov" label="<?php echo __("FOV");?>">
            <_x>110</_x>
            <_y>260</_y>
			<group_element id="grp_fov_narrow">
				   <Label><?php echo __("Narrow");?></Label>
				  <ActionURL>mode=settings&amp;fov=narrow</ActionURL>
			</group_element>
			<group_element id="grp_fov_wide">
				   <Label><?php echo __("Wide");?></Label>
				  <ActionURL>mode=settings&amp;fov=wide</ActionURL>
			</group_element>
        </group>

		<group id="grp_zoom" label="<?php echo __("Zoom");?>">
            <_x>5</_x>
            <_y>360</_y>
			<group_element id="grp_zoom_in">
				   <Label><?php echo __("Out");?></Label>
				  <ActionURL>mode=settings&amp;zoom=out</ActionURL>
			</group_element>
			<group_element id="grp_zoom_out">
				   <Label><?php echo __("In");?></Label>
				  <ActionURL>mode=settings&amp;zoom=in</ActionURL>
			</group_element>
        </group>

        <handle id="Focus"  visible="1">
            <_x>40</_x>
            <_y>70</_y>
            <Label><?php echo __("Focus");?></Label>
            <Up hwJstkBtn="5">mode=step&amp;focus=up</Up>
            <Down hwJstkBtn="3">mode=step&amp;focus=down</Down>
        </handle>

        <joystick id="joystick" visible="1">
            <_x>150</_x>
            <_y>70</_y>
            <_width>128</_width>
            <_height>126</_height>
        </joystick>
    </tab>
</camera_controls>
