<?php
header("Content-type: text/xml");
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
?>

<!--?xml version="1.0"?-->
<!--$Id: ptcr20bae.xml.php 17556 2010-01-25 15:18:38Z tsibulskiy $ -->
<!--This XML document describes which controls are applicable to particular camera-->
<camera_controls>
    <settings>
        <window_size width="225" height="435" />
    </settings>

	<tab id="tab_presets" label="<?php echo __("PRESETS");?>">
		<_width>75</_width>

		<label id="presetPos" visible="1">
			<text><?php echo __("Preset ID:");?></text>
			<_x>10</_x>
			<_y>10</_y>
			<color>0x2C293A</color>
			<fontSize>12</fontSize>
		</label>
		<input_text id="input_text1">
			<_x>10</_x>
			<_y>30</_y>
			<_width>150</_width>
		</input_text>
		<btn_pres_manage id="btn_pres_manage1">
			<btnLabel>Save</btnLabel>
			<ActionURL>save</ActionURL>
			<_x>0</_x>
			<_y>50</_y>
		</btn_pres_manage>
		<btn_pres_manage id="btn_pres_manage2">
			<btnLabel>Load</btnLabel>
			<ActionURL>goto</ActionURL>
			<_x>50</_x>
			<_y>50</_y>
		</btn_pres_manage>
	</tab>

    <tab id="tab_settings" label="<?php echo __("SETTINGS");?>">
        <_width>75</_width>
        <group id="grp_polarity" label="<?php echo __("Polarity");?>">
            <_x>10</_x>
            <_y>5</_y>
            <group_element id="grp_polarity_black">
                <Label><?php echo __("black");?></Label>
                <ActionURL>mode=settings&amp;polarity=black</ActionURL>
            </group_element>
            <group_element id="grp_polarity_white">
                <Label><?php echo __("white");?></Label>
                <ActionURL>mode=settings&amp;polarity=white</ActionURL>
            </group_element>
        </group>

        <group id="grp_autogain" label="<?php echo __("Autogain");?>">
            <_x>10</_x>
            <_y>100</_y>
            <group_element id="grp_autogain_on">
                <Label><?php echo __("on");?></Label>
                <ActionURL>mode=settings&amp;autogain=on</ActionURL>
            </group_element>
            <group_element id="grp_autogain_off">
                <Label><?php echo __("off");?></Label>
                <ActionURL>mode=settings&amp;autogain=off</ActionURL>
            </group_element>
        </group>

        <group id="grp_autolevel" label="<?php echo __("Autolevel");?>">
            <_x>130</_x>
            <_y>5</_y>
            <group_element id="grp_autolevel_on">
                <Label><?php echo __("on");?></Label>
                <ActionURL>mode=settings&amp;autolevel=on</ActionURL>
            </group_element>
            <group_element id="grp_autolevel_off">
                <Label><?php echo __("off");?></Label>
                <ActionURL>mode=settings&amp;autolevel=off</ActionURL>
            </group_element>
        </group>

        <group id="grp_level" label="Level">
            <_x>130</_x>
            <_y>95</_y>
            <group_element id="grp_level_up">
                <Label><?php echo __("up");?></Label>
                <ActionURL>mode=step&amp;level=up</ActionURL>
            </group_element>
            <group_element id="grp_level_down">
                <Label><?php echo __("down");?></Label>
                <ActionURL>mode=step&amp;level=down</ActionURL>
            </group_element>
        </group>
        <group id="grp_autoshutter" label="<?php echo __("Autoshutter");?>">
            <_x>10</_x>
            <_y>195</_y>
            <group_element id="grp_autoshutter_on">
                <Label><?php echo __("on");?></Label>
                <ActionURL>mode=settings&amp;autoshutter=on</ActionURL>
            </group_element>
            <group_element id="grp_autolevel_off">
                <Label><?php echo __("off");?></Label>
                <ActionURL>mode=settings&amp;autoshutter=off</ActionURL>
            </group_element>
        </group>
        <group id="grp_shutter" label="Shutter">
            <_x>130</_x>
            <_y>195</_y>
            <group_element id="grp_shutter_scene">
                <Label><?php echo __("scene");?></Label>
                <ActionURL>mode=settings&amp;shutter=scene</ActionURL>
            </group_element>
            <group_element id="grp_shutter_">
                <Label><?php echo __("manual");?></Label>
                <ActionURL>mode=settings&amp;shutter=manual</ActionURL>
            </group_element>
        </group>
    </tab>

    <tab id="tab_ptz" label="<?php echo __("P T Z");?>">
        <_width>75</_width>
        <label id="presetPositions" visible="1">
            <text><?php echo __("Preset positions");?></text>
            <_x>10</_x>
            <_y>260</_y>
            <color>0x2C293A</color>
            <fontSize>12</fontSize>
        </label>

		<group id="grp_ptz_tour" label="">
			<_x>10</_x>
			<_y>315</_y>
			<group_element id="grp_toggle_ptz_tour">
				<Label><?php echo __("PTZ tour");?></Label>
				<autoSize>true</autoSize>
				<_height>16</_height>
				<ActionURL>mode=manageptztour&presets=100</ActionURL>
			</group_element>
		</group>

        <save_preset id="save_preset">
            <_x>10</_x>
            <_y>320</_y>
        </save_preset>
        <btn_preset id="btn_preset6">
            <btnLabel>6</btnLabel>
            <ActionURL>6</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset5">
            <btnLabel>5</btnLabel>
            <ActionURL>5</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset4">
            <btnLabel>4</btnLabel>
            <ActionURL>4</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset3">
            <btnLabel>3</btnLabel>
            <ActionURL>3</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset2">
            <btnLabel>2</btnLabel>
            <ActionURL>2</ActionURL>
        </btn_preset>
        <btn_preset id="btn_preset1">
            <btnLabel>1</btnLabel>
            <ActionURL>1</ActionURL>
            <_x>10</_x>
            <_y>280</_y>
        </btn_preset>

        <handle id="gain" visible="1">
            <_x>110</_x>
            <_y>195</_y>
            <Label><?php echo __("Gain");?></Label>
            <Up>mode=step&amp;gain=up</Up>
            <Down>mode=step&amp;gain=down</Down>
        </handle>

        <handle id="iris" visible="0">
            <_x>180</_x>
            <_y>195</_y>
            <Label><?php echo __("Iris");?></Label>
            <Up>mode=step&amp;iris=up</Up>
            <Down>mode=step&amp;iris=down</Down>
        </handle>

        <handle id="zoom" visible="0">
            <_x>40</_x>
            <_y>195</_y>
            <Label><?php echo __("Zoom");?></Label>
            <Up>mode=step&amp;zoom=in</Up>
            <Down>mode=step&amp;zoom=out</Down>
        </handle>

        <joystick id="joystick" visible="1">
            <_x>109</_x>
            <_y>70</_y>
            <_width>128</_width>
            <_height>126</_height>
        </joystick>

        <group id="ptz_reset" label="">
            <_x>10</_x>
            <_y>340</_y>
            <group_element id="ptz_reset">
                <Label><?php echo __("PTZ RESET");?></Label>
                <ActionURL>mode=settings&amp;reset=yes</ActionURL>
            </group_element>
        </group>
    </tab>
</camera_controls>

