<?php
/**
 * @version $Id: index.php 20246 2010-09-21 14:00:04Z teetov $
 * ------------------------------------------------------------------------------
 * Admin GUI
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

	if (isset($_GET['close_on_focus_lost']))
		$close_on_focus_lost = $_GET['close_on_focus_lost'];
	else
		$close_on_focus_lost = false;
	if (isset($_GET['objid'])) $objid = $_GET['objid'];
	else $objid = 0;
	$userid = $_SESSION[SESSION_USERID];
	$camera = new Camera();
	$ptz_cameratype = $camera->getAttribute($objid, "PTZ_CAMERATYPE");

	$save_preset = 'no';
	$access = 'no';
	$user = new User();
	if ($user->checkObjectCredentials($userid, $objid, 'P')){
		$save_preset = 'yes';
		$access = 'manage';
	}
	else if($user->checkObjectCredentials($userid, $objid, 'p')){
		$access = 'control';
	}

	if(isset($_GET['extended_presets']) && $_GET['extended_presets'] == "no"){
		$access = "no";
	}

	if(isset($_GET['roleId'])){
		$role = new Role;
		$ptz_priority = $role->getAttribute($_GET['roleId'], "PTZ_PRIORITY");
	}
	else{
		$ptz_priority = 9;
	}
?>
<!DOCTYPE html>
<HTML>
<HEAD>
	<title><?php echo __("PTZ Control");?></title>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>
<style>
body {margin:0 0 0 0;}
</style>
<script src="/sdi/lib/js/jquery.js"></script>
<script src="/sdi/lib/js/console.js"></script>
<script src="js/PTZ_tab.js"></script>
<script>
window.focus();
function resize(w,h){
	w = parseInt(w);
	h = parseInt(h);
	//alert ('w:'+w+', h: '+h);
	if (parent.mx)
	{
		if(parent.mx.MATRIX2){
			parent.mx.PTZ.setPTZDialogSize( w, h, document.getElementById("PTZ_xml"));
			self.resizeTo(w, h);
		}
	} else {
		//self.resizeTo( w + 10, h + 50 );
		self.resizeTo( w + 10, h + 70 );
	}
}
var msgCtxType="16";
var msgEvtType="1";
var msgProcLvl="1";
var msgDevIP="0.0.0.0";
var msgID="0";
var msgDevID="<TMPL_VAR NAME=OBJID>";

var DEV = "<?=Purifier::clean($objid);?>";
var CLOSE_ON_FOCUS_LOST = "<?=Purifier::clean($close_on_focus_lost);?>";
var SAVE_PRESET = "<?php echo $save_preset; ?>";
var PTZ_CAMERATYPE = "<?php echo $ptz_cameratype; ?>";
var PTZ_ACCESS = "<?php echo $access; ?>";

var userId = "<?php echo $userid; ?>";
var userPTZPriority = "<?php echo $ptz_priority; ?>";

</script>
</HEAD>
<BODY>
<script>
var isInternetExplorer = navigator.appName.indexOf("Microsoft") != -1;

// Handle all the FSCommand messages in a Flash movie.
function PTZ_xml_DoFSCommand(command, args) {
    if (command == "popup")
	{
		// Popup hardware joystick calibrator
		if (args == 'hwjCalibrator') {
			var win = window.open(
				'/ptz/hwjCalibrator.php?',
				'hwj_calibrator',
				'left=100,top=100,width=450,height=650,resizable=yes,scrollbars=yes');
			win.focus();
		} else {	// else popup path in args
			self.location=args;
		}
	}else{
    	var PTZ_xmlObj = isInternetExplorer ? document.all.PTZ_xml : document.PTZ_xml;
    	var torun = command+"("+args+")";
    	eval(torun);
    }
}

function flashCalls(val){window.status = val;}

// block first command - DE3644
var first_command_blocked = false;

var lock_incheck = false;

var jqXHR = null;

function sendMessage(Direction){
	console.log(Direction);
	// block first command
	if (!first_command_blocked &&
		(Direction.search("mode=speed&pt=0,0") != -1
		|| Direction.search("mode=speed&z=0") != -1
		|| Direction.search("mode=speed&focus=0") != -1
		|| Direction.search("mode=speed&iris=0") != -1
		|| Direction.search("mode=speed&gain=0") != -1)
		){
		first_command_blocked = true;
		getLock();
		return false;
	}

	//preset 95
	if(Direction.search(/save=95/) != -1 || Direction.search(/goto=95/) != -1) {
		// save forbidden, manage from Operator GUI forbidden too
		if(Direction.search(/save=95/) != -1 || window.parent.mx){
			alert("Preset 95 not available!");
			return;
		}
	}

	if (Direction.search(/mode=manageptztour/) != -1) {
		if (parent.mx) {
		window.parent.mx.PTZ.manage_ptz_tours(Direction.match(/dev=(\d+)/)[1], Direction.match(/presets=(\d+)/) ? Direction.match(/presets=(\d+)/)[1] : 0);
		}else{
			alert("Not supported in Admin, you have to go to Operator Matrix GUI");
		}
		return;
	}

	var Direction_C="<PTZ_Command>"+Direction+"&priority="+userPTZPriority+"</PTZ_Command>";
	jqXHR && jqXHR.abort();
	jqXHR = $.ajax({
		url: '/ptz/cgi-bin/send_message.pl',
		dataType: "json",
		data: {
			data: Direction_C
		}
	})
		.done(function(response) {
			if(response.lockinfo && response.lockinfo.allow_override != undefined)
			{
				checkLock(response.lockinfo.allow_override);
			}
		});

	if (parent.mx) {
		parent.mx.MATRIX2.clearCurrentDesignationTargets(Direction.match(/dev=(\d+)/)[1]);
	}
}

/*
 check lock state
*/
function checkLock(lockOverride){
	if(lock_incheck){
		return;
	}
	lock_incheck = true;
	//window.parent.appLogger.info("checkLock: "+lockOverride);

	if(lockOverride == "sameuser"){
		if(parent.mx){ parent.mx.PTZ.lockDevice(); }
	}
	else if(lockOverride == "no"){
		alert("Another lock is higher priority. You have to wait until controls are released. Please try again later.")
	}
	else if(lockOverride == "yes"){
		var getLock = confirm("Another lock is in place. Do you want to override?");
		if(getLock){
			overrideLock();
		}
		else if(parent.mx){
			parent.mx.PTZ.ptzDialogHide();
		}
		else{
			//TODO close admin PTZ control
		}
	}

	window.setTimeout(function(){
		lock_incheck = false;
	}, 2000)
}

/*
 get lock state
*/
function getLock(){
	//window.parent.appLogger.info("getLock");
	sendMessage("do.ptz?dev=" + DEV + "&mode=lock&cmd=lock");
}

/*
 override lock
*/
function overrideLock(){
	//window.parent.appLogger.info("overrideLock");
	sendMessage("do.ptz?dev=" + DEV + "&mode=lock&cmd=override");
	if(parent.mx){
		parent.mx.PTZ.lockDevice();
	}
}

/*
 release lock
*/
function releaseLock(){
	//window.parent.appLogger.info("releaseLock");
	sendMessage("do.ptz?dev=" + DEV + "&mode=lock&cmd=release");
}


CLOSE_ON_FOCUS_LOST = CLOSE_ON_FOCUS_LOST === "true";

insert_Flash_move(DEV, PTZ_CAMERATYPE, SAVE_PRESET, PTZ_ACCESS, CLOSE_ON_FOCUS_LOST);
</script>

</BODY>
</HTML>
