#!/usr/bin/perl
#  $Id: send2pipe.pl 25370 2012-03-09 21:19:34Z teetov $
# -----------------------------------------------------------------------------
#  Common functions for PTZ command transformations
# -----------------------------------------------------------------------------
#  Author: Dmitriy Astaltsev
#  Edited by: Andrey Fomenko
#  QA by:  Christopher C Gettings
#  Copyright: (c) videoNEXT LLC, 2005
# -----------------------------------------------------------------------------

# -------------------------------------------------------- PrepareCommand -----
sub PrepareCommand{
	my $form_info = shift;
	$form_info = $1 if $form_info =~/^do.ptz\?(.*)/;
	my %args = ();
	my @args;	# to have parameters in order
	foreach(split /&/,$form_info){
	   if (/(\S+)=(\S+)/) {
		next if $1 eq 'imagewidth';
		next if $1 eq 'imageheight';
		next if $2 eq '';
		$args{lc($1)}=unescape($2);
		if ( lc($1) eq 'center') {
			$args{xy} = $args{center};
			delete $args{center};
			push(@args,'xy');
			next;
		}
	    if ( lc($1) eq 'xy') {
	        $args{xy} =~s/\?//;
	    }	
		push(@args,$1);
	   }
	}
	
	my $topipe = "$args{dev} $args{mode}";
	foreach (@args){
	    next if /dev|mode/;
	    $topipe .=" $_=$args{$_}";
	}	
	return $topipe;
}

# -------------------------------------------------- SendPTZCommandToPipe -----
sub SendPTZCommandToPipe{
	my $form_info = shift;
#	$form_info = $1 if $form_info =~/^.+\?(.*)/;
	$form_info = $1 if $form_info =~/^do.ptz\?(.*)/;
	my %args = ();
	my @args;	# to have parameters in order
	foreach(split /&/,$form_info){
	   if (/(\S+)=(\S+)/) {
		next if $1 eq 'imagewidth';
		next if $1 eq 'imageheight';
		next if $2 eq '';
		$args{lc($1)}=unescape($2);
		if ( lc($1) eq 'center') {
	#		$args{center} =~s/\?//;
			$args{xy} = $args{center};
			delete $args{center};
			push(@args,'xy');
			next;
			
		}
	    if ( lc($1) eq 'xy') {
	        $args{xy} =~s/\?//;
	    }	
		push(@args,$1);
	   }
	}
	
	my $topipe = "$args{dev} $args{mode}";
	foreach (@args){
	    next if /dev|mode/;
	    $topipe .=" $_=$args{$_}";
	}	
	#!(`echo $topipe >$ENV{APL}/var/dev/$args{dev}/ptz_pipe &`) || die "Can't print to $ENV{APL}/var/dev/$args{DEV}/ptz_pipe !";
	exit 0 if `ps ax|grep ptz_handler|grep dev=$args{dev}|grep -v $$`;
	
	eval {
	      local $SIG{ALRM} = sub{ die "TIMEOUT $!" }; alarm 1;
	      open FF, "+>$ENV{APL}/var/dev/$args{dev}/ptz_pipe";
	      print FF "$topipe\n" || die "$!";
	      close FF;
	};
	alarm 0;
	die "Can't print to $ENV{APL}/var/dev/$args{dev}/ptz_pipe! ($@)" if $@;		
}

1;