#!/usr/bin/perl
#  $Id: ptz_vicon_retr.pl 25370 2012-03-09 21:19:34Z teetov $
# -----------------------------------------------------------------------------
#  Retranslate VICON commands through 2 serail ports PLUS control switch
# -----------------------------------------------------------------------------
#  Author: Sergey Pososhenko
#  Edited by: Andrey Fomenko
#  QA by:  Christopher C Gettings
#  Copyright: (c) videoNEXT LLC, 2004-2005
# -----------------------------------------------------------------------------

use strict;
use warnings;
use Device::SerialPort;
use Socket;
use IO::File;
use IO::Select;
use IO::Socket;
use Fcntl;

use NextCAM::Init;
use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.engine";

my $log=get_logger('NEXTCAM::PTZ::PTZ_VICON_RETR');

my $query_str = shift || "'POSITIONCTL'=>'vicon_switch'";
$log->info("Starting VICON PTZ DRIVER, query string: [$query_str]");

$SIG{HUP}=\&load_dev_conf;

my ($APL,$APL_CONF,$logname)=($ENV{APL},$ENV{APL_CONF},'vicon_retr-%02d%02d%02d');
my (%conf, %port, %conf_camera, %lastCamera, $cam,$cmd,$par,$usrpsw,$last_cmd,$last_mode);

load_cam_conf();

# -----------------------------------------------------------------------------
my $TCP_PORT = 7766; # TCP port where PTZ server communicates
# -----------------------------------------------------------------------------

my $socket = IO::Socket::INET->new(PeerAddr => '127.0.0.1',
                                   PeerPort => $TCP_PORT,
                                   Proto     => "tcp",
                                   Type      => SOCK_STREAM)
    or $log->logdie("Couldn't connect to socket $TCP_PORT: $@");

nonblock($socket);

print $socket "PTZ DRIVER\n";

$last_mode='smooth';
$last_cmd='left';

my %commands;
my $ready;
my $trycount = 30;
my ($count_in, $string_in);


while(1) {
	# stage 1 - read from socket everything
	if (defined($cmd=<$socket>)) {
		chomp $cmd;
		$log->debug("COMMAND:[$cmd]");
		next if not $cmd;
		load_dev_conf(),next if $cmd=~/HUP/i;
		next if not $cmd=~/^(\d+)/;
		$cam=$1;
		next if not defined $conf{$cam}; # ignore cameras not belonging this engine
		if(defined($commands{$cam})){
			if($commands{$cam} =~ /speed pt=0,0/ || $commands{$cam} =~ /speed ptz=0,0,\d+/
				|| $commands{$cam} =~ /speed zoom=0/ || $commands{$cam} =~ /speed ptz=\d+,\d+,0/
				|| $commands{$cam} =~ /speed focus=0/
				|| $commands{$cam} =~ /speed iris=0/
				|| $commands{$cam} =~ /speed gain=0/
				)
			{
				; # do not override stop command!
			}else{
				$commands{$cam} = $cmd;
			}
		} else {
			$commands{$cam} = $cmd;
		}
		next; # suck all the commands from queue before going to the rest of loop
	} # if ($cmd=<$socket>)
	
	$cmd = '';
	
	# stage 2 - send commands to cameras
	foreach my $camera (keys %commands){
		$cmd=$commands{$camera};
		delete $commands{$camera};
		next if not $cmd=~/^(\d+)\s(\w+)\s(\w+)[=\s]?([^\s]+)?(\s?.*)$/;
		my ($cam,$mode,$cmd,$par,$options) = ($1,$2,$3,$4,$5);
		my %options =  map {/(\w+)=(.*)/} split(/\s/," $options ");
		$usrpsw = "$conf{$cam}{USRNAME}:$conf{$cam}{PASSWD}" if $conf{$cam}{USRNAME} && $conf{$cam}{PASSWD};
		
		if ($cmd eq "ptz") {
			# handle special ptz command
			my @params = split(',', $par);
			camCmd($cam,$mode,"pt", $params[0].','.$params[1] ,\%options);
			camCmd($cam,$mode,"zoom", $params[2] ,\%options);
		} else {
			# ordinary command
			camCmd($cam,$mode,$cmd,$par,\%options);
		}
	}
	select(undef,undef,undef,.1) if not $cmd;

	# stage 3 - here we check for timeouts PTZ_PRESET1TIMEOUT
	foreach my $dev (keys %conf) {
		next if not $conf{$dev}->{TIMEOUT};
		next if $conf{$dev}->{TIMEOUT} > time;
		$log->debug("TIMEOUT EXPIRED!");
		$conf{$dev}->{TIMEOUT} = 0;
		my %options = {};
		camCmd($dev,'preset','goto',1,\%options);
	}
	
	# stage 4 - relay commands between ports
	foreach my $p ( keys %port ) {
		($count_in, $string_in) = $port{$p}{OBJ}->read(50);                                    
		if($count_in){ # we have something coming from satellite
			$log->debug('RELAY FROM INHWPORT:',hex_str(substr($string_in,0,$count_in-1)));
			$log->debug("About to read from [$port{$p}] at object $port{ $port{$p}{SLAVE} }");
			$log->debug("About to write to [$port{$p}{SLAVE}] at object $port{ $port{$p}{SLAVE} }");
			if ($port{$p}{SLAVE} eq 'none'){
				$log->debug("slave port for $port{$p} - NONE!!!");
			}else{
				$log->debug("we going to try write to slave  $port{$p}{SLAVE}");
				$port{ $port{$p}{SLAVE} }{OBJ}->write(substr($string_in,0,$count_in-1));
				$port{$port{$p}{SLAVE}}{OBJ}->write_drain;
				$cmd = 'SERIAL'; # just to avoid wait in the loop
			}
		} # IF we have something coming from satellite
	}

	if(!$cmd) {
		select(undef,undef,undef,.4);
		if(!$trycount--) {
			$trycount = 30;
			print $socket "test\0" or $log->logdie("Couldn't communicate to socket $TCP_PORT: $@");
		}
	}

} # while(1)




# ----------------------------------------------------------- cmdTransmit -----
sub cmdTransmit
{
  my ($dev,$cmd)=@_;
  $log->debug("cmdTransmit dev= $dev , cmd= $cmd");
 	my $out_str ="\cA$cmd\cM";
  $log->debug('INPUT FROM PIPE:',hex_str($out_str));
  $log->debug("out_str= $out_str");
  $log->debug("cmd= $cmd");
  my $sw = $conf{$conf_camera{$dev}{PTZ_ASSOC_DEVID}}{OUTHWPORT};
  $log->debug("sw= $sw");
  foreach my $p ( keys %port ) {
  	$log->debug("p= $p");}
  $port{$sw}{OBJ}->write($out_str);
  #  $port{$conf{$sw}{OUTHWPORT}}->write($out_str);
  $port{$sw}{OBJ}->write_drain;
   
} # sub cmdTransmit
# --------------------------------------------------------------- camStop -----
sub camStop
{
  my ($dev) = @_;
  my $cmd = '';
  cmdTransmit($dev,$cmd);
}
# ---------------------------------------------------------------- PTspeed ----
sub PTspeed {
  my ($p, $t)=@_;
  my $cmd='';
  if ($p > 0){
  	$cmd = 'J';
  	if ($p > 75) {
  		$cmd .= 'WX';
  	}elsif($p > 50){
  		$cmd .= 'W';
  	}elsif ($p > 25){
  		$cmd .= 'X';
  	}
  }elsif($p < 0){
  	$cmd = 'I';
  	if ($p < -75){
  		$cmd = $cmd .'WX';
  	}elsif($p < -50){
  		$cmd .='W' ;
  	}elsif($p < -25){
  		$cmd .='X'
  	}
  }
  if ($t >0){
  	$cmd .='M';
  	if ($t >75){
  		$cmd .='WX';
  	}elsif($t >50){
  		$cmd .= 'W';
  	}elsif($t > 25){
  		$cmd .='X';
  	}
  }elsif($t < 0){
  	$cmd .= 'L';
  	if ($t < -75){
  		$cmd = $cmd .'WX';
  	}elsif($t < -50){
  		$cmd .='W' ;
  	}elsif($t < -25){
  		$cmd .='X'
  	}
  }
 $log->debug( "PTSpeed = $cmd");  	
 return $cmd;
} # sub PTspeed
# ---------------------------------------------------------------- camCmd -----
sub camCmd {
  my ($dev,$mode,$cmd,$param,$options)=@_;
  my %options = %$options;
  my $monitor = $conf_camera{$dev}{PTZID};# monitor hardware ID
#  my @cmd = ( 0xFF, 0, 0, 0, 0, 0, 0 );
  
  # here is logic to start a timer if PTZ_PRESET1TIMEOUT parameter present
  if($conf{$dev}->{PTZ_PRESET1TIMEOUT} && $conf{$dev}->{PTZ_PRESET1TIMEOUT} > 0) {
     if($mode=~/speed/i || $mode=~/step/i || $mode=~/abs/i || $mode=~/rel/i || $mode=~/smooth/i) {
        $log->debug("Setting timeout +$conf{$dev}->{PTZ_PRESET1TIMEOUT}");
        $conf{$dev}->{TIMEOUT} = time + $conf{$dev}->{PTZ_PRESET1TIMEOUT};
     }
     elsif($mode=~/preset/i && $cmd=~/goto/i && $param!=1) {
        $log->debug("Setting timeout (preset) +$conf{$dev}->{PTZ_PRESET1TIMEOUT}");
        $conf{$dev}->{TIMEOUT} = time + $conf{$dev}->{PTZ_PRESET1TIMEOUT};
    }
  }
  
  
  $log->debug("camCmd: DEVID=$dev mode: $mode command: $cmd optional parameter: $param");
  if(not $cmd=~/stop/) { # non-Stop
    # set camera speed
   if ($mode=~/speed/i){        # mode speed/---------------------------------sergey-----------
   if ($lastCamera{$dev}){
		if($cmd=~/PT/i) { # RPT
      my ($p,$t) = split(/,/,$param);
      $cmd =PTspeed($p,$t);
      $log->debug("RPT $p $t");
    }
    elsif($cmd=~/zoom/i) { 
    	$cmd='';
      if ($param == 0){
$log->debug("------------------------Z=0");
        $cmd .='';
        }elsif($param > 0){
      	$cmd .='O';
        }elsif($param < 0){
        $cmd .='N'}
      $log->debug("ZOOM $param");
      
    }
    elsif($cmd=~/focus/i) {
    	$cmd='';
      if ($param == 0){
        $cmd .='';
      }elsif ($param > 0){
      	$cmd .='P';
      }elsif($param < 0){
        $cmd .='Q'}
    }
    elsif($cmd=~/iris/i) {
    	$cmd='';
      if ($param == 0){
        $cmd .='';
      }elsif ($param > 0){
      	$cmd .='S';
      }elsif($param < 0){
        $cmd .='R'}
    }
    else{
    $log->debug("Unknown command");
    return;}
    cmdTransmit($dev,"B$lastCamera{$dev}");
    cmdTransmit($dev,$cmd);
		return;
   }
	 }elsif ($mode=~/settings/i){ # settings
    if ($lastCamera{$dev}){
		if($cmd=~/autoiris/i) { 
        $cmd = 'T';
				cmdTransmit($dev,"B$lastCamera{$dev}");
				cmdTransmit($dev,$cmd);
				return;
			}else{
	     $log->debug("Unknown command");
	     return;
	     }
	}
      
   }elsif($mode=~/switch/i){       # mode=switch  /switch camera on current monitor/---------------------------------sergey-----------
      my $timeout = 0.2;
      if ($lastCamera{$dev}){
				$lastCamera{$dev}=$param;
      if($cmd=~/camera/i) { # camera number to switch
    	  $log->debug("CamCmd Monitor= $monitor");
    	  cmdTransmit($dev,"A$monitor");
        cmdTransmit($dev,"B$param");
      }
      select(undef,undef,undef,$timeout);
      camStop($dev);
      return;
    }
    else{
    $lastCamera{$dev}=$param;
      if($cmd=~/camera/i) { 
    	  $log->debug("CamCmd Monitor= $monitor");
    	  cmdTransmit($dev,"A$monitor");
        cmdTransmit($dev,"B$param");
      }
      select(undef,undef,undef,$timeout);
      camStop($dev);
      return;    
    }
    }elsif($mode=~/step/i){       # mode=step  /Step by step positioning/---------------------------------sergey-----------
      my $timeout = 0.2;
      $log->debug("Step mode dev = $dev, paraf= $param ");
    if ($lastCamera{$dev}){
       if($cmd=~/move/i) { # step pan/tilt
         $cmd = 'J' if $param=~/right/i;
         $cmd = 'I' if $param=~/left/i;
         $cmd = 'M' if $param=~/up/i;
         $cmd = 'L' if $param=~/down/i;
       } elsif ($cmd=~/zoom/i){
         $cmd = 'O' if $param=~/in/i;
         $cmd = 'N' if $param=~/out/i;
       } elsif ($cmd=~/focus/i){    
         $cmd = 'P' if $param=~/near/i;
         $cmd = 'Q' if $param=~/far/i;
         $timeout = 0.02;          # reduce timeout for focusing
       } elsif ($cmd=~/iris/i){
         $cmd = 'S' if $param=~/open/i;
         $cmd = 'R' if $param=~/close/i;
       }else{
         $log->debug("No one comand recognized!");
         return;}
       cmdTransmit($dev,"B$lastCamera{$dev}");
       cmdTransmit($dev,$cmd);
       select(undef,undef,undef,$timeout);
       camStop($dev);
       return;   
    }
    return;
   }elsif($mode=~/hardware/i){   # mode=hardware  /Hardware reset,defaults/
    if($cmd=~/do/i && $param=~/defaults/i) { # init
      camReset($dev);
      return;
    }
   } elsif($mode=~/preset/i){ # presets
     if ($lastCamera{$dev}){
      $cmd = 'H0'.$param if $cmd =~/save/i; 
      $cmd = 'H0'.$param if $cmd =~/clear/i; 
      $cmd = 'G0'.$param if $cmd =~/goto/i; 
      cmdTransmit($dev,"B$lastCamera{$dev}");
      cmdTransmit($dev,$cmd);
      return;   
     }
    return;
   }
   #--------------Click on screen mode --------------------------------------------------------sergey----------- 
   elsif($mode=~/rel/i) { # mode=rel: "<devid> rel size=640x480 xy=225,152"
      my $timeout = 0.2;
      $param =~ /(\d+)x(\d+)/;
      my ($rel_size_x,$rel_size_y) = ($1,$2);
      $options{xy} =~ /(\d+),(\d+)/;
      my ($rel_click_x,$rel_click_y) = ($1,$2);
      my ($rel_p, $rel_t) = ( 200*($rel_click_x-$rel_size_x/2)/$rel_size_x, 200*($rel_click_y-$rel_size_y/2)/$rel_size_y );
      $log->debug("REL [$rel_size_x] [$rel_size_y] [$rel_click_x] [$rel_click_y] [$rel_p] [$rel_t]");
      
      $cmd = PTspeed($rel_p, $rel_t);
      #'';
      #$cmd = 'J' if $rel_p>0;
      #$cmd = 'I' if $rel_p<0;
      #$cmd .= 'L' if $rel_t<0;
      #$cmd .= 'M' if $rel_t>0;
      
      cmdTransmit($dev,"B$lastCamera{$dev}");
      cmdTransmit($dev,$cmd);
      select(undef,undef,undef,$timeout);
      cmdTransmit($dev,"B$lastCamera{$dev}");
      camStop($dev);
      return;
   }
   #--------------Smooth mode --------------------------------------------------------sergey----------- 
    elsif($mode=~/smooth/i) { # Right/Left/Up/Down/Tele/Wide/focus_Near/focus_Far/iris_Open/irIs_close
     if ($lastCamera{$dev}){
       if ($cmd=~/move/i) { # pan/tilt
        $cmd = 'J'if $param=~/right/i;
        $cmd = 'I'if $param=~/left/i;
        $cmd = 'M'if $param=~/up/i;
        $cmd = 'L' if $param=~/down/i;
        $cmd = 'LJ' if $param=~/downright/i;
        $cmd = 'LI' if $param=~/downleft/i;
        $cmd = 'MJ' if $param=~/upright/i;
        $cmd = 'MI' if $param=~/upleft/i;
        $cmd = '' if $param =~/stop/i;
      } elsif($cmd=~/zoom/i) { # zoom
        $cmd = 'O' if $param=~/in/i;
        $cmd = 'N' if $param=~/out/i;
      } elsif($cmd=~/focus/i) { # focus
        $cmd = 'P' if $param=~/near/i; # reduce speed of focusing
        $cmd = 'Q' if $param=~/far/i;
      } elsif($cmd=~/iris/i) { # iris
        $cmd = 'S' if $param=~/open/i;
        $cmd = 'R' if $param=~/close/i;  
      }else{
	     $log->debug("Unknown command");
	     return;
	     }
 				cmdTransmit($dev,"B$lastCamera{$dev}");
				cmdTransmit($dev,$cmd);
				return;
    }
  }
}
  # calculate command check-sum
#  $cmd[6]=checkSum(@cmd);
#  cmdTransmit($dev,$cmd);
}
# --------------------------------------------------------- load_dev_conf -----
sub load_dev_conf {
 # close any ports before we go any further
 foreach my $p ( keys %port ) {
   $port{$port{$p}{OBJ}}{OBJ}->close;
   $port{$port{$p}{SLAVE}}{OBJ}->close;
 #  $port{$port{$p}}->close;
   delete $port{$p};
 }

 %conf = GetCfgs( ('DEVICETYPE'=>'SWITCH') );     # Load configurations
 $log->debug("Config read as:");
 $log->debug("-------------------------------------");
 foreach my $dev (keys %conf) {
   $log->debug("[$dev]");
   $log->debug("DEVID=$conf{$dev}{DEVID}");
   $log->debug("HW_MODEL=$conf{$dev}{HW_MODEL}");
   $log->debug("OUTHWPORT=$conf{$dev}{OUTHWPORT}");
   $log->debug("OUTHWPORT_BITS=$conf{$dev}{OUTHWPORT_BITS}");
   $log->debug("OUTHWPORT_PARITY=$conf{$dev}{OUTHWPORT_PARITY}");
   $log->debug("OUTHWPORT_SPEED=$conf{$dev}{OUTHWPORT_SPEED}");
   $log->debug("OUTHWPORT_STOPBITS=$conf{$dev}{OUTHWPORT_STOPBITS}");
   $log->debug("INHWPORT=$conf{$dev}{INHWPORT}");
   $log->debug("INHWPORT_BITS=$conf{$dev}{INHWPORT_BITS}");
   $log->debug("INHWPORT_PARITY=$conf{$dev}{INHWPORT_PARITY}");
   $log->debug("INHWPORT_SPEED=$conf{$dev}{INHWPORT_SPEED}");
   $log->debug("INHWPORT_STOPBITS=$conf{$dev}{INHWPORT_STOPBITS}");
   $log->debug("-------------------------------------");
   #

 	if($conf{$dev}{OUTHWPORT} eq 'none'){
 		$log->debug("OUTPORT for $conf{$dev}{DEVID} not defined");     }
 	else{   	
   if(not defined($port{$conf{$dev}{OUTHWPORT}}{OBJ})) {
     $log->debug("Initialise serial port: $conf{$dev}{OUTHWPORT}");     
     $port{$conf{$dev}{OUTHWPORT}}{OBJ} = new Device::SerialPort($conf{$dev}{OUTHWPORT}) || die "Can't open port $conf{$dev}{OUTHWPORT}: $!\n";
     $port{$conf{$dev}{OUTHWPORT}}{SLAVE}=$conf{$dev}{INHWPORT};     
     $port{$conf{$dev}{OUTHWPORT}}{OBJ}->handshake("none"); # none / rts / xoff
     $port{$conf{$dev}{OUTHWPORT}}{OBJ}->baudrate($conf{$dev}{OUTHWPORT_SPEED});
     $port{$conf{$dev}{OUTHWPORT}}{OBJ}->parity($conf{$dev}{OUTHWPORT_PARITY});
     $port{$conf{$dev}{OUTHWPORT}}{OBJ}->databits($conf{$dev}{OUTHWPORT_BITS});
     $port{$conf{$dev}{OUTHWPORT}}{OBJ}->stopbits($conf{$dev}{OUTHWPORT_STOPBITS});
     $port{$conf{$dev}{OUTHWPORT}}{OBJ}->buffers(4096, 4096);
     $port{$conf{$dev}{OUTHWPORT}}{OBJ}->read_const_time(50);  # milliseconds
     $port{$conf{$dev}{OUTHWPORT}}{OBJ}->read_char_time(5);
     $log->debug("Done" );
     $log->debug("-------------------------------------");
    }
   }
  if($conf{$dev}{INHWPORT} eq "none"){
  	$log->debug("INHWPORT for $conf{$dev}{DEVID} not defined");     }
 	else{   	
     if(not defined($port{$conf{$dev}{INHWPORT}}{OBJ})) {
        $log->debug("Initialise serial port: $conf{$dev}{INHWPORT}");
        $port{ $conf{$dev}{INHWPORT} }{OBJ} = new Device::SerialPort($conf{$dev}{INHWPORT}) || die "Can't open port $conf{$dev}{INHWPORT}: $!\n";
        $port{$conf{$dev}{INHWPORT}}{SLAVE}=$conf{$dev}{OUTHWPORT};
        $port{$conf{$dev}{INHWPORT}}{OBJ}->handshake("none"); # none / rts / xoff
        $port{$conf{$dev}{INHWPORT}}{OBJ}->baudrate($conf{$dev}{INHWPORT_SPEED});
        $port{$conf{$dev}{INHWPORT}}{OBJ}->parity($conf{$dev}{INHWPORT_PARITY});
        $port{$conf{$dev}{INHWPORT}}{OBJ}->databits($conf{$dev}{INHWPORT_BITS});
        $port{$conf{$dev}{INHWPORT}}{OBJ}->stopbits($conf{$dev}{INHWPORT_STOPBITS});
        $port{$conf{$dev}{INHWPORT}}{OBJ}->buffers(4096, 4096);
        $port{$conf{$dev}{INHWPORT}}{OBJ}->read_const_time(50);  # milliseconds
        $port{$conf{$dev}{INHWPORT}}{OBJ}->read_char_time(5);
        $log->debug("Done" );
        $log->debug("-------------------------------------");
       }
   }
 } # foreach $dev
 
     	 $log->debug('-------------------------------------');
    	 foreach my $pp ( keys %port ) { $log->debug($pp); }
    	 $log->debug('-------------------------------------');
 
 # close unused ports
 my $found;
 foreach my $p ( keys %port ) {
   $found=0;
   foreach my $dev ( keys %conf ) {
     $found=1 if $conf{$dev}{OUTHWPORT} eq $p;
   }
   foreach my $dev ( keys %conf ) {
   	$found=1 if $conf{$dev}{INHWPORT} eq $p; 
   }
   if( !$found ) {
     $port{$p}{OBJ}->close;
     delete $port{$p};
     $log->debug("Close port: $p");
   }
 }
}

# --------------------------------------------------------- load_cam_conf -----
sub load_cam_conf {


 %conf_camera = GetCfgs( eval("($query_str)") );     # Load configurations
 $log->debug("Config read as:");
 $log->debug("-------------------------------------");
 foreach my $dev (keys %conf_camera) {
   $log->debug("[$dev]");
   $log->debug("DEVID=$conf_camera{$dev}{DEVID}");
   $log->debug("PTZ_ASSOC_DEVID=$conf_camera{$dev}{PTZ_ASSOC_DEVID}");
   $log->debug("-------------------------------------");
  } # foreach $dev
}


# -------------- VICON port ------------------
#my $vPort = new Device::SerialPort($devVport) || die WriteLog("Can't open $devVport: $!");
#$vPort->handshake("none"); # none / rts / xoff
#$vPort->baudrate(9600);
#$vPort->parity("none"); # none / odd / even
#$vPort->databits(8);
#$vPort->stopbits(1);
#$vPort->buffers(4096, 4096);
#$vPort->read_const_time(50);       # milliseconds
#$vPort->read_char_time(5);         # avg time between read char
# -------------- satellite port ------------------
#my $sPort = new Device::SerialPort($devSport) || die WriteLog("Can't open $devSport: $!");
#$sPort->handshake("none"); # none / rts / xoff
#$sPort->baudrate(9600);
#$sPort->parity("none"); # none / odd / even
#$sPort->databits(8);
#$sPort->stopbits(1);
#$sPort->buffers(4096, 4096);
#$sPort->read_const_time(50);       # milliseconds
#$sPort->read_char_time(5);         # avg time between read char



# --------------------------------------------------------------- WriteLog -----
# write line into logfile
#
sub WriteLog {
  my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=gmtime(time); $year%=100; $mon++;
  my $logName=sprintf(">> $ENV{APL}/var/log/ptz/$logname.log",$year,$mon,$mday,$hour);
  open(LOG,$logName) or die "Unable to write log: $logName";
  print LOG sprintf("%02d%02d%02d%02d%02d%02d ",$year,$mon,$mday,$hour,$min,$sec) or die "Unable to write log: $logName";
  print LOG "@_\n" or die "Unable to write log: $logName";
  close LOG or die "Unable to write log: $logName";
  $log->debug(sprintf("%02d%02d%02d%02d%02d%02d ",$year,$mon,$mday,$hour,$min,$sec),@_);
  return @_;
} # sub WriteLog


# ------------------------------------------------------------------- hex_str -----
sub hex_str {
    my($str) = @_;
    my $s = '';
    for (my $i=0; $i < length($str); $i++ ) {
        $s .= sprintf(' %02X', ord(substr($str,$i,1)));
    }
    return $s;
}

# -------------------------------------------------------------- nonblock -----
#   nonblock($socket) puts socket into nonblocking mode
sub nonblock {
    my $socket = shift;
    my $flags;
    
    $flags = fcntl($socket, F_GETFL, 0)
            or die "Can't get flags for socket: $!\n";
    fcntl($socket, F_SETFL, $flags | O_NONBLOCK)
            or die "Can't make socket nonblocking: $!\n";
}
