#!/usr/bin/perl
#  $Id: ptz_ptcr20bae.pl 6458 2006-11-20 00:55:13Z teetov $
# -----------------------------------------------------------------------------
#  PTZ driver for QuickSet + BAE
# -----------------------------------------------------------------------------
#  Author: Andrey Fomenko
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: (c) videoNEXT LLC, 2004-2005
# -----------------------------------------------------------------------------

use strict;

use POSIX;
use IO::Socket;
use IO::Select;
use Tie::RefHash;
use IO::File;
use Socket;
use Fcntl;
use Tie::RefHash;
use NextCAM::Init;
use LWP::Simple qw($ua get);
use URI::Escape "uri_escape";
use SKM::Session;

use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.engine";

my $log=get_logger('NEXTCAM::PTZ::PROXY');
my $query_str = shift || "'POSITIONCTL'=>'proxy'";
$log->info("Starting PROXY PTZ DRIVER, query string: [$query_str]");


$SIG{HUP}=\&load_dev_conf;
$SIG{INT} = $SIG{TERM} = sub { cleanup(); exit(0) };

my $APL=$ENV{APL};
my (%conf, %sock, $cam,$cmd,$par,$usrpsw,$last_cmd,$last_mode,$cmd_executed,%respond);
my $ETX = 0x03;
my $STX = 0x02;

my %SessData; # Sessions. One session per each unique combination Host+User

load_dev_conf();

# -----------------------------------------------------------------------------
my $TCP_PORT = 7766; # TCP port where PTZ server communicates
# -----------------------------------------------------------------------------

my $socket = IO::Socket::INET->new(PeerAddr => '127.0.0.1',
                                   PeerPort => $TCP_PORT,
                                   Proto     => "tcp",
                                   Type      => SOCK_STREAM)
    or $log->logdie("Couldn't connect to socket $TCP_PORT: $@");

nonblock($socket);

print $socket "PTZ DRIVER\n";

$last_mode='smooth';
$last_cmd='left';

my %commands;
my $ready;
my $trycount = 30;
my %lastcmd;
my $lastcmdtime = time;
my $polling = 0;

while(1) {
	# stage 1 - read from socket everything
	if (defined($cmd=<$socket>)) {
		chomp $cmd;
		$log->debug("COMMAND:[$cmd]");
		next if not $cmd;
		load_dev_conf(),next if $cmd=~/HUP/i;
		next if not $cmd=~/^(\d+)/;
		$cam=$1;
		next if not defined $conf{$cam}; # ignore cameras not belonging this engine
		if(defined($commands{$cam})){
			if($commands{$cam} =~ /speed pt=0,0/ || $commands{$cam} =~ /speed ptz=0,0,\d+/
				|| $commands{$cam} =~ /speed zoom=0/ || $commands{$cam} =~ /speed ptz=\d+,\d+,0/
				|| $commands{$cam} =~ /speed focus=0/
				|| $commands{$cam} =~ /speed iris=0/
				|| $commands{$cam} =~ /speed gain=0/
				)
			{
				; # do not override stop command!
			}else{
				$commands{$cam} = $cmd;
			}
		} else {
			$commands{$cam} = $cmd;
		}
		next; # suck all the commands from queue before going to the rest of loop
	} # if ($cmd=<$socket>)
	
	$cmd = '';
	
	# stage 2 - send commands to cameras
	foreach my $camera (keys %commands){
		$cmd=$commands{$camera};
		delete $commands{$camera};
		next if not $cmd=~/^(\d+)\s(\w+)\s(\w+)[=\s]?([^\s]+)?(\s?.*)$/;
		my ($cam,$mode,$cmd,$par,$options) = ($1,$2,$3,$4,$5);
		my %options =  map {/(\w+)=(.*)/} split(/\s/," $options ");
		$usrpsw = "$conf{$cam}{USRNAME}:$conf{$cam}{PASSWD}" if $conf{$cam}{USRNAME} && $conf{$cam}{PASSWD};
		
		if ($cmd eq "ptz") {
			# handle special ptz command
			my @params = split(',', $par);
			camCmd($cam,$mode,"pt", $params[0].','.$params[1] ,\%options);
			camCmd($cam,$mode,"zoom", $params[2] ,\%options);
		} else {
			# ordinary command
			camCmd($cam,$mode,$cmd,$par,\%options);
		}
		
		$lastcmd{$camera}{CMD} = $cmd;
		$lastcmd{$camera}{MODE} = $mode;
		$lastcmd{$camera}{PAR} = $par;
		$lastcmd{$camera}{OPTS} = \%options;
		$polling = 0;
	}
	
	select(undef,undef,undef,.1) if not $cmd;


	# stage 3 - here we check for timeouts PTZ_PRESET1TIMEOUT
	foreach my $dev (keys %conf) {
		next if not $conf{$dev}->{TIMEOUT};
		next if $conf{$dev}->{TIMEOUT} > time;
		$log->debug("TIMEOUT EXPIRED!");
		$conf{$dev}->{TIMEOUT} = 0;
		my %options = {};
		camCmd($dev,'preset','goto',1,\%options);
		$lastcmd{$dev}{CMD} = 'goto';
		$lastcmd{$dev}{MODE} = 'preset';
		$lastcmd{$dev}{PAR} = 1;
		$lastcmd{$dev}{OPTS} = \%options;
		$polling = 0;
	}
	

} # while(1)




# ----------------------------------------------------------- cmdTransmit -----
sub cmdTransmit {
    my ($dev,$command)=@_;
    
    $log->debug('cmdTransmit( ',$dev, '=> ',$command,')');    
    
    # First open/verify session for this proxy device
    my $id = "$conf{$dev}{DEVIP}-$conf{$dev}{USRNAME}";
    if (! $SessData{$id}{sid}) { # open new session
	my $sid = OpenSession($conf{$dev}{DEVIP}, $conf{$dev}{USRNAME}, $conf{$dev}{PASSWD});
	if (! $sid) {
	    $log->error("Failed to open session for dev=$dev. Host=$conf{$dev}{DEVIP}");
	}
	else {
	    $SessData{$id}{sid} = $sid;
	    $SessData{$id}{updated_at} = time;
	}
    }
    elsif (time - $SessData{$id}{updated_at} > 3600) { # Need to prolong session
	my $ok = ProlongSession($SessData{$id}{sid});
	if (! $ok) {
	    $log->warn("Failed to prolong session for dev=$dev. Host=$conf{$dev}{DEVIP}");
	    # Try to relogin
	    my $sid = OpenSession($conf{$dev}{DEVIP}, $conf{$dev}{USRNAME}, $conf{$dev}{PASSWD});
	    if (! $sid) {
		$SessData{$id}{sid} = '';
		$SessData{$id}{updated_at} = 0;
		$log->error("Failed to open session for dev=$dev. Host=$conf{$dev}{DEVIP}");
	    }
	    else {
		$SessData{$id}{sid} = $sid;
		$SessData{$id}{updated_at} = time;
	    }
	}
	else { # Prolonged OK
	    $SessData{$id}{updated_at} = time;
	}
    }
    
    $ua->default_headers(HTTP::Headers->new('Cookie'=>"PHPSESSID=".$SessData{$id}{sid}));
    
    my $reply;
    my $data = sprintf("<PTZ_Command>do.ptz?dev=%s&%s</PTZ_Command>", $conf{$dev}{CAMERA}, $command);
    my $str='http://'.$conf{$dev}{DEVIP}.'/ptz/cgi-bin/send_message.pl?data='.uri_escape($data);
    $log->debug('cmdTransmit string to send:=>',$str) ;
    eval {
         $reply=get($str);
    };
    $log->error($@) if $@;
    select(undef,undef,undef,.15);   
    $log->debug('cmdTransmit get answer',$reply) ;
} # sub cmdTransmit


# --------------------------------------------------------------- camStop -----
sub camStop
{
    my ($dev) = @_;
    my %options = {};
    camCmd($dev,'speed','pt','0,0',\%options);
}

# -------------------------------------------------------------- camReset -----
sub camReset
{
  my ($dev) = @_;
  my @cmd = ();
  
return

} # sub camReset

# ---------------------------------------------------------------- PTspeed ----
sub PTspeed {
  return;
} # sub PTspeed
# ---------------------------------------------------------------- camCmd -----
sub camCmd {
  my ($dev,$mode,$cmd,$param,$options)=@_;
  my $cmd_str="mode=$mode&$cmd=$param";
  foreach my $key (keys %{ $options }) {
    $cmd_str .= "&$key=$options->{$key}";
  }
  cmdTransmit($dev,$cmd_str);

}


sub nonblock {
    my ($fd) = @_;
    my $flags = fcntl($fd, F_GETFL,0);
    fcntl($fd, F_SETFL, $flags|O_NONBLOCK);
}



# --------------------------------------------------------- load_dev_conf -----
sub load_dev_conf {

    $log->debug('load_dev_conf');
    
    # fisrst, close everything
    foreach my $skt (keys %sock) {
        close($sock{$skt}{SOCK});
        delete $sock{$skt};
    }


    %conf = GetCfgs( eval("($query_str)") );     # Load configurations
    $log->debug("Config read as:");
    $log->debug('-------------------------------------');
    foreach my $dev (keys %conf) {
	$SessData{ "$conf{$dev}{DEVIP}-$conf{$dev}{USRNAME}" } = {
	    sid => '',
	    updated_at => 0
	};
        $log->debug("[$dev]");
        $log->debug("DEVID=$conf{$dev}{DEVID}");
        $log->debug("CAMERAMODEL=$conf{$dev}{CAMERAMODEL}");
        $log->debug("POSITIONCTL=$conf{$dev}{POSITIONCTL}");
        $log->debug("PTZID=$conf{$dev}{PTZID}");
        $log->debug("CAMERA_ID=$conf{$dev}{CAMERA}");
        $log->debug("-------------------------------------");
 
    } # foreach $dev
}
# --------------------------------------------------------- respond -----
sub respond {
    my $data=shift;
    my @tmp=();
    my $command='';
    for($b=0;$b<length($data);$b++) 
    { 
        $tmp[$b]=substr($data,$b,1); 
    }
    if (ord($tmp[2]) == 49)
    {
        %respond='';
        $respond{PAN}=0;
        $respond{TILT}=0;
        $respond{ZOOM1}=$tmp[12];
        $respond{FOCUS1}=$tmp[13];
        $respond{IRIS1}=$tmp[14];
        $respond{GAIN1}=$tmp[15];
        $respond{ZOOM2}=$tmp[22];
        $respond{FOCUS2}=$tmp[23];
        $respond{IRIS2}=$tmp[24];
        $respond{GAIN2}=$tmp[25];
    }
    $log->debug('Respond from camera: Z1=>',ord($respond{ZOOM1}),' F1=>',ord($respond{FOCUS1}),' I1=>',ord($respond{IRIS1}),' G1=>',ord($respond{GAIN1}),' Z2=>',ord($respond{ZOOM2}),' F2=>',ord($respond{FOCUS2}),' I2=>',ord($respond{IRIS2}),' G2=>',ord($respond{GAIN2}));
}

sub cleanup {
    # Close all open sessions
    foreach my $id (keys %SessData) {
	my $sid = $SessData{$id}{sid};
	CloseSession($sid) if CheckSession($sid);
    }
    %SessData = ();
}

END {
    cleanup();
}
