#!/usr/bin/perl
#  $Id:  $
# -----------------------------------------------------------------------------
#  Patrol for PTZ_server
# -----------------------------------------------------------------------------
#  Author: Alex Tsibulnik
#  Edited by:
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT Network Solutions, Inc.
# -----------------------------------------------------------------------------

use strict;
use IO::Socket;
use IO::Select;
use Log::Log4perl "get_logger";

# Tune script for Avatar
my $log;
my $IS_AVATAR = $0 =~ m{/opt/avatar};
if ($IS_AVATAR) {
    Log::Log4perl::init("$ENV{APL}/etc/logger/logger_ptz.conf");
    $log = Log::Log4perl->get_logger("ptz_server");
}
else {
    require "$ENV{APL}/common/bin/logger.patrol";
    $log = get_logger('NEXTCAM::MGEARS::PTZ_PATROL');
}

my $PTZSERVER          = "$ENV{APL}/ptz/bin/PTZ_server";
my $PTZ_CHECK_INTERVAL = 30; # seconds
my $PTZ_TIMEOUT        = 3;  # socket timeout in seconds
my $PTZ_PORT           = 7766;

$log->info('Starting up PTZ_server monitor. Server status: '.check_conn());

# Main
for(;;) {
    check_ptz(); 
    sleep $PTZ_CHECK_INTERVAL;
}

# Routines
sub check_ptz {
    my ($pid) = `ps -au apl -o pid,command|grep '$PTZSERVER'|grep -v grep`=~/^\s*(\d+)\s+/;
    if ($pid) {
	my $chk = check_conn();
	unless ($chk eq 'OK') {
	    # Recheck
	    $log->warn("PTZ_server connection failed: $chk");
	    sleep 10;
	    $chk = check_conn();
	}
	unless ($chk eq 'OK') {
	    $log->warn("Killing PTZ_server due to locked up socket: $chk");
	    kill 15 => $pid;
	    sleep 2;
	    if (kill 0 => $pid) {
		$log->warn("PTZ_server still running after SIGTERM. Will now send SIGKILL");
		kill 9 => $pid;
	    }
    	    
	    sleep 15;
	}
    }
}

sub check_conn {
    my $socket;
    eval {
	my $socket = IO::Socket::INET->new(
    	    PeerAddr => '127.0.0.1',
            PeerPort     => $PTZ_PORT,
            Proto       => "tcp",
    	    Type      => SOCK_STREAM,
	    Timeout   => $PTZ_TIMEOUT
        );
        die("Couldn't connect to socket $PTZ_PORT: $!\n") unless $socket;
        # Register
        print $socket "PTZ MONITOR\n";
        # Send hearbeat
        my $select = IO::Select->new($socket);
        my $num = int(rand(1000000));
        print $socket "HEARBEATREQ: $num\n";
        if ($select->can_read($PTZ_TIMEOUT)) {
    	    my $resp = <$socket>;
    	    #print "resp: $resp\n";
    	    die "Bad response: $resp\n" if $resp!~/HEARTBEATRSP: (\d+)/;
    	    die "Invalid hearbeat ID received: got $1 but $num was sent\n" if $1 != $num;
        }
        else {
    	    die "No response from server for $PTZ_TIMEOUT seconds\n";
        }
    };
    my $err = $@;
    $socket->shutdown(2) if $socket;
    return $err?"ERROR: $err":"OK";
}
