#!/usr/bin/perl -w
#  $Id: ptz_axisv2.pl 8955 2007-10-29 22:08:24Z teetov $
# -----------------------------------------------------------------------------
#  PTZ driver for GrandEye_Halocam cameras, GrandEye_Halocam HTTP API
# -----------------------------------------------------------------------------
#  Author: Starostin Andrey
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: (c) videoNEXT LLC, 2004-2005
# -----------------------------------------------------------------------------

use strict;
use Socket;
use MIME::Base64();
use IO::File;
use IO::Select;
use IO::Socket;
use Fcntl;
use LWP::UserAgent;
use HTTP::Request::Common;

use NextCAM::Init;
use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.engine";

my $log=get_logger('NEXTCAM::PTZ::PTZ_GrandEye_Halocam');

my $query_str = shift || "'POSITIONCTL'=>'GrandEye_Halocam','CAMERAMODEL'=>'GrandEye_Halocam'";
				$log->info("Starting GrandEye_Halocam PTZ DRIVER, query string: [$query_str]");

my $ua = LWP::UserAgent->new();
$log->debug("load_dev_conf 1");
$SIG{HUP}=\&load_dev_conf;
my $APL=$ENV{APL};
my $APL_CONF=$ENV{APL_CONF};
my (%conf,$cam,$cmd,$usrpsw,$par,$state_pt,$old_pan,$old_tlt,$state_zoom,$old_zoom,$state_dev,%state_options);
load_dev_conf();
$log->debug("load_dev_conf 2");

# -----------------------------------------------------------------------------
my $TCP_PORT = 7766; # TCP port where PTZ server communicates
# -----------------------------------------------------------------------------

my $socket = IO::Socket::INET->new(PeerAddr => '127.0.0.1',
			PeerPort => $TCP_PORT,
			Proto     => "tcp",
			Type      => SOCK_STREAM)
or $log->logdie("Couldn't connect to socket $TCP_PORT: $@");

nonblock($socket);

print $socket "PTZ DRIVER\n";

#$last_mode='smooth';
#$last_cmd='left';
$state_pt = 0;
$state_zoom = 0;
$state_dev = 0;

my %commands;
my $ready;
my $trycount = 30;

while(1) {
	if ($state_pt == 1)
	{
		speed_pt($old_pan, $old_tlt);
	}
	if ($state_zoom == 1)
	{
		speed_zoom($old_zoom);
	}
	
	$log->debug("STAGE0");
	# stage 1 - read from socket everything
	if (defined($cmd=<$socket>)) {
		chomp $cmd;
		$log->debug("COMMAND:[$cmd]");
		next if not $cmd;
		load_dev_conf(),next if $cmd=~/HUP/i;
		next if not $cmd=~/^(\d+)/;
		$cam=$1;
		next if not defined $conf{$cam}; # ignore cameras not belonging this engine
		if(defined($commands{$cam})){
			if($commands{$cam}=~/speed pt=0,0/ || $commands{$cam}=~/speed zoom=0/ || $commands{$cam}=~/speed focus=0/ || $commands{$cam}=~/speed iris=0/ || $commands{$cam}=~/speed gain=0/  || $commands{$cam}=~/speed ptz=0,0,0/)
			{
				; # do not override stop command!
			}else{
				$commands{$cam} = $cmd;
			}
		} else {
			$commands{$cam} = $cmd;
		}
		next; # suck all the commands from queue before going to the rest of loop
	} # if ($cmd=<$socket>)
	$log->debug("STAGE1");
	
	$cmd = '';
	
	# stage 2 - send commands to cameras
	foreach my $camera (keys %commands){
		$cmd=$commands{$camera};
		delete $commands{$camera};
		next if not $cmd=~/^(\d+)\s(\w+)\s(\w+)[=\s]?([^\s]+)?(\s?.*)$/;
		my ($cam,$mode,$cmd,$par,$options) = ($1,$2,$3,$4,$5);
		my %options =  map {/(\w+)=(.*)/} split(/\s/," $options ");
		#my $str = str_str(%options);
		%state_options = %options;
		$usrpsw = '';
		$usrpsw = "$conf{$cam}{USRNAME}:$conf{$cam}{PASSWD}" if $conf{$cam}{USRNAME} && $conf{$cam}{PASSWD};
		
		if ($cmd eq "ptz") {
			# handle special ptz command
			my @params = split(',', $par);
			camCmd($cam,$mode,"pt", $params[0].','.$params[1] ,\%options);
			camCmd($cam,$mode,"zoom", $params[2] ,\%options);
		} else {
			# ordinary command
			camCmd($cam,$mode,$cmd,$par,\%options);
		}
	}
	$log->debug("STAGE2");

	select(undef,undef,undef,.1) if not $cmd;

	# stage 3 - here we check for timeouts PTZ_PRESET1TIMEOUT
	foreach my $dev (keys %conf) {
		next if not $conf{$dev}->{TIMEOUT};
		next if $conf{$dev}->{TIMEOUT} > time;
		$log->debug("TIMEOUT EXPIRED!");
		$conf{$dev}->{TIMEOUT} = 0;
		my %options = {};
		camCmd($dev,'preset','goto',1,\%options);
	}
	$log->debug("STAGE3");
	
	if(!$cmd) {
		select(undef,undef,undef,.4);
		if(!$trycount--) {
			$trycount = 30;
			print $socket "test\0" or $log->logdie("Couldn't communicate to socket $TCP_PORT: $@");
		}
	}

} # while(1)




# =============================================================================

# ---------------------------------------------------------------- camCmd -----
sub camCmd
{
	my ($dev,$mode,$cmd,$param,$options)=@_;
	my %options = %$options;
	$log->debug("dev=$dev mode=$mode cmd=$cmd param=$param options=$options");
	
	$log->debug("camCmd: DEVID=[$dev] mode=[$mode] command:[$cmd] param=[$param] ");
	my $spd     = ($options{speed}=~/^\d+/) ? $options{speed}:$conf{$dev}->{PTZSPEED};
	my $zoomspd = $conf{$dev}->{PTZZOOMSPEED};
	$state_dev  = $dev;
	
	#mode=rel cmd=size par=480x360
	if ($mode=~/rel/i)
	{
		if ($cmd=~/size/i)
		{
			#cam=4 mode=rel cmd=size par=480x360 options= xy=458,348
			my ($maxX,$maxY) = split( /x/, $param);
			my ($clickX,$clickY) = split( /,/, $options{xy});
			#http://192.168.0.200/admin/getparam.cgi?pan&tilt&zoom
			#my $URL="http://$conf{$dev}{DEVIP}:$conf{$dev}{HTTP_PORT}/com/ptz.cgi?camera=$conf{$dev}{PTZID}";
			my $res = checkURL("http://$conf{$dev}{DEVIP}:$conf{$dev}{HTTP_PORT}/admin/getparam.cgi?vcamazoom1");
			my($tmp,$zoomX) = split(/\=/,$res);
			chomp($zoomX);
			$zoomX = 10000 - $zoomX;
			my $a = 0.0086 * $zoomX * (3.14 / 180) / 2;
			my $A = ( sin($a) / cos($a) ) * $zoomX;
			$a = $a * (180 / 3.14);
			my $ax = -($clickX - $maxX/2) / ($maxX / $a);
			my $ay = -($clickY - $maxY/2) / ($maxY / $a);
			my $URL="http://$conf{$dev}{DEVIP}:$conf{$dev}{HTTP_PORT}/com/ptz.cgi?camera=$conf{$dev}{PTZID}";
			checkURL("$URL&rpan=$ax&rtilt=$ay");
		}
	}
	if ($mode=~/step/i)
	{
		my $URL="http://$conf{$dev}{DEVIP}:$conf{$dev}{HTTP_PORT}/com/ptz.cgi?camera=$conf{$dev}{PTZID}";
		if($cmd=~/move/i)
		{
			my $pan = $param=~/left/i? $spd/30 : $param=~/right/i? -$spd/30 : 0;
			my $tlt = $param=~/down/i? -$spd/30 : $param=~/up/i? $spd/30 : 0;
			$pan = $pan + 720 if $pan < -360;
			$pan = $pan - 720 if $pan > 360;
			$tlt = $tlt + 720 if $tlt < -360;
			$tlt = $tlt - 720 if $tlt > 360;
			#$ua->request(POST "$URL&rpan=$pan&rtilt=$tlt", []);
			checkURL("$URL&rpan=$pan&rtilt=$tlt");
			#http://192.168.0.200/admin/getparam.cgi?pan&tilt&zoom
			#checkURL("http://$conf{$dev}{DEVIP}:$conf{$dev}{HTTP_PORT}/admin/getparam.cgi?pan&tilt&zoom");
			#checkURL("http://$conf{$dev}{DEVIP}:$conf{$dev}{HTTP_PORT}/getrtc.cgi");
		}
		if($cmd=~/zoom/i)
		{
			my $zoom = $param=~/in/i? -$zoomspd * 5 : $param=~/out/i? $zoomspd * 5 : 0;
			checkURL("$URL&rzoom=$zoom");
		}
	}
	#dev=&mode=preset&goto=1&"
	if ($mode=~/preset/i)
	{		
		if ($cmd=~/goto/i)
		{
			my $URL="http://$conf{$dev}{DEVIP}:$conf{$dev}{HTTP_PORT}/admin/viewpreset.cgi?camera=$conf{$dev}{PTZID}";		
			checkURL("$URL&num=$param");
		}
		if ($cmd=~/save/i)
		{		
			my $URL="http://$conf{$dev}{DEVIP}:$conf{$dev}{HTTP_PORT}/admin/setpreset.cgi?camera=$conf{$dev}{PTZID}";
			checkURL("$URL&num=$param");
		}
	}
	if ($mode=~/speed/i)
	{
		if($cmd=~/pt/i)
		{
			my ($pan,$tlt) = split( /,/, $param);
			$old_pan = $pan;
			$old_tlt = $tlt;
			
			if ($pan == 0 && $tlt == 0)
			{
				$state_pt = 0;
			} elsif ($state_pt == 0) {
				$state_pt = 1;
			}
		}
		if($cmd=~/zoom/i)
		{
			$state_zoom = 1;
			my $zoom = $param;
			$old_zoom = -($zoom * $zoomspd * 5 / 100);
			$log->debug("ZOOM $zoom $old_zoom $spd");
			
			if ($zoom == 0)
			{
				$state_zoom = 0;
			} elsif ($state_zoom == 0) {
				$state_zoom = 1;
			}
		}
	}

	#$last_mode= $mode;
	#$last_cmd = $cmd;
}

sub speed_pt{
	my ($pan,$tlt) = @_;
	my $spd = ($state_options{speed}=~/^\d+/) ? $state_options{speed}:$conf{$state_dev}->{PTZSPEED};
	$pan = -($pan * $spd / 3000);
	$tlt = -($tlt * $spd / 3000);
	$pan = $pan + 720 if $pan < -360;
	$pan = $pan - 720 if $pan > 360;
	$tlt = $tlt + 720 if $tlt < -360;
	$tlt = $tlt - 720 if $tlt > 360;

	my $URL="http://$conf{$state_dev}{DEVIP}:$conf{$state_dev}{HTTP_PORT}/com/ptz.cgi?camera=$conf{$state_dev}{PTZID}";	
	checkURL("$URL&rpan=$pan&rtilt=$tlt");

}
sub speed_zoom{
	my($zoom) = @_;
	my $URL="http://$conf{$state_dev}{DEVIP}:$conf{$state_dev}{HTTP_PORT}/com/ptz.cgi?camera=$conf{$state_dev}{PTZID}";
	checkURL("$URL&rzoom=$zoom");

}


# ------------------------------------------------------------- UpdatePID -----
sub UpdatePID {
	open(PID,"> $APL/var/ptz/ptz_grandeye_halocam.pid");
	print PID $$;
	close PID;
} # sub UpdatePID

# --------------------------------------------------------- load_dev_conf -----
sub load_dev_conf {
	%conf = GetCfgs( eval("($query_str)") );     # Load configurations
	my $ids='';
	foreach my $dev (keys  %conf) {
		next if not $conf{$dev}->{PTZID} =~/[12]/;
		next if not $conf{$dev}->{DEVIP};
		$ids.=" $dev";
		camParams($dev);
	}
	$log->info("Loaded configurations for cameras:$ids");
}

# ------------------------------------------------------------- camParams -----
sub camParams {
	my ($_dev)=@_;

	$conf{$_dev}{pan}=1;
	$conf{$_dev}{tilt}=1;
	$conf{$_dev}{zoom}=1000;
	$conf{$_dev}{speed}=100;
	
	$conf{$_dev}{span}=50;
	$conf{$_dev}{stilt}=50;
	$conf{$_dev}{szoom}=50;
	
	$conf{$_dev}{p_pos}=0;
	$conf{$_dev}{t_pos}=0;
	$conf{$_dev}{z_pos}=0;
} # sub camParams


# -------------------------------------------------------------- checkURL -----
sub checkURL {
	my($url)=@_;  #print "URL: $url\n";
	$log->debug("checkURL($url)");
	my $req = HTTP::Request->new(GET => $url);
	$req->authorization_basic('admin', 'admin');
	return $ua->request($req)->content;
} # sub checkURL

# ----------------------------------------------------------- truncDigits -----
sub truncDigits{
	my($val)=@_;
	return sprintf("%5.5f",$val)
} # sub truncDigits

# -------------------------------------------------------------- nonblock -----
#   nonblock($socket) puts socket into nonblocking mode
sub nonblock {
	my $socket = shift;
	my $flags;
	
	$flags = fcntl($socket, F_GETFL, 0)
	or die "Can't get flags for socket: $!\n";
	fcntl($socket, F_SETFL, $flags | O_NONBLOCK)
	or die "Can't make socket nonblocking: $!\n";
}
