#!/usr/bin/perl
#  $Id: proccfg.pl 33202 2015-10-22 23:54:44Z atsybulnik $
# -----------------------------------------------------------------------------
# Update daemon activation list based on conf-files
# -----------------------------------------------------------------------------
#  Author: Andrey Fomenko
#  Edited by: Dmitriy Astaltsev
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

use strict;
use Socket;
use IO::File;
use IO::Select;
use IO::Socket;
use Fcntl;
use SKM::PM;


use NextCAM::Init;
use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.engine";

my $log=get_logger('NEXTCAM::PTZ::PTZ_AXISV2');

my ($APL,$APL_CONF,$logname)=($ENV{APL},$ENV{APL_CONF},'proccfg-%02d%02d%02d');
$log->logdie('Set $APL/$APL_CONF before start') if !$APL or !$APL_CONF;

my (%conf,$key,%ptz,%rs,%misc);

my $KEEPLOGDAYS = 10; # Number of days to keep log files
# ============================= ACTUAL LOGIC ===================================

WriteLog('Configuration recheck started');
%conf = GetCfgs();
# ------------------------------------------------------------ PTZ engines -----

foreach my $dev ( sort keys %conf ) {
  next if not $dev=~/^\d/; # skip everithing except cameras
  next if not $conf{$dev}{POSITIONCTL} or ($conf{$dev}{POSITIONCTL} eq 'none');
  next if $conf{$dev}{AVATARID}; # Disable activating PTZ for Avatar cameras on Stratus
  $log->debug("$dev");
  $ptz{ptz_pelco}='pelco'			if $conf{$dev}{POSITIONCTL} =~/^Pelco(?!SpectraIP)/i;
  $ptz{ptz_axis}='axis'			    if $conf{$dev}{POSITIONCTL} =~/^Axis/i;
  $ptz{ptz_udp}='UDP'			    if $conf{$dev}{POSITIONCTL} =~/^UDP/i;
  $ptz{ptz_dantesecurity}='DanteSecurity'                       if $conf{$dev}{POSITIONCTL} =~/^DanteSecurity/i;
  $ptz{ptz_grandeye_halocam}='grandeye_halocam'	if $conf{$dev}{POSITIONCTL} =~/^GrandEye_Halocam/i;  
  $ptz{ptz_icd001}='icd001'			if $conf{$dev}{POSITIONCTL} =~/^ICD001/i;
  $ptz{ptz_sonyVISCA}='sonyvisca'	if $conf{$dev}{POSITIONCTL} =~/^SonyVISCA/i;
  $ptz{ptz_sonySNC}='sonysnc'		if $conf{$dev}{POSITIONCTL} =~/^SonySNC/i;
  $ptz{ptz_xviewpelco}='xviewpelco'	if $conf{$dev}{POSITIONCTL} =~/^XviewPelco/i;
  $ptz{ptz_ptcr20bae}='ptcr20bae'	if $conf{$dev}{POSITIONCTL} =~/^ptcr20bae/i;
  $ptz{ptz_ptcr20flir}='ptcr20flir'	if $conf{$dev}{POSITIONCTL} =~/^ptcr20flir/i;
  $ptz{ptz_pvpaeo}='pvpaeo'		if $conf{$dev}{POSITIONCTL} =~/^pvpaeo/i;
  $ptz{ptz_odis}='odis'			if $conf{$dev}{POSITIONCTL} =~/^odis/i;
  $ptz{ptz_gemineye}='gemineye'			if $conf{$dev}{POSITIONCTL} =~/^gemineye/i;
  $ptz{ptz_toshibaIKWB}='toshibaikwb' if $conf{$dev}{POSITIONCTL} =~/^ToshibaIKWB/i;
  $ptz{ptz_vicon_retr}='vicon_switch' if $conf{$dev}{POSITIONCTL} =~/^vicon_switch/i;
  $ptz{ptz_Panasonic}='panasonic' if $conf{$dev}{POSITIONCTL} =~/^PanasonicPTZ/i;
  $ptz{ptz_ptl10ge}='ptl10ge' if $conf{$dev}{POSITIONCTL} =~/^ptl10ge/i;
  $ptz{ptz_vchain}='vchain' if $conf{$dev}{POSITIONCTL} =~/^vchain/i;
  $ptz{ptz_flir_35x140}='flir' if $conf{$dev}{POSITIONCTL} =~/^FLIR_35x140/i;
  $ptz{ptz_pelco_spectraip}='pelco'	if $conf{$dev}{POSITIONCTL} =~/^PelcoSpectraIP/i;
  $ptz{ptz_hikvision}='hikvision' if $conf{$dev}{POSITIONCTL} =~/^hikvision/i;
} # foreach my $dev

eval {
	toggleProcess(0, 'ptz_sonyVISCA', 'ptz_axis', 'ptz_nve', 'ptz_grandeye_halocam', 'ptz_icd001',
		'ptz_pelco', 'ptz_pvpaeo', 'ptz_odis', 'ptz_gemineye', 'ptz_pelco_spectraip', 'ptz_sonySNC', 'ptz_xviewpelco',
		'ptz_toshibaIKWB', 'ptz_ptcr20bae', 'ptz_ptcr20flir', 'ptz_vicon_retr', 'ptz_Panasonic',
		'ptz_Panasonic_WV', 'pbl_patrol', 'ptz_ptl10ge', 'ptz_vchain', 'ptz_flir_35x140', 'ptz_hikvision');
	toggleProcess(1, keys %ptz);
};
$log->logdie("Failed to update PTZ processes configuraiton: $@") if ($@);


# --------------------------------------------------------- relays/sensors -----

foreach my $dev ( sort keys %conf ) {
  next if not $dev=~/^[rse]/; # skip everything but relays/sensors/modbus
  $log->debug("$dev");
  $rs{spo_rl8d}='spo_rl8'	if $conf{$dev}{HW_MODEL} eq 'SPO_RL8';
  $rs{xio_axisd}='axis'		if $conf{$dev}{HW_MODEL} eq 'AXIS';
  $rs{xio_actid}='acti'		if $conf{$dev}{HW_MODEL} eq 'ACTi';
  $rs{xio_sonyd}='sony'		if $conf{$dev}{HW_MODEL} eq 'SONY';
  $rs{xio_apcmsd}='apc_ms'	if $conf{$dev}{HW_MODEL} eq 'APC_MS';
  $rs{adr2200d}='adr2200'	if $conf{$dev}{HW_MODEL} eq 'ADR2200';
  $rs{modbusd}='modbus'		if $conf{$dev}{HW_MODEL} eq 'MODBUS';
  $rs{relayd}='relay'		if $conf{$dev}{MODELID}  eq 'SKM';
}

WriteLog('Activating XIO engines: ',(keys %rs));

my @activeSensorRelay = ();
foreach my $engine ( keys %rs ) {
  if($engine ne 'modbusd' and $engine ne 'relayd') {
      eval {
        local $SIG{ALRM}=sub{die 'ALARM'};
        alarm 2;
        open(F,"+>>$APL/var/xio/$rs{$engine}");
	print F "HUP\n";
	close F;
    };
    alarm 0;
  }
  push @activeSensorRelay, $engine;
}

eval {
	toggleProcess(0, 'spo_rl8d', 'xio_axisd', 'xio_actid', 'xio_apcmsd', 'adr2200d', 'modbusd', 'relayd');
	toggleProcess(1, @activeSensorRelay);
};
$log->logdie("Failed to update XIO processes configuraiton: $@") if ($@);



WriteLog('Activating PTZ engines: ',(keys %ptz));

my $TCP_PORT = 7766; # TCP port where PTZ server communicates
my $socket = IO::Socket::INET->new(PeerAddr => '127.0.0.1',
                                   PeerPort => $TCP_PORT,
                                   Proto     => "tcp",
                                   Type      => SOCK_STREAM);

if(!$socket) {
    $log->warn("Couldn't connect to socket $TCP_PORT: $@");
}
else {
    nonblock($socket);
    print $socket "PTZ CLIENT\n";
    print $socket "HUP\n";
    $socket->close();
}

############################################################################
#                  SUBROUTINE SECTION                                    ###

# --------------------------------------------------------------- WriteLog -----
# write line into logfile
#
sub WriteLog {
  my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=gmtime(time); $year%=100; $mon++;
  my $logName=sprintf(">> $ENV{APL}/var/log/$logname.log",$year,$mon,$mday,$hour);
  open(LOG,$logName) or die "Unable to write log: $logName";
  print LOG sprintf("%02d%02d%02d%02d%02d%02d ",$year,$mon,$mday,$hour,$min,$sec) or die "Unable to write log: $logName";
  print LOG "@_\n" or die "Unable to write log: $logName";
  close LOG or die "Unable to write log: $logName";
  $log->debug(sprintf("%02d%02d%02d%02d%02d%02d ",$year,$mon,$mday,$hour,$min,$sec),@_);
} # sub WriteLog

# -------------------------------------------------------------- nonblock -----
#   nonblock($socket) puts socket into nonblocking mode
sub nonblock {
    my $socket = shift;
    my $flags;
    
    $flags = fcntl($socket, F_GETFL, 0)
            or die "Can't get flags for socket: $!\n";
    fcntl($socket, F_SETFL, $flags | O_NONBLOCK)
            or die "Can't make socket nonblocking: $!\n";
}

END { # Clean old logs
    `find $APL/var/log -maxdepth 1 -type f -name 'proccfg-*.log' -mtime +${KEEPLOGDAYS} -delete`;
}
# ----------===== Changes log =====----------
# $Log$
# Revision 1.24  2006/11/02 19:50:37  afomenko
# ptcr20flir state reevaluation corrected
#
# Revision 1.23  2006/10/17 20:21:31  afomenko
# "ptz_ptcr20flir" added
#
# Revision 1.22  2006/09/29 19:42:45  afomenko
# moved potentially failing logic to after DB commit
#
# Revision 1.21  2006/09/27 14:40:02  afomenko
# fixed problem preventing script to make initial process reevaluation upon first start after software [re]install: it was trying to connect to PTZ legacy port 7766 and engine was not started yet. FIX: report this situation in log but continue processing
#
# Revision 1.20  2005/10/17 17:44:35  afomenko
# logger include file changed
#
# Revision 1.19  2005/09/22 20:28:03  afomenko
# CR?LF
#
# Revision 1.18  2005/08/30 15:49:30  posox
# panasonic wv
#
# Revision 1.17  2005/07/06 20:24:10  posox
# add PanasonicPTZ
#
# Revision 1.16  2005/04/21 13:25:15  afomenko
# fix in process anme for XVIew
#
# Revision 1.15  2005/04/20 13:49:42  afomenko
# PTZ: sending HUP through socket instead of pipes - "\n" added
#
# Revision 1.14  2005/04/20 13:40:54  afomenko
# PTZ: sending HUP through socket instead of pipes
#
# Revision 1.13  2004/11/30 00:17:55  afomenko
# ICD001 type of PTZ added
#
# Revision 1.12  2004/08/23 15:51:41  afomenko
# "vicon_switch" added as PTZ engine
#
# Revision 1.11  2004/08/13 22:32:18  afomenko
# added ptcr20bae
#
# Revision 1.10  2004/07/02 19:57:46  afomenko
# Added standard comments
#
