<!DOCTYPE html>
<html>
    <head>
    <title>MediaPlayer Demo</title>
<?php
    if (!$_GET['dev'])
    {
        echo "Please specify dev number!";
        exit;
    }
    if (!$_GET['format'])
    {
//	   echo "Please specify video format (mpeg4/mjpeg/pcm)!";
//	   exit;
    }
    $format = $_GET['format'];
    if ($format =='mpeg4') $format='mp4media';
    else if ($format =='mjpeg') $format='mjpegmedia';
    else if ($format == 'pcm') $format='pcmmedia';
    else if ($format == 'aac') $format='aacmedia';
    else if ($format == 'x') $format='xmedia';
    else 
    {
       $format = 'xmedia';
  //      echo "Incorrect media format. Format must be one from mpeg4/mjpeg/pcm/aac/x!";
//	    exit;
    }
?>
    <style>
    <!--
        label {color: #009966}
        body {font-family: tahoma; font-size: 9px;}
    -->
    </style>
    
    <script>
        
        var isBufferBlockDisplayed = false;
	    var playingLive = false;
        var stepMode = false;
        var currentFrameSec = 0;
        var mcast = 0;
               
        function onNewStatus(status)
        {
            var st = document.getElementById("status");
            
            if (status == 0)
            {
                st.innerHTML = "IDLE";    
            }
            else if (status == 1)
            {
                st.innerHTML = "PLAY_FROM_SERVER";
            }
            else if (status == 2)
            {
                st.innerHTML = "PLAY_FROM_BUFFER";
            }
            else if (status == 3)
            {
                st.innerHTML = "STOP";
    
                document.getElementById('stop').disabled=true;
                document.getElementById('play_f').disabled=false;
                document.getElementById('play_b').disabled=true;
                document.getElementById('pause').disabled=true;
                document.getElementById('step').checked=false;
                document.getElementById('step').onclick();
                document.getElementById('step').disabled=true;
                
            }
            
        }
        
        function onNewImage(sec, dsec, bufferLBSec, bufferLBDSec, bufferRBSec, bufferRBDSec)
        {
            var timeBlock;
			var timeLabel;
            var date = new Date(sec*1000);
            var date_formatted = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds()  +  "." + (dsec<10?"0"+dsec:dsec);
            if (playingLive)
			{
                document.getElementById("liveTime").innerHTML = date_formatted;
			}
			else
			{
                document.getElementById("archiveTime").innerHTML = date_formatted;
			}
            
            currentFrameSec = sec;
            
            onChangeBufferValue(bufferLBSec, bufferLBDSec, bufferRBSec, bufferRBDSec);
            
        }

        function onChangeBufferBoundaries(lsec, ldsec, rsec, rdsec)
        {
        
        }
        
        function onImageClick(x, y) 
        {
            alert(x + ", " + y);
        }

        function onChangeBufferValue(bufferLBSec, b, bufferRBSec, d)
        {
            var value;
            if (bufferRBSec < currentFrameSec)
            {
                value = "0";
            }
            else
            {
                value = Math.round(((currentFrameSec - bufferLBSec)*100)/(bufferRBSec-bufferLBSec), 0);
                
            }
            
            if (value == "0") value == "1";
            
            document.getElementById("buffer").innerHTML = value + "%";
            
           /* if (value=="0" && isBufferBlockDisplayed)
            {
                document.getElementById("bufferBlock").style.display="none";
                
              
                isBufferBlockDisplayed = false;
            }
            else if (value!="0" && !isBufferBlockDisplayed)
            {
                document.getElementById("bufferBlock").style.display="inline";
                isBufferBlockDisplayed = true;
            }*/
            document.getElementById("bufferBlock").style.display="inline";
            
             
        }
        
        function stop()
        {
            document.getElementById("demo").sendCommand("stop");
            document.getElementById("bufferBlock").style.display="none";
            
            document.getElementById("streamType").disabled=false;
            
            
            document.getElementById("streamSpeed").options[2].selected = true;     
            document.getElementById("streamSpeed").disabled=true;
			
			document.getElementById("liveTimeBlock").style.display="none";
		    document.getElementById("archiveTimeBlock").style.display="none";
        }
        
        function pause()
        {
            document.getElementById("demo").sendCommand("pause");
        }
        
        function snapshot()
        {
            document.getElementById("demo").setParameter("snapshotFileName", "snapshot.jpg");
            document.getElementById("pause").onclick();
            document.getElementById("demo").sendCommand("snapshot");
        }

        function play()
        {
            //pause(); 
            if (document.getElementById('opt_form').video[0].checked)
            {
                playLive();
				playingLive = true;
				document.getElementById("liveTimeBlock").style.display="";

            }
            else
            {
                playArchive();
				playingLive = false;

			    document.getElementById("archiveTimeBlock").style.display="";
            }
            
            document.getElementById("stop").disabled=false;
            document.getElementById("pause").disabled=false;
            document.getElementById("streamType").disabled=true;
            
            document.getElementById("streamSpeed").disabled=false;
        }
        
        function playLive()
        {
            var analytics = document.getElementById("analytics").checked?1:0;
            var demo_applet = document.getElementById("demo");
<?php if (!isset($_GET['audioonly']))
{
?>            
        var videoURL = "rtsp://<? echo $_SERVER['SERVER_ADDR'] ?>:8554/<? echo $format ?>?dev=<?echo $_GET['dev']?>&authorizationid=4f09a62e637f0711db185cd1001372570b4ai&analytics="+analytics+"&mcast="+mcast;
        demo_applet.setParameter("videoURL", videoURL);
<?php
}
?>

<?php if (isset($_GET['audio']) || isset($_GET['audioonly']))
      {
?>
        var audioURL = "rtsp://<? echo $_SERVER['SERVER_ADDR'] ?>:8554/xmedia?dev=<? echo $_GET['dev']?>&authorizationid=4f09a62e637f0711db185cd1001372570b4a";
            demo_applet.setParameter("audioURL", audioURL);
<?php
      }
?>
          
            demo_applet.sendCommand("play");
        }
        
        function playArchive()
        {
            if (document.getElementById("date").value == "")
            {
                alert("Incorrect date");      
                return;     
            }
          
            var startDateTime = new Date(document.getElementById("date").value + " " 
                                    + document.getElementById("startTime").value /*+ ":00"*/);
            var endDateTime   = new Date(document.getElementById("date").value + " "
                                    + document.getElementById("endTime").value /*+ ":00"*/);
<?php if (!isset($_GET['audioonly']))
{
?>                  
            var videoURL = new String("rtsp://<? echo $_SERVER['SERVER_ADDR'] ?>:8554/<?echo $format?>?dev=<?php echo $_GET['dev']?>&authorizationid=4&start="+Math.round(startDateTime.getTime()/1000)
                    + "&end="+Math.round(endDateTime.getTime()/1000));
             
            document.getElementById("demo").setParameter("videoURL", videoURL);
<?php
      }
?>        
                      
<?php if (isset($_GET['audio']) || isset($_GET['audioonly']))
      {
?>
            var audioURL = new String("rtsp://<? echo $_SERVER['SERVER_ADDR'] ?>:8554/xmedia?dev=<?php echo $_GET['dev']?>&start="+Math.round(startDateTime.getTime()/1000)
                    + "&end="+Math.round(endDateTime.getTime()/1000));
            document.getElementById("demo").setParameter("audioURL", audioURL);
<?php
      }
?>            
            
            
            
            document.getElementById("demo").sendCommand("play");
         }


        function jumpToTimestamp()
        {
            var startDateTime = new Date(document.getElementById("date").value + " " 
                + document.getElementById("jumpStartTime").value);
           
            document.getElementById("demo").setParameter("jump2timestamp", Math.round(startDateTime.getTime()/1000));
            
        }
        
        function jumpToTimestampInFuture()
        {
            var startDateTime = new Date("October 18, 2007" + " " 
                + document.getElementById("jumpStartTime").value + ":00");
           
            document.getElementById("demo").setParameter("jump2timestamp", Math.round(startDateTime.getTime()/1000));
            
        }
        
        function jumpToTimestampInMiddle()
        {
            document.getElementById("demo").setParameter("jump2timestamp", currentFrameSec - 2);            
        }
        
        function setAppletSize(size)
        {
            var posX;
            if ((posX=size.indexOf("x")) == -1)
            {
                alert("Incorrect size!");
                return;
            }
            
            var width  = size.substr(0, posX);
            var height = size.substr(posX+1, size.length);
            
            document.getElementById("demo").width = width;
            document.getElementById("demo").height = height;
            
            document.getElementById("div_demo").style.width = width;
            document.getElementById("div_demo").style.height = height;     
        }
        
        function setStream(type)
        {
            var demo = document.getElementById('demo');
            mcast = 0;
            if (type == "streamOverUDPMulticast")
            {
                 mcast = 1;
                 demo.setParameter('streamOverTCP', '0');
                 demo.setParameter('streamOverHTTP', '0');
            }
            else if (type == "streamOverUDP")
            {
                 demo.setParameter('streamOverTCP', '0');
                 demo.setParameter('streamOverHTTP', '0');
            }
            else if (type == "streamOverTCP")
            {
                demo.setParameter('streamOverTCP', '1');
                demo.setParameter('streamOverHTTP', '0');
            }
            else if (type == "streamOverHTTP")
            {
                demo.setParameter('streamOverTCP', '1');
                demo.setParameter('streamOverHTTP', '1');
            }
        }
        
        function getMixers()
        {
           var recorder =  document.getElementById('recorder');
           var mixers = new String(recorder.getAllInputDevices());
           mixers = mixers.split("|");

           var mixerList = document.getElementById("mixerList");
           for (var i=0, j=1;i<mixers.length-1;i++)
           {
              if (mixers[i].indexOf("Java") != -1) continue; // ignore java mixers. they are incompatible with us 
              mixerList.options[j] = new Option(mixers[i], i);
              j++;
           }

           document.getElementById('mixerList').disabled = false;
           document.getElementById('startRecording').disabled = false;
         

        }
        function setMixer(index)
        {
           var recorder =  document.getElementById('recorder');
           recorder.setInputDevice(index*1);
        }

        function startRecording()
        {
           var recorder =  document.getElementById('recorder');

           if (!recorder.isConfigured())
           {
              alert("NOT YET CONFIGURED!");
          
           }
           else
           {
                 recorder.startRecording("rtsp://<? echo $_SERVER['SERVER_ADDR'] ?>:8554/<?echo $format?>?dev=<? echo $_GET['dev']?>&authorizationid=4f09a62e637f0711db185cd1001372570b4ai", 15);

           document.getElementById('startRecording').disabled = true;
           document.getElementById('stopRecording').disabled = false;

           }

        }
       
        function stopRecording()
        {
           var recorder =  document.getElementById('recorder');

           recorder.stopRecording();

           document.getElementById('startRecording').disabled = false;
           document.getElementById('stopRecording').disabled = true;
        }

           function onAudioRecorderError(error_string)
           {
              if (error_string != null)
              {
                 alert("Error: " + error_string);
              }
              
              document.getElementById('startRecording').disabled = false;
              document.getElementById('stopRecording').disabled = true;
           }
               
           function onAudioRecorderReady()
           {
              getMixers();
           }

           function onAudioRecorderTimeout()
           {
               document.getElementById('startRecording').disabled = false;
               document.getElementById('stopRecording').disabled = true;
           }


        
    </script>
    
</head>
<!-- <body onload="document.getElementById('play_f').onclick()"> -->
<body>
<table>
<tr>
    <td>
        <div style="border-width:1px;border-style:solid;width:640px;height:480px;" id="div_demo"> 
                <applet
                    code="MediaPlayer.class"
                    archive="/common/activex/MediaPlayer.jar, /wheels/json.jar"
                    codebase="http://<? echo $_SERVER['SERVER_ADDR'] ?>/"
                    id="demo"
                    width="640"
                    height="480"
                    mayscript>
                    <param name="BASEURL" value="http://<? echo $_SERVER['SERVER_ADDR'] ?>/"/>
                    <param name="CACHESIZE" value="0M"/>
                    <param name="PLAYER_VERSION" value="<? echo rtrim(file_get_contents('/opt/sarch/base/etc/VERSION')) ?>"/>
                    <param name="BGCOLOR" value="0x111111"/>
 
                    <param name="onStatusChange" value="onNewStatus"/>
                    <param name="onNewImage" value="onNewImage"/>
                    <param name="onBufferChange" value="onChangeBufferValue"/> 
                    <param name="onImageClick" value="onImageClick"/>  


                     <hr/>
                    Your browser does not support Java.
                    Please download <a href="http://java.com:80/en/download/manual.jsp">last version of JRE</a> for your platform
                    <hr/>

                </applet>

                           <applet
                    code="AudioRecorder.class"
                    archive="/common/activex/MediaPlayer.jar, /wheels/json.jar"
                    codebase="http://<? echo $_SERVER['SERVER_ADDR'] ?>/"
                    id="recorder"
                    width="0"
                    height="1"
                    mayscript>
                    <param name="BASEURL" value="http://<? echo $_SERVER['SERVER_ADDR'] ?>/"/>
                    <param name="onAudioRecorderReady" value="onAudioRecorderReady"/>
                    <param name="onAudioRecorderError" value="onAudioRecorderError"/>
                    <param name="onAudioRecorderTimeout" value="onAudioRecorderTimeout"/>
                     <hr/>
                    Your browser does not support Java.
                    Please download <a href="http://java.com:80/en/download/manual.jsp">last version of JRE</a> for your platform
                    <hr/>

                </applet>

      </div> 
      <div id="bufferBlock" style="display:none">
      <label>Use buffer:</label> <label id="buffer">0%</label>&nbsp;
        <form id="opt_form" style="display:inline">
       
      </div>
      <div style="border-width:1px;border-style:solid;" id="options"> 
        <table border="0" width="100%">
		<tr><td>
        <input checked type="radio" name="video" value="live" onclick="document.getElementById('archive_opts').style.display='none';">Live</input>
		</td>
		<td align="right">
		 <div id="liveTimeBlock" style="display:none">
      	 <label id="liveTime"></label>
		 </div>
		</td>
		</tr>
		<tr><td>
        <input type="radio" name="video" value="archive" onclick="document.getElementById('archive_opts').style.display='inline';">Archive</input>
		<div id="archive_opts" style="display:none">
            <select id="date">
            <?php
                $dir = '/opt/sarch/store/'.$_GET['dev'];
                if($d = @opendir($dir))
                {
                    chdir($dir);
                    while (false !== ($f = readdir($d)))
                    {
                        if ($f != "." && $f != ".." && is_dir($f))
                        {
                            $date = date('F d, Y', strtotime($f));
                            echo "<option value=\"$date\">$date</option>\n";
                        }
                    }
                    closedir($d);
                }
                else
                {
                }
            ?>
            </select>
<input type="text" value="17:00:00" id="startTime" maxlength="8" size="8">-<input type="text" value="18:00:00" id="endTime" maxlength="8" size="8"/> 
&nbsp;&nbsp;&nbsp;&nbsp;
<input type="text" value="17:20:00" id="jumpStartTime" maxlength="8" size="8">
<input type="button" value="jump" onclick="jumpToTimestamp()">
<input type="button" value="jump in future" onclick="jumpToTimestampInFuture()">
<input type="button" value="jump in middle" onclick="jumpToTimestampInMiddle()">
        </div>
		</td>
		<td align="right">
		 <div id="archiveTimeBlock" style="display:none">
      	 <label id="archiveTime"></label>
		 </div>
		</td>
		<tr>
		
		</table>

     </form>
      </div>

      
            <input type="button" id="play_f" value="   >   "
                        onclick="//if(!stepMode) this.disabled=true;
                             document.getElementById('demo').setParameter('direction', 1);
                             stepmode = false;
                             play(); 
                             //document.getElementById('play_b').disabled=false;
                             document.getElementById('step').disabled=false;
                             ">

            <input type="button" id="play_b" value="   <   " 
                        onclick="if(!stepMode) this.disabled=true;
                             document.getElementById('demo').setParameter('direction', -1);
                             stepmode = false;
                             play();
                             document.getElementById('play_f').disabled=false;
                             ">
                    
            <input type="button" id="pause" value="Pause" disabled="disabled"
                onclick="pause();     
                this.disabled=true;
                document.getElementById('play_f').disabled=false;
                document.getElementById('play_b').disabled=false;
               "/>

            
            <input type="button" id="stop" value="Stop" disabled="disabled"
                   onclick="stop();     
                            this.disabled=true;
                            document.getElementById('play_f').disabled=false;
                            document.getElementById('play_b').disabled=true;
                            document.getElementById('pause').disabled=true;
                            document.getElementById('step').checked=false;
                            document.getElementById('step').onclick();
                            document.getElementById('step').disabled=true;">
            
            <input type="button" id="snapshot" value="Snapshot"
                onclick="snapshot();"/>
            <input type="button" id="clear" value="Clear"
            onclick="document.getElementById('demo').sendCommand('clear');"/>

			
			
            Size: <select onchange="setAppletSize(this.value)">
                    <option value="320x240">320x240</option>
                    <option value="640x480" selected="selected">640x480</option>
                    <option value="704x480" selected="selected">704x480</option>
                    <option value="800x600">800x600</option>
                    <option value="1024x768">1024x768</option>
                    <option value="1280x1024">1280x1024</option>
                  </select>
            
            Stream: <select id="streamType" onchange="setStream(this.value)">
                    <option value="streamOverUDPMulticast">over UDP Multicast</option>
                    <option value="streamOverUDP">over UDP</option>
                    <option value="streamOverTCP" selected="selected">over TCP</option>
                    <option value="streamOverHTTP">over HTTP</option>
                  </select>
			Speed: <select id="streamSpeed" disabled="disabled" onchange="document.getElementById('demo').setParameter('streamSpeed', this.value);">
                    
                    <option value="0.3">0.3</option>
                    <option value="0.6">0.6</option>
                    <option value="1.0" selected>1.0</option>
                    <option value="1.3">1.3</option>
					<option value="1.6">1.6</option>
                    <option value="2.0">2.0</option>
                    <option value="2.3">2.3</option>
                    <option value="2.6">2.6</option>
                    <option value="3.0">3.0</option>
                    <option value="3.3">3.3</option>
                    <option value="3.6">3.6</option>
                    <option value="4.0">4.0</option>											
                  </select>

Step: <input id="step" disabled="disabled" type="checkbox" onclick="if (this.checked)    
{
document.getElementById('demo').setParameter('stepMode', '1');
stepMode = true;
document.getElementById('play_f').disabled=false;
document.getElementById('play_b').disabled=false;
}
else 
{
document.getElementById('demo').setParameter('stepMode', '0');
stepMode = false;
}">   

Analytics: <input id="analytics" type="checkbox">      
       
    </td>
</tr>
<tr>
<td>
  <!-- <input type="button" id="get_mixers" value="Get mixers" onclick="getMixers();"/> -->
   <select id="mixerList" disabled="disabled" onchange="if (this.value != '') setMixer(this.value);"><option value="">-- select audio mixer --</option></select>
   <input type="button" disabled="disabled" id="startRecording" value="Start Recording" onclick="startRecording();"/>
   <input type="button" disabled="disabled" id="stopRecording" value="Stop Recording" onclick="stopRecording();"/>

</td>
</tr>

</table>
</br>
<label>Status:</label> <label id="status">IDLE</label>&nbsp;
</body>
</html>
