#!/usr/bin/perl -w
#  $Id: switch4mserver.pl 12809 2008-11-20 22:17:32Z teetov $
# -----------------------------------------------------------------------------
#  Calculate port and s_master for mediaServer command line
#  
#  usage:
#	$APL/mgears/bin/mediaServer -D `$APL/mgears/bin/switch4mserver.pl` 
#	
#  the XML description of domain expected in format like this:
#
#<?xml version="1.0"?>
#<RESULT>
#        <STATUS VALUE="OK"/>
#    <DOMAIN>
#        <NODE HOST="n1" LAN_IP="192.168.10.204" LAN_HTTP_PORT="80" WAN_IP="192.168.10.204" WAN_HTTP_PORT="80" WAN_RTSP_PORT="8554"
#        MSG_SERVER_PORT="5000" MSG_SERVER_PORT_RANGE="80"/>
#        <NODE HOST="n2" LAN_IP="192.168.10.205" LAN_HTTP_PORT="80" WAN_IP="192.168.10.205" WAN_HTTP_PORT="80" WAN_RTSP_PORT="8554"
#        MSG_SERVER_PORT="5000" MSG_SERVER_PORT_RANGE="80"/>
#    </DOMAIN>
#</RESULT>
#
# -----------------------------------------------------------------------------
#  Author: teetov
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
use strict;
use XML::Simple;
use Data::Dumper;
use NextCAM::Conf;
use Node::Conf qw(RTSP_PORT);
use Socket;
use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.patrol";
my $log = get_logger('NEXTCAM::CAM::CAM_PATROL');

# ------------------ get s_master IP
$log->info('getting s_master ip');
my $iaddr=gethostbyname('s_master');
$log->logdie('s_master has to be defined in /etc/hosts') if not $iaddr;
my $m_ip=inet_ntoa($iaddr);
$log->info("found s_master ip=$m_ip");
# ------------------ find a port 
my $port=RTSP_PORT;
$log->logdie("Cannot find my RTSP_PORT") if ! $port;
# ---------------- finally print results
print "-p $port -m $m_ip\n";
#print "-p $port\n";
