#!/usr/bin/perl
#  $Id:  $
# -----------------------------------------------------------------------------
#  MBus Patrol 
# -----------------------------------------------------------------------------
#  Author: Alex Tsibulnik
#  Edited by:
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT Network Solutions, Inc.
# -----------------------------------------------------------------------------

use strict;
use IO::Socket;
use NextCAM::Messenger;
use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.patrol";

my $log = get_logger('NEXTCAM::MGEARS::MBUS_PATROL');

my $MBUS                = "$ENV{APL}/mbus/bin/messageServer4master";
my $MBUS_CHECK_INTERVAL = 15;    # seconds
my $MBUS_CONN_TIMEOUT   = 3000; # milliseconds
my $MBUS_PORT = 10000;

$log->info('Starting up MBus monitor. Server status: '.check_conn());

# Main
for(;;) {
    check_mbus(); 
    sleep $MBUS_CHECK_INTERVAL;
}

# Routines
sub check_mbus {
    my ($pid) = `ps -au apl -o pid,command|grep '$MBUS'|grep -v grep`=~/^\s*(\d+)\s+/;
    if ($pid) {
	my $chk = check_conn();
	unless ($chk eq 'OK') {
	    # Recheck
	    $log->warn("Message server connection failed: $chk");
	    sleep 5;
	    $chk = check_conn();
	}
	unless ($chk eq 'OK') {
	    $log->warn("Killing Message Server due to locked up socket: $chk");
	    kill 15 => $pid;
	    sleep 2;
	    if (kill 0 => $pid) {
		$log->warn("Message Server still running after SIGTERM. Will now send SIGKILL");
		kill 9 => $pid;
	    }
    	    
	    sleep 15;
	}
    }
}

sub check_conn {
    my $messenger;
    eval {
        $messenger = NextCAM::Messenger->new(
    	    host => 's_master',
	    port => $MBUS_PORT,
	    conn_timeout => $MBUS_CONN_TIMEOUT,
	    autoconnect => 0
	);
	die "Failed to create Messenger instance\n" unless $messenger;
	my $sid = $messenger->connect;
	unless ($sid) {
	    die "Connection failed\n" unless $messenger->{sock};
	    die "Failed to read response\n" unless defined $sid;
	    die "ACKW result != 0\n" if $sid == 0;
	}
	
    };
    my $err = $@;
    $messenger->disconnect if $messenger;
    return $err?"ERROR: $err":"OK";
}

