#!/usr/bin/perl

use strict;
use warnings;
use Errno 'EWOULDBLOCK';
use IO::Socket::INET;
use Socket qw(IPPROTO_TCP);
#use SKM::DB;
use NextCAM::CRC qw(crc);
use Data::Dumper;

# CONS
my $APL = $ENV{APL};
my $APL_VAR = $ENV{APL_VAR};
my $LTSD_CONF = "$APL_VAR/lts/ltsd.conf";
my $CMD_MAP = "$APL_VAR/lts/cmd.map"; # Mapping: cmd => eventtype,event msg
my $TASS_MODELID = "TASS";
my $SOCK_TMT = 5;
my $EVENT_SOURCE = 3; # source=sensor
my $DEV_SCAN_TMT = 30; # Rescan device list twice a minute
my $EVENT_TYPE_ALERT = 1;
my $EVENT_TYPE_INFO = 0;

my $MSG_PREFIX = "\x{01}\x{02}\x{0E}";
my $TASS_PREFIX = "\x{07}\x{03}\x{00}\x{09}"; # <soh> <stx> <so> <bel> <etx> <\0> <ht>
my $MSG_SUFFIX = "\x{11}\x{03}\x{04}";
my $MSG_END = "\x{0D}\x{0A}";
my $MSG_ROOT_LEN = 15;

# VARS
my $Debug = 0;
my $ConfPath;
my %Opts;
my %Conf;
my %Devs;
my $dbm;
my $Sock;
my $Last_Scan_TS = 0;
my $SigHup = 0;        # SIGHUP flag
my $Buffer = '';
my @EventQueue;   # Events to send to ELog


sub gw_connect
{
        $Sock = IO::Socket::INET->new(
                PeerHost  => 'localhost',
                PeerPort  => $Conf{LOCALPORT},
                Proto     => 'tcp',
		Timeout	  => $SOCK_TMT,
		KeepAlive => 1,
		Blocking  => 1,
        );
        die( "Connection to gateway failed: $!\n") unless $Sock;

	$Sock->autoflush(1);
	setsockopt($Sock, IPPROTO_TCP, SOL_SOCKET, SO_KEEPALIVE) || warn "setsockopt: $!\n";
}

sub configure
{
        $Debug = $Opts{d};
        $ConfPath = $LTSD_CONF if not $ConfPath and -f $LTSD_CONF;

        die( "Must specify path to config file!\n") unless $ConfPath;
        die ("Invalid config file path!\n") unless -f $ConfPath;

        # Read and parse ltsd.conf
        open FH, $ConfPath or die ("Cannot read config file: $!\n");
        %Conf = map {/(\w+)=(.*)/} grep {/^\w+=/} <FH>;
        close FH;

        die("IP must be specified in ltsd.conf") unless $Conf{IP};
	die("PORT must be specified in ltsd.conf") unless $Conf{PORT};
}

sub process_msg
{
        my $msg_out = "";
	my ($cmd, $sensor, $port) = @_;
	my $comb = ($cmd<<11) + $sensor;
	$msg_out = $TASS_PREFIX . pack("nC2", $comb, int(rand(16)<<4)+3, $port);

	my $ctx = NextCAM::CRC->new(type=>"crc8", poly=>0x107);
	$ctx->add($msg_out);
	my $crc = hex($ctx->hexdigest);
	$msg_out = $MSG_PREFIX . $msg_out .
		   pack("C", $crc) . 
		   $MSG_SUFFIX .
		   $MSG_END;
        return $msg_out;
}

die ("Usage: cmd_sender CMD SENSOR\n") if @ARGV <3;

my $cmd = shift @ARGV;
my $sensor = shift @ARGV;
my $port = shift @ARGV;

configure;
gw_connect;

my $message = process_msg($cmd, $sensor, $port);

print $Sock $message;
