#!/usr/bin/perl
#  $Id$
# -----------------------------------------------------------------------------
#  Perform periodic EventLog tables scan and send emails with snapshots
# -----------------------------------------------------------------------------
#  Author: Andrey Fomenko
#  Modified by: 
#  QA by:  
#  Copyright: videoNEXT Network solutions, Inc.
# -----------------------------------------------------------------------------

use MIME::Base64 ();
use NextCAM::Init;
use Data::Dumper;
use Master::Conf;
use Node::Conf;

use strict;
use warnings;
use SKM::DB;
use Data::Dumper;
use XML::Simple;
use Net::SMTP;
use CGI qw (unescape);
use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.engine";
print "1";

my $log=get_logger('NEXTCAM::ELOG::EVENT_EMAILER');
my $NodeList = NodeList;
my $MasterIP = $NodeList->{UNI()}{IP};
# ----- constants -------------------------------------------------------------
my $APL       	= $ENV{APL};

my $snapshotViewerURL = "http://$MasterIP/sdi/evu/eventlist.php?snapshotid=";   # TBD: hostname

my $retainSnaphots = '2 days';				# SQL syntax for "inteval" should be observed!

my $dbm;                   				# DB handler
my %dbs;						# prepared SQL statements
my $errors = 0;						# number of errors encountered (for return value)

my $smtp_server;
my $user_addr;
my $user_name;
my $user_pwd;

my $xs1 = XML::Simple->new();
my $doc;

# ----- SUBS ------------------------------------------------------------------
# ----------------------------------------------------------------- my_log (mylog) -----
sub my_log
{
	my $msg = shift;
	#`echo $msg >> /tmp/log.log`;
	open(F, ">> /tmp/log.log");
	print(F "$msg\n");
	close(F);
}



sub db_master # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
{
$log->info('-= start db_master =-');

	eval {
		$dbm=DBMaster({PrintError=>1,'RaiseError' => 1});
	};
	if($@) {
		$log->fatal("Can not connect to S_MASTER database!");
		exit -11;
	}
	eval {
		$dbm->{FetchHashKeyName} = 'NAME_lc';
		$dbm->{ShowErrorStatement}=1;
		$log->debug('Connection to DB established.');

		$dbs{TAG_SNC1} 	= $dbm->prepare("DELETE FROM event_emailer_tag ".
						"WHERE userid NOT IN ".
							"(SELECT ou.obj FROM ".
								"(select o.obj, o.otype, o.subtype, o.name, o.description, o.deleted, o.protected, oa1.val as email, oa2.val as email_int ".
								"from _objs o  ".
								"left join _obj_attr oa1 on o.obj=oa1.obj and oa1.attr = 'EMAIL' ".
								"left join _obj_attr oa2 on o.obj=oa2.obj and oa2.attr = 'EMAIL_INTERVAL' ".
								"where o.otype = 'U') ou ".							
							"WHERE ou.otype='U' AND trim(ou.email_int) <> '' AND cast(ou.email_int as int)>=0 AND ou.email LIKE '%@%' AND ou.email LIKE '%.%')") or die "TAG_SNC1";
		$dbs{TAG_SNC2} 	= $dbm->prepare("INSERT INTO event_emailer_tag (userid,last_eventid,last_send) ".
						"SELECT ou.obj,0,0 FROM ".
								"(select o.obj, o.otype, o.subtype, o.name, o.description, o.deleted, o.protected, oa1.val as email, oa2.val as email_int ".
								"from _objs o  ".
								"left join _obj_attr oa1 on o.obj=oa1.obj and oa1.attr = 'EMAIL' ".
								"left join _obj_attr oa2 on o.obj=oa2.obj and oa2.attr = 'EMAIL_INTERVAL' ".
								"where o.otype = 'U') ou ".
							"WHERE trim(ou.email_int) <> '' AND cast(ou.email_int as int)>=0 ".
								"AND ou.email LIKE '%@%' AND ou.email LIKE '%.%' " .
								"AND ou.obj NOT IN (SELECT userid FROM event_emailer_tag)") or die "TAG_SNC2";

		$dbs{GET_RECIP}	= $dbm->prepare("SELECT userid,ou.name,ou.description,ou.email,ou.email_int,last_eventid,last_send ".
						"FROM event_emailer_tag, ".
								"(select o.obj, o.otype, o.subtype, o.name, o.description, o.deleted, o.protected, oa1.val as email, oa2.val as email_int ".
								"from _objs o  ".
								"left join _obj_attr oa1 on o.obj=oa1.obj and oa1.attr = 'EMAIL' ".
								"left join _obj_attr oa2 on o.obj=oa2.obj and oa2.attr = 'EMAIL_INTERVAL' ".
								"where o.otype = 'U') ou ".
						"WHERE userid=ou.obj AND last_send+60*cast(ou.email_int as int)<?") or die "GET_RECIP";
						
						
		$dbs{GET_SNPID} = $dbm->prepare("SELECT nextval_seq_event_emailer_snapshot() as nextval") or die "GET_SNPID";
		$dbs{INS_SNAP} 	= $dbm->prepare(
						"INSERT INTO event_emailer_snapshot ".
						"SELECT ?,?,e1.eventid ".
						  "FROM event e1 ".
						"INNER JOIN eventwitness w1 ON w1.eventid = e1.eventid ".
						 "WHERE e1.eventid > ? ".
						   "AND w1.objid IN ( ". "select obj from getObjects(?, null, null, null) o where o.credentials like '%I%'".
								")") or die "INS_SNAP";
		$dbs{CNT_SNAP} 	= $dbm->prepare("SELECT count(*),max(eventid) FROM (SELECT DISTINCT eventid FROM event_emailer_snapshot WHERE snapshotid=?) ees") or die "CNT_SNAP";
		$dbs{ADV_TAG} 	= $dbm->prepare("UPDATE event_emailer_tag SET last_eventid=?, last_send=? WHERE userid=?") or die "ADV_TAG";

		$dbs{GET_ROLES} = $dbm->prepare("SELECT * from  getRoles(?)") or die "GET_ROLES";

		$dbs{CNT_SNAP_CRED} 	= $dbm->prepare(
					"SELECT count (t.eventid) FROM " . 
					"(SELECT distinct d.eventid FROM (select distinct w.eventid, w.objid as obj from event_emailer_snapshot ees, eventwitness w where w.eventid = ees.eventid and ees.snapshotid=?) d, " .
#					"getObjects(?, null, null, null) o " .
					"getObjects(?, ?, null, null) o " .
					"WHERE   " .
					"d.obj = o.obj AND " .
					"o.credentials like '%v%' AND " .
					"o.credentials like '%I%' " .					
					") t; "		
					) or die "CNT_SNAP_CRED";
		$log->debug('SQL statements are prepared');
	};
	if($@) {
		$log->fatal("Can not prepare database statement: $@");
		exit -12;
	}
$log->info('-= END db_master =-');
	
} # sub db_master

sub sendEmail2User { # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	my ($name,$descr,$email,$snapshot,$count, $roleid, $rolename) = @_;
$log->info('-= start sendEmail2User =-');
	eval {
	
		$log->debug("Sending message To:$email");
#		my_log("-= Sending message To:$email =-");
		
		my $smtp = Net::SMTP->new(Host => $smtp_server,
					Port => 25,
					Debug => 1) or $log->error("Cannot connect to $smtp_server");

		$smtp->auth($user_name, $user_pwd) or $log->error("Cannot authenticate to $smtp_server. Wrong user name or password");
		$smtp->mail($user_addr);
		$smtp->to($email);

		$smtp->data();
		$smtp->datasend("From: $user_name\n");
		$smtp->datasend("To: $email\n");
		my $subj = "";
		if ($roleid){
			$subj = "Subject: Automated event[s] notification: ${snapshot}. Role: ${rolename}\n";
		}else{
			$subj = "Subject: Automated event[s] notification: ${snapshot}.\n";
		}	
		$smtp->datasend($subj);
		$smtp->datasend("\n");
		$smtp->datasend("\n");

		my $snapshotLink = $snapshotViewerURL . $snapshot;
		if ($roleid){
			$snapshotLink = $snapshotLink . "&roleid=" . $roleid;
		}
		$smtp->datasend("Message: \n");

		$smtp->datasend(
		($descr? "$descr,\n\n" : "") .
		"You have $count events waiting for your review here: $snapshotLink\n\n" . 
		"System will retain snapshot for $retainSnaphots before recycling it.\n"
		);

		$smtp->datasend("\n");
		$smtp->datasend("\n");
		$smtp->dataend();
		$smtp->quit;  
	};

	if($@) {
		$log->error("Error at sendEmail2User: $@");
		$errors++;
	}	
	
$log->info('-= END sendEmail2User =-');
} # sub sendEmail2User


sub send_emails { # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	$log->debug('send_emails(): started');
$log->info('-= start send_emails =-');
	eval {
		# first of all: synchronize EVENT_EMAILER_TAGS with current state of configured users
		$dbs{TAG_SNC1}->execute() or die "Error while deleting tags for users who no longer have email properly configured";
		$dbs{TAG_SNC2}->execute() or die "Error while adding tags for users who has just received email properly configured";
		# next, determine set[s] of users to receive notifications at this time
		my $exec_time = time;
		$log->debug("Reading list of recipients for UNIX time $exec_time");
		$dbs{GET_RECIP}->execute($exec_time) or die "Error getting list of email recipients";
		while( my $recp_row = $dbs{GET_RECIP}->fetchrow_hashref ) {
			#$log->debug(Dumper($recp_row));
			$log->debug("Processing recipient: [$recp_row->{userid}] $recp_row->{name}");
			# determine SNAPSHOT ID
			$dbs{GET_SNPID}->execute or die "Can not get next SNAPSHOT ID";
			my $sid_arr = $dbs{GET_SNPID}->fetchrow_arrayref;
			my $snapshotID = $sid_arr->[0];
			# assemble snapshot in one shot :)
			$dbs{INS_SNAP}->execute($snapshotID,$recp_row->{userid},$recp_row->{last_eventid},$recp_row->{userid});
			# count events in snapshot - it may be empty and it is no reason to send email
			
			$dbs{CNT_SNAP}->execute($snapshotID) or die "Can not count events in snapshot";
			my $cnt_snap_arr = $dbs{CNT_SNAP}->fetchrow_arrayref;
			my $cnt_snap = $cnt_snap_arr->[0];
			my $max_eventid = $cnt_snap_arr->[1];

# added role			
			$dbs{GET_ROLES}->execute($recp_row->{userid}) or die "Can not get roles for user";
			while( my $role_row = $dbs{GET_ROLES}->fetchrow_hashref ) {
				$dbs{CNT_SNAP_CRED}->execute($snapshotID, $recp_row->{userid}, $role_row->{obj}) or die "Can not count events in snapshot";
				my $cnt_snap_cred_arr = $dbs{CNT_SNAP_CRED}->fetchrow_arrayref;
				my $cnt_snap_cred = $cnt_snap_cred_arr->[0];

			#$log->debug("Snapshot ID=$snapshotID COUNT=$cnt_snap LAST_EVENTID=$max_eventid");
			# determine if email has to be sent and send it
				if($cnt_snap and $cnt_snap_cred){
					sendEmail2User($recp_row->{name}, $recp_row->{description}, $recp_row->{email}, $snapshotID, $cnt_snap,$role_row->{obj}, $role_row->{name});
					# advance tag for this user
					$log->debug("Tagging userID=$recp_row->{userid} to last_event=$max_eventid last_time=$exec_time");
					$dbs{ADV_TAG}->execute($max_eventid,$exec_time,$recp_row->{userid}) or die "Can not update tag for user $recp_row->{userid}";
				}
			}
		} # while .. $row .. fetchrow_hashref
	};
	if($@) {
		$log->error("Error at send_emails: $@");
		$errors++;
	}
	$log->debug('send_emails(): finished');
$log->info('-= END send_emails =-');
} # sub send_emails


sub ReadEmailerConfig # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
{
$log->info('-= start ReadEmailerConfig =-');
	my $url = "http://s_master/api/cgi-bin/dynadata.cgi?return=datablock&typeid=Emailer";
	my $input = `curl --connect-timeout 2 "$url" 2>/dev/null`;
	
	my $xs1 = XML::Simple->new();
	my $doc = $xs1->XMLin($input, ForceArray=>["POLICY"],KeyAttr=>[]);
	$smtp_server = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{SERVER});
	$user_addr = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{EMAIL});
	$user_name = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{USER});
	$user_pwd = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{PASSWORD});
	$log->info ("Config read as SMTP_Server:$smtp_server Login:$user_name"); 
$log->info('-= END ReadEmailerConfig =-');
}


sub recycleSnapshots { # - - - - - - - - - - - - - - - - - - - - - - - - - - - -
$log->info('-= start recycleSnapshots =-');
	$log->info('Recycling snapshots after '.$retainSnaphots);
	$dbm->do("DELETE FROM event_emailer_snapshot WHERE ts_created < now() at time zone 'UTC' - INTERVAL '$retainSnaphots'");
$log->info('-= END recycleSnapshots =-');
} # sub recycleSnapshots

sub ReadEmailerCfg
{
$log->info('-= start ReadEmailerCfg =-');
    my $query = "SELECT * from dyna_data where typeid='Emailer'";
    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    my $dbreturns=$dbh->selectall_hashref($query, 'ind');
	my $input = "";

    if (!$dbreturns)
    {
      $input .= "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"DB access error\"/>\n</DYNADATA>\n";
      $log->logdie($DBI::errstr);
    }
    $dbh->disconnect();

    my $ee = scalar(%$dbreturns);
    if ($ee ne 0)    
    {
      $input .= "<DYNADATA>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Query successful\"/>\n";

      foreach my $dbrow ( keys %$dbreturns ) 
      {
		$input .= "\t<DATABLOCK BLOCKID=\"$dbreturns->{$dbrow}{ind}\" ";
		if (defined($dbreturns->{$dbrow}{typeid})){
			$input .= " TYPEID=\"$dbreturns->{$dbrow}{typeid}\" ";
		}else { $input .= " TYPEID=\"\" ";}
		if (defined($dbreturns->{$dbrow}{contentid})){
			$input .= " CONTENTID=\"$dbreturns->{$dbrow}{contentid}\" ";
		}else { $input .= " CONTENTID=\"\" ";}
		if (defined($dbreturns->{$dbrow}{description})){
			$input .= " DESCRIPTION=\"$dbreturns->{$dbrow}{description}\" ";
		}else { $input .= " DESCRIPTION=\"\" ";}
		$input .= ">\n";
#         $input .= "\t<DATABLOCK BLOCKID=\"$dbreturns->{$dbrow}{ind}\" TYPEID=\"$dbreturns->{$dbrow}{typeid}\" CONTENTID=\"$dbreturns->{$dbrow}{contentid}\" DESCRIPTION=\"$dbreturns->{$dbrow}{description}\">\n";
        $input .= "\t\t<LAYOUT>$dbreturns->{$dbrow}{data}</LAYOUT>\n\t</DATABLOCK>\n";

      }
      $input .= "</DYNADATA>\n";     
    }
    else
    {
          $input = "<DYNADATA>\n<STATUS VALUE=\"OK\" MESSAGE=\"No one Dynamic Data block exist\"/>\n</DYNADATA>\n";
    }
my_log("input = " . $input);	
	$doc = $xs1->XMLin($input, ForceArray=>["POLICY"],KeyAttr=>[]);
	$smtp_server = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{SERVER});
    $user_addr = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{EMAIL});
    $user_name = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{USER});
    $user_pwd = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{PASSWORD});
$log->info('-= END ReadEmailerCfg =-');
my_log("-= END ReadEmailerCfg =-");

}

# ================================================================================
# ================================================================================
# ===== MAIN =====================================================================

$log->info('-= start "event_emailer" =-');

db_master();
#ReadEmailerConfig();
ReadEmailerCfg();

my $recycleSnaphots = 0;
while(1) {
$log->info('-= while after sleep =-');

	send_emails();
$log->info('-= after send_emails =-');
	last if $errors;
	if($recycleSnaphots++ > 60) {
		# recycle snapshots every hour
		$recycleSnaphots = 0;
		recycleSnapshots();
$log->info('-= after recycleSnapshots =-');
	}
	sleep 59;
}

$log->info('-= terminate "event_emailer" =-');
exit $errors;

