SET search_path TO transdb;

CREATE TABLE content_delivery_type (
    deliverytypeid      integer not null,
    name                varchar,
    PRIMARY KEY (deliverytypeid)
);

CREATE TABLE content_delivery_history (
    deliverytypeid      integer not null,
    objid               integer not null,
    tstamp              timestamp without time zone default (now() at time zone 'UTC') not null,
    seconds             integer not null,
    isqueued            boolean,
    megabytes           double precision,
    CONSTRAINT fk_deliverytypeid FOREIGN KEY (deliverytypeid) REFERENCES content_delivery_type
);

-- Views
SET search_path TO apl;

-- content_delivery_type is read-only
CREATE OR REPLACE VIEW content_delivery_type as select * from transdb.content_delivery_type;
CREATE OR REPLACE RULE v_content_delivery_type_ins AS ON INSERT TO content_delivery_type
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_content_delivery_type_upd AS ON UPDATE TO content_delivery_type
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_content_delivery_type_del AS ON DELETE TO content_delivery_type
    DO INSTEAD NOTHING;

-- content_delivery_history
CREATE OR REPLACE VIEW content_delivery_history as select * from transdb.content_delivery_history;

CREATE OR REPLACE RULE v_cloud_chunks_ins AS ON INSERT TO content_delivery_history
    DO INSTEAD
        INSERT INTO transdb.content_delivery_history VALUES (NEW.*);

CREATE OR REPLACE RULE v_content_delivery_history_upd AS ON UPDATE TO content_delivery_history
    DO INSTEAD 
        UPDATE transdb.content_delivery_history
        SET
            seconds=NEW.seconds,
            isqueued=NEW.isqueued,
            megabytes=NEW.megabytes
        WHERE 
            deliverytypeid=OLD.deliverytypeid AND
            objid=OLD.objid AND
            tstamp=OLD.tstamp;

CREATE OR REPLACE RULE v_content_delivery_history_del AS ON DELETE TO content_delivery_history
    DO INSTEAD
        DELETE FROM transdb.content_delivery_history 
        WHERE deliverytypeid=OLD.deliverytypeid AND objid=OLD.objid AND tstamp=OLD.tstamp;

-- permissions
GRANT select ON content_delivery_type to apl;
GRANT select,insert,update,delete ON content_delivery_history to apl;
