-- Break dependancy from transdb to confdb

set search_path to transdb;

CREATE OR REPLACE function upd_timestamp() RETURNS TRIGGER AS $$
BEGIN
    if OLD.updated_at = NEW.updated_at then
        NEW.updated_at := now() at time zone 'UTC';
    end if;
    return NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER trg_event_upd_time ON event;
CREATE TRIGGER trg_event_upd_time BEFORE UPDATE ON event FOR EACH ROW EXECUTE PROCEDURE transdb.upd_timestamp();
