SET search_path TO transdb;

CREATE TABLE av_geo_history (
    AVATARID        integer not null,    -- reference to avatar record in _OBJ   
    GTIME           timestamp without time zone not null,
    GDATA           text   -- json struct [{"ts":1234566, "lat":43.909998, "lon":44.23556, "alt":0}, {"ts":1234566, "lat":43.909998, "lon":44.23556, "alt":0}, ...]
);
CREATE INDEX idx_av_geo_history_avatarid ON av_geo_history(avatarid);
CREATE INDEX idx_av_geo_history_gtime ON av_geo_history(gtime);



SET search_path TO apl;

CREATE OR REPLACE VIEW av_geo_history as select * from transdb.av_geo_history;
CREATE OR REPLACE RULE v_av_geo_history_ins AS ON INSERT TO av_geo_history
    DO INSTEAD
	INSERT INTO transdb.av_geo_history VALUES (NEW.*);
CREATE OR REPLACE RULE v_av_geo_history_upd AS ON UPDATE TO av_geo_history
    DO INSTEAD 
	UPDATE transdb.av_geo_history
	SET
	    GDATA=NEW.GDATA
	WHERE AVATARID=OLD.AVATARID
	    AND GTIME=OLD.GTIME;
CREATE OR REPLACE RULE v_av_geo_history_del AS ON DELETE TO av_geo_history
 	DO INSTEAD
	DELETE FROM transdb.av_geo_history
	WHERE AVATARID=OLD.AVATARID
	    AND GTIME=OLD.GTIME;
            
GRANT select,insert,update,delete ON av_geo_history to apl;

CREATE OR REPLACE FUNCTION av_add_geo_positions(integer, -- objid
                                                anyarray -- [ [ts, lat,lon, alt],  [ts, lat,lon, alt], ..  ]
                                               ) RETURNS void AS
$$
DECLARE 
   obj_id         ALIAS FOR $1;
   geo_list       ALIAS FOR $2;
   geo double precision[];
   merged_geo_list text;
   ts integer;
   geo_json text;
BEGIN

IF array_length(geo_list, 1) IS NULL THEN
   RETURN;
END IF;

FOREACH geo SLICE 1 IN ARRAY geo_list
LOOP
     geo_json := '{"ts":'||geo[1]::integer||',"lat":'||geo[2]||',"lon":'||geo[3]||',"alt":'||geo[4]||'}';
     ts := geo[1]::integer - (geo[1]::integer % 60); -- align by minutes
     merged_geo_list := (SELECT GDATA FROM av_geo_history WHERE AVATARID=obj_id AND ts = extract('epoch' from GTIME) + extract(timezone from current_time));
     IF merged_geo_list IS NULL THEN
        INSERT INTO av_geo_history(AVATARID, GTIME, GDATA) VALUES (obj_id, TIMESTAMP 'epoch' + ts * INTERVAL '1 second', '['||geo_json||']');
     ELSE
        merged_geo_list := trim(trailing ']' from merged_geo_list);
        merged_geo_list :=  merged_geo_list || ',' || geo_json || ']';
        UPDATE av_geo_history SET GDATA=merged_geo_list WHERE AVATARID=obj_id AND ts = extract('epoch' from GTIME) + extract(timezone from current_time);
     END IF;
END LOOP;

--RAISE EXCEPTION '%', $2;

END;
$$ LANGUAGE 'plpgsql';

--insert into av_geo_history values(101,         TIMESTAMP 'epoch' + 1438341600 * INTERVAL '1 second',
--'[ {"ts":1438341600, "lat":43.34343, "lon":75.667654, "alt":0}]');
--SELECT av_add_geo_positions(101, ARRAY[ ARRAY[1438341601, 44.32356, 45.090090, 0], ARRAY[1438341602, 44.54356, 45.190090, 0], ARRAY[1438341603, 44.64356, 45.290090, 0], ARRAY[1438341604, 44.74356, 45.390090, 0] ]);
       
