SET search_path TO transdb;

ALTER TABLE av_archive_requests ADD COLUMN is_private boolean DEFAULT '0';

SET search_path TO apl;

CREATE OR REPLACE VIEW av_archive_requests as select * from transdb.av_archive_requests;
CREATE OR REPLACE RULE v_av_archive_requests_ins AS ON INSERT TO av_archive_requests
    DO INSTEAD
	INSERT INTO transdb.av_archive_requests VALUES (NEW.*);
CREATE OR REPLACE RULE v_av_archive_requests_upd AS ON UPDATE TO av_archive_requests
    DO INSTEAD 
	UPDATE transdb.av_archive_requests
	SET
	    PRIORITY=NEW.PRIORITY,
	    STATUS=NEW.STATUS,
	    MESSAGE=NEW.MESSAGE,
	    SIZE=NEW.SIZE,
	    DOWNLOADED=NEW.DOWNLOADED,
	    COMPLETED_TIME=NEW.COMPLETED_TIME,
            IS_PRIVATE=NEW.IS_PRIVATE
	WHERE REQUESTID=OLD.REQUESTID
	    AND AVATARID=OLD.AVATARID
	    AND NODEID=OLD.NODEID
	    AND OBJID=OLD.OBJID
	    AND START_TIME=OLD.START_TIME
	    AND END_TIME=OLD.END_TIME
	    AND CREATED_TIME=OLD.CREATED_TIME
	    AND USERID=OLD.USERID;

