SET search_path TO transdb;

-- to allow for ptmization of select * from eventproperty where to_tsvector('english',value) @@ plainto_tsquery('english','cat ! rat');
CREATE INDEX idx_eventproperty_fts_value ON eventproperty USING GiST(to_tsvector('english', value));

CREATE TABLE eventbookmark (
    eventid     integer not null,
    utc_when    timestamp without time zone not null,
    bookmark    varchar,
    --
    CONSTRAINT pk_eventbookmark PRIMARY KEY(eventid, utc_when)
);

CREATE INDEX idx_eventbookmark_fts_bookmark ON eventbookmark USING GiST(to_tsvector('english', bookmark));

SET search_path TO apl;

CREATE OR REPLACE VIEW eventbookmark AS SELECT * FROM transdb.eventbookmark;

CREATE OR REPLACE RULE v_eventbookmark_ins AS ON INSERT TO eventbookmark
    DO INSTEAD
       INSERT INTO transdb.eventbookmark VALUES (NEW.*);

CREATE OR REPLACE RULE v_eventbookmark_upd AS ON UPDATE TO eventbookmark
    DO INSTEAD
       UPDATE transdb.eventbookmark
          SET eventid=NEW.eventid,
              utc_when=NEW.utc_when,
              bookmark=NEW.bookmark
        WHERE eventid=OLD.eventid AND utc_when=OLD.utc_when; 

CREATE OR REPLACE RULE v_eventbookmark_del AS ON DELETE TO eventbookmark
    DO INSTEAD
       DELETE FROM transdb.eventbookmark
        WHERE eventid=OLD.eventid AND utc_when=OLD.utc_when; 

GRANT insert,select,update,delete ON eventbookmark TO apl;


