SET search_path TO apl;

-- remove unused function and type
DROP FUNCTION getByType(typeid char(1));
DROP TYPE gismo_ctype;

-- restore of wrong removed view
CREATE OR REPLACE VIEW gismo_data as select * from transdb.gismo_data;
CREATE OR REPLACE RULE v_gismo_data_ins AS ON INSERT TO gismo_data
    DO INSTEAD
    INSERT INTO transdb.gismo_data VALUES (NEW.*);
CREATE OR REPLACE RULE v_gismo_data_upd AS ON UPDATE TO gismo_data
     DO INSTEAD
     UPDATE transdb.gismo_data
     SET
         deleted=NEW.deleted,
         stime=NEW.stime,
--
    time=NEW.time,
    userId=NEW.userId,
    userName=NEW.userName,
    objId=NEW.objId,
    sessionId=NEW.sessionId,
    cameraFovX=NEW.cameraFovX,
    cameraFovY=NEW.cameraFovY,
    cameraTiltAngel=NEW.cameraTiltAngel,
    cameraAzimuthAngle=NEW.cameraAzimuthAngle,
    cameraZoom=NEW.cameraZoom,
    cameraFocus=NEW.cameraFocus,
    cameraRangeFinderValue=NEW.cameraRangeFinderValue,
    cameraLatitude=NEW.cameraLatitude,
    cameraLongitude=NEW.cameraLongitude,
    cameraHeight=NEW.cameraHeight,
    cameraResolutionWidth=NEW.cameraResolutionWidth,
    cameraResolutionHeight=NEW.cameraResolutionHeight,
    imageX=NEW.imageX,
    imageY=NEW.imageY,
    targetId=NEW.targetId,
    targetSymbolId=NEW.targetSymbolId,
    targetSymbolDescr=NEW.targetSymbolDescr,
    targetLatitude=NEW.targetLatitude,
    targetLongitude=NEW.targetLongitude,
    targetAltitude=NEW.targetAltitude,
    targetDistance=NEW.targetDistance,
    targetType=NEW.targetType,
    targetSpeed=NEW.targetSpeed,
    targetCourse=NEW.targetCourse,
    targetSource=NEW.targetSource,
    targetElEventId=NEW.targetElEventId
--
     WHERE id=OLD.id AND deleted=OLD.deleted;
CREATE OR REPLACE RULE v_gismo_data_del AS ON DELETE TO gismo_data
     DO INSTEAD
    DELETE FROM transdb.gismo_data
    WHERE id=OLD.id AND deleted=OLD.deleted;

ALTER VIEW gismo_data ALTER COLUMN stime SET DEFAULT (now() at time zone 'UTC');
ALTER VIEW gismo_data ALTER COLUMN deleted SET DEFAULT 0;

ALTER VIEW gismo_data ALTER COLUMN time SET DEFAULT 0;
ALTER VIEW gismo_data ALTER COLUMN userId SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN userName SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN objId SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN sessionId SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraFovX SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraFovY SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraTiltAngel SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraAzimuthAngle SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraZoom SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraFocus SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraRangeFinderValue SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraLatitude SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraLongitude SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraHeight SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraResolutionWidth SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN cameraResolutionHeight SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN imageX SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN imageY SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetId SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetSymbolId SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetSymbolDescr SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetLatitude SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetLongitude SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetAltitude SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetDistance SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetType SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetSpeed SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetCourse SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetSource SET DEFAULT '';
ALTER VIEW gismo_data ALTER COLUMN targetElEventId SET DEFAULT 0;
ALTER VIEW gismo_data ALTER COLUMN id SET DEFAULT nextval_seq_gismo_data();

GRANT select,insert,update,delete ON gismo_data to apl;
