SET search_path TO apl;

----------------------------------------------------------
-- Specific hack required for el_insert_event() functions
-- They return currval('seqEventId') so return value must 
-- be corrected
----------------------------------------------------------
CREATE OR REPLACE FUNCTION el_insert_event(integer, integer, integer, integer, bigint, bigint, bigint, integer, integer, integer, character varying) RETURNS integer AS
$$
BEGIN

INSERT INTO event (objid, eventsource, workflow, state, utc_when, utc_from, utc_to, priority, lifespan, eventtype, message)
VALUES ($1, $2, $3, $4, 
        TIMESTAMP 'epoch' + $5 * INTERVAL '1 second',
        TIMESTAMP 'epoch' + $6 * INTERVAL '1 second',
        TIMESTAMP 'epoch' + $7 * INTERVAL '1 second',
        $8, $9, $10, $11);

RETURN (SELECT currval_seqeventid());
END;
$$ LANGUAGE 'plpgsql';


CREATE OR REPLACE FUNCTION el_insert_event(integer, integer, integer, integer, bigint, bigint, bigint, integer, integer, integer, character varying, character varying) RETURNS integer AS
$$
BEGIN

INSERT INTO event (objid, eventsource, workflow, state, utc_when, utc_from, utc_to, priority, lifespan, eventtype, message, externalid)
VALUES ($1, $2, $3, $4, 
        TIMESTAMP 'epoch' + $5 * INTERVAL '1 second',
        TIMESTAMP 'epoch' + $6 * INTERVAL '1 second',
        TIMESTAMP 'epoch' + $7 * INTERVAL '1 second',
        $8, $9, $10, $11, $12);

RETURN (SELECT currval_seqeventid());

END;
$$ LANGUAGE 'plpgsql';

-- Finally drop schema 'public'. It should be empty
DROP SCHEMA IF EXISTS public CASCADE;
