-- Create specific views as substitutes for sequences
-- Create routines for replacing calls to sequences

SET search_path TO apl;

-- seqEventId
CREATE OR REPLACE VIEW v_seqeventid (currval) AS SELECT 0::bigint;

CREATE OR REPLACE RULE "_RETURN" AS ON SELECT TO v_seqeventid DO INSTEAD
    SELECT currval('transdb.seqeventid');
CREATE OR REPLACE RULE v_seqeventid_nextval AS ON UPDATE TO v_seqeventid
DO INSTEAD
    SELECT nextval('transdb.seqeventid');



CREATE OR REPLACE FUNCTION nextval_seqeventid() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    UPDATE v_seqeventid SET currval=DEFAULT;
    val := (SELECT currval FROM v_seqeventid);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION currval_seqeventid() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    val := (SELECT currval FROM v_seqeventid);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

ALTER VIEW event ALTER COLUMN eventid SET DEFAULT nextval_seqeventid();


-- av_seq_requestid
CREATE OR REPLACE VIEW v_av_seq_requestid (currval) AS SELECT 0::bigint;

CREATE OR REPLACE RULE "_RETURN" AS ON SELECT TO v_av_seq_requestid DO INSTEAD
    SELECT currval('transdb.av_seq_requestid');
CREATE OR REPLACE RULE v_av_seq_requestid_nextval AS ON UPDATE TO v_av_seq_requestid
DO INSTEAD
    SELECT nextval('transdb.av_seq_requestid');

CREATE OR REPLACE FUNCTION nextval_av_seq_requestid() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    UPDATE v_av_seq_requestid SET currval=DEFAULT;
    val := (SELECT currval FROM v_av_seq_requestid);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION currval_av_seq_requestid() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    val := (SELECT currval FROM v_av_seq_requestid);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

ALTER VIEW av_archive_requests ALTER COLUMN REQUESTID SET DEFAULT nextval_av_seq_requestid();

-- Create proxy sequences for read-only public requests 
--
CREATE OR REPLACE VIEW v_seqeventid_ro AS SELECT * from transdb.seqeventid;
