SET search_path TO apl;

-- audit
CREATE OR REPLACE VIEW audit as select * from transdb.audit;
CREATE OR REPLACE RULE v_audit_ins AS ON INSERT TO audit
    DO INSTEAD 
    INSERT INTO transdb.audit VALUES (NEW.*);
-- UPDATE forbidden
CREATE OR REPLACE RULE v_audit_upd AS ON UPDATE TO audit
 	DO INSTEAD NOTHING;
-- DELETE forbidden	
CREATE OR REPLACE RULE v_audit_del AS ON DELETE TO audit
 	DO INSTEAD NOTHING;

ALTER VIEW audit ALTER COLUMN date SET DEFAULT timezone('UTC'::text, now());
ALTER VIEW audit ALTER COLUMN level SET DEFAULT 2;

-- auditcategory
-- Insert/update/delete on auditcategory is forbidden for apl
CREATE OR REPLACE VIEW auditcategory as select * from transdb.auditcategory;
CREATE OR REPLACE RULE v_auditcategory_ins AS ON INSERT TO auditcategory
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_auditcategory_upd AS ON UPDATE TO auditcategory
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_auditcategory_del AS ON DELETE TO auditcategory
 	DO INSTEAD NOTHING;

-- auditlevel
-- Insert/update/delete on auditlevel is forbidden for apl
CREATE OR REPLACE VIEW auditlevel as select * from transdb.auditlevel;
CREATE OR REPLACE RULE v_auditlevel_ins AS ON INSERT TO auditlevel
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_auditlevel_upd AS ON UPDATE TO auditlevel
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_auditlevel_del AS ON DELETE TO auditlevel
 	DO INSTEAD NOTHING;

--event
CREATE OR REPLACE VIEW event as select * from transdb.event;

CREATE OR REPLACE RULE v_event_ins AS ON INSERT TO event
    DO INSTEAD
	INSERT INTO transdb.event VALUES (NEW.*);

CREATE OR REPLACE RULE v_event_upd AS ON UPDATE TO event
 	DO INSTEAD
 	UPDATE transdb.event
 	SET
	    utc_when = NEW.utc_when, 
	    utc_from = NEW.utc_from,
	    utc_to = NEW.utc_to,    
	    priority = NEW.priority, 
	    state = NEW.state, 
	    message = NEW.message,
	    note = NEW.note, 
	    lifespan = NEW.lifespan
 	WHERE eventid=OLD.eventid;
 	
CREATE OR REPLACE RULE v_event_del AS ON DELETE TO event
 	DO INSTEAD
	DELETE FROM transdb.event WHERE eventid=OLD.eventid;

ALTER VIEW event ALTER COLUMN lifespan SET DEFAULT 1;
ALTER VIEW event ALTER COLUMN updated_at SET DEFAULT ('now'::text)::timestamp(6) without time zone;

-- Eventproperty
CREATE OR REPLACE VIEW eventproperty as select * from transdb.eventproperty;
CREATE OR REPLACE RULE v_eventproperty_ins AS ON INSERT TO eventproperty
    DO INSTEAD
	INSERT INTO transdb.eventproperty VALUES (NEW.*);
	
CREATE OR REPLACE RULE v_eventproperty_upd AS ON UPDATE TO eventproperty
    DO INSTEAD 
	UPDATE transdb.eventproperty
	SET
	    name=NEW.name,
	    value=NEW.value
	WHERE eventid=OLD.eventid AND name::text = new.name::text;
	
CREATE OR REPLACE RULE v_eventproperty_del AS ON DELETE TO eventproperty
 	DO INSTEAD
	DELETE FROM transdb.eventproperty
	    WHERE 
		eventid=OLD.eventid and
		name=OLD.name;
		
-- Eventwitness
CREATE OR REPLACE VIEW eventwitness as select * from transdb.eventwitness;
CREATE OR REPLACE RULE v_eventwitness_ins AS ON INSERT TO eventwitness
    DO INSTEAD
	INSERT INTO transdb.eventwitness VALUES (NEW.*);
CREATE OR REPLACE RULE v_eventwitness_upd AS ON UPDATE TO eventwitness
    DO INSTEAD 
	UPDATE transdb.eventwitness
	SET
	    objid=OLD.objid
	WHERE eventid=NEW.eventid;
CREATE OR REPLACE RULE v_eventwitness_del AS ON DELETE TO eventwitness
 	DO INSTEAD
	DELETE FROM transdb.eventwitness
	    WHERE 
		eventid=OLD.eventid and
		objid=OLD.objid;


-- av_archive_requests
CREATE OR REPLACE VIEW av_archive_requests as select * from transdb.av_archive_requests;
CREATE OR REPLACE RULE v_av_archive_requests_ins AS ON INSERT TO av_archive_requests
    DO INSTEAD
	INSERT INTO transdb.av_archive_requests VALUES (NEW.*);
CREATE OR REPLACE RULE v_av_archive_requests_upd AS ON UPDATE TO av_archive_requests
    DO INSTEAD 
	UPDATE transdb.av_archive_requests
	SET
	    PRIORITY=NEW.PRIORITY,
	    STATUS=NEW.STATUS,
	    MESSAGE=NEW.MESSAGE,
	    SIZE=NEW.SIZE,
	    DOWNLOADED=NEW.DOWNLOADED,
	    COMPLETED_TIME=NEW.COMPLETED_TIME
	WHERE REQUESTID=OLD.REQUESTID
	    AND AVATARID=OLD.AVATARID
	    AND NODEID=OLD.NODEID
	    AND OBJID=OLD.OBJID
	    AND START_TIME=OLD.START_TIME
	    AND END_TIME=OLD.END_TIME
	    AND CREATED_TIME=OLD.CREATED_TIME
	    AND USERID=OLD.USERID;
CREATE OR REPLACE RULE v_av_archive_requests_del AS ON DELETE TO av_archive_requests
 	DO INSTEAD
	DELETE FROM transdb.av_archive_requests
	WHERE REQUESTID=OLD.REQUESTID
	    AND AVATARID=OLD.AVATARID
	    AND NODEID=OLD.NODEID
	    AND OBJID=OLD.OBJID
	    AND USERID=OLD.USERID;

ALTER VIEW av_archive_requests ALTER COLUMN CREATED_TIME SET DEFAULT ('now'::text)::timestamp(6) without time zone;

-- version_transdb
CREATE OR REPLACE VIEW version_transdb as select * from transdb.version_transdb;
CREATE OR REPLACE RULE v_version_transdb_ins AS ON INSERT TO version_transdb
    DO INSTEAD
    INSERT INTO transdb.version_transdb VALUES (NEW.*);
CREATE OR REPLACE RULE v_version_transdb_upd AS ON UPDATE TO version_transdb
    DO INSTEAD
    UPDATE transdb.version_transdb
    SET version=NEW.version,
	iteration=NEW.iteration
    WHERE version=OLD.version AND iteration=OLD.iteration;
CREATE OR REPLACE RULE v_version_transdb_del AS ON DELETE TO version_transdb
 	DO INSTEAD
 	DELETE FROM transdb.version_transdb
 	    WHERE version=OLD.version AND iteration=OLD.iteration;
