SET search_path TO public;

-- Alter table structure
ALTER TABLE event ALTER eventid SET DEFAULT nextval('seqEventId');

-- Move tables to transdb
ALTER TABLE av_archive_requests SET SCHEMA transdb;
ALTER SEQUENCE av_seq_requestid SET SCHEMA transdb;
ALTER SEQUENCE seqEventId SET SCHEMA transdb;
ALTER TABLE event SET SCHEMA transdb;
ALTER TABLE eventwitness SET SCHEMA transdb;
ALTER TABLE eventproperty SET SCHEMA transdb;
ALTER TABLE version_transdb SET SCHEMA transdb;
ALTER TABLE auditlevel SET SCHEMA transdb;
ALTER TABLE auditcategory SET SCHEMA transdb;
ALTER TABLE audit SET SCHEMA transdb;

-- Move procedures to apl
ALTER TYPE EL_Event SET SCHEMA apl;
ALTER FUNCTION el_get_workflow(integer, integer, integer) SET SCHEMA apl;
ALTER FUNCTION el_get_workflow_context(integer) SET SCHEMA apl;
ALTER FUNCTION el_get_object_info(integer) SET SCHEMA apl;
ALTER FUNCTION el_get_event(integer) SET SCHEMA apl;
ALTER FUNCTION el_merge_witnesses(integer, integer, integer[]) SET SCHEMA apl;
ALTER FUNCTION el_insert_event(integer, integer, integer, integer, bigint, bigint, bigint, integer, integer, integer, character varying) SET SCHEMA apl;
ALTER FUNCTION el_insert_event(integer, integer, integer, integer, bigint, bigint, bigint, integer, integer, integer, character varying, character varying) SET SCHEMA apl;
ALTER FUNCTION el_update_event(bigint, bigint, integer, integer, integer, character varying, character varying, integer) SET SCHEMA apl;
ALTER FUNCTION el_get_event_for_merge(integer, integer, character varying) SET SCHEMA apl;
ALTER FUNCTION el_get_event_for_merge(integer, integer) SET SCHEMA apl;
ALTER FUNCTION el_insert_property(integer, character varying, character varying) SET SCHEMA apl;
-- Needed upd_timestamp in transdb scripts as member of 'public' schema. Finally, move it to confdb
ALTER FUNCTION upd_timestamp() SET SCHEMA confdb;

-- Move types to apl
ALTER TYPE EL_Workflow SET SCHEMA apl;
ALTER TYPE EL_Workflow_Context SET SCHEMA apl;
ALTER TYPE EL_Object_Info SET SCHEMA apl;
