

drop table if exists av_archive_requests;
drop sequence if exists av_seq_requestid;

create sequence av_seq_requestid;


CREATE TABLE av_archive_requests (
    REQUESTID       integer not null default nextval('av_seq_requestid')
                    constraint PK_AV_REQUESTID primary key,
    AVATARID        integer not null,    -- reference to avatar record in _OBJ   
    NODEID          integer not null,    -- reference to node record in _OBJ
    OBJID           integer not null,    -- camera objid 
    START_TIME      timestamp without time zone not null, -- UTC time when fragment begins
    END_TIME        timestamp without time zone not null, -- UTC time when fragment ends
    CREATED_TIME    timestamp without time zone not null default ('now'::text)::timestamp(6) without time zone,
                    -- UTC time when request is created
    USERID          integer,             -- requestor, USERID is referece to user record in OBJID

    -- Variable part of request
    PRIORITY        integer,             -- priority managed by system
    STATUS          varchar not null,    -- QUEUED, PROCESSING, COMPLETED, CANCELED, PAUSED, FAILED
    MESSAGE         varchar,             -- additional text inforamtion for status (like failure reason)
	SIZE            integer,             -- total size of requested media (bytes)
    DOWNLOADED      integer,             -- size of downloaded chunks (bytes)
    COMPLETED_TIME  timestamp without time zone -- moment when request is completed
);
