

ALTER TABLE event ADD COLUMN externalid VARCHAR NULL;


DROP FUNCTION el_get_event(integer);
DROP TYPE EL_Event;

CREATE TYPE EL_Event as
(
    objid                integer, 
    eventsource          integer, 
    utc_when             bigint,
    utc_from             bigint,
    utc_to               bigint,
    priority             integer, 
    state                integer, 
    message              character varying,
    note                 character varying, 
    lifespan             integer,
    eventtype            integer,
    externalid           character varying,
    eventproperty_name   character varying,
    eventproperty_value  character varying,
    witness_objid        integer,
    witness_name         character varying(255),
    witness_otype        character(1), 
    witness_subtype      character(1),
    witness_timedst      character varying,
    witness_tz           character varying
);


-- Returns set of rows with event info, properties and witnesses 
CREATE OR REPLACE FUNCTION el_get_event(integer) RETURNS setof EL_Event AS
$$
DECLARE 
   result EL_Event;
BEGIN

FOR result in
    SELECT  
               event.objid, 
               eventsource, 
               extract('epoch' from utc_when) + extract(timezone from current_time),
               extract('epoch' from utc_from) + extract(timezone from current_time),
               extract('epoch' from utc_to)   + extract(timezone from current_time), 
               priority, 
               state, 
               message, 
               note, 
               lifespan, 
               eventtype,
               externalid,
               eventproperty.name, 
               eventproperty.value, 
               -- fields bellow used in next SELECT
               NULL as witness_objid, 
               NULL as witness_name, 
               NULL as witness_otype, 
               NULL as witness_subtype, 
               NULL as witness_timedst, 
               NULL as witness_tz 
    FROM event 
    LEFT JOIN eventproperty ON eventproperty.eventid=event.eventid
    WHERE event.eventid=$1
    UNION
    SELECT NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
              eventwitness.objid, 
              _objs.name, 
              otype, 
              subtype, 
              _obj_attr.val,
              0       
    FROM event, _objs, eventwitness, _obj_attr
    WHERE event.eventid=$1 AND eventwitness.eventid=event.eventid AND _objs.obj = eventwitness.objid
      AND _obj_attr.obj=eventwitness.objid AND _obj_attr.attr='TIME_ZONE'
    ORDER BY objid ASC
LOOP
RETURN NEXT result;
END LOOP;
 
RETURN;

END
$$ LANGUAGE 'plpgsql';




CREATE OR REPLACE FUNCTION el_insert_event(integer, integer, integer, integer, bigint, bigint, bigint, integer, integer, integer, character varying, character varying) RETURNS integer AS
$$
BEGIN

INSERT INTO event (objid, eventsource, workflow, state, utc_when, utc_from, utc_to, priority, lifespan, eventtype, message, externalid)
VALUES ($1, $2, $3, $4, 
        TIMESTAMP 'epoch' + $5 * INTERVAL '1 second',
        TIMESTAMP 'epoch' + $6 * INTERVAL '1 second',
        TIMESTAMP 'epoch' + $7 * INTERVAL '1 second',
        $8, $9, $10, $11, $12);

RETURN (SELECT currval('seqEventId'));

END;
$$ LANGUAGE 'plpgsql';




-- Returns event id of candidate to merge
CREATE OR REPLACE FUNCTION el_get_event_for_merge(integer, integer, character varying) RETURNS integer AS
$$
DECLARE 
   obj_id  ALIAS FOR $1; 
   event_id integer := NULL;
   external_id  ALIAS FOR $3; 
BEGIN
   IF (external_id IS NULL OR length(external_id) = 0) THEN
      event_id := (SELECT MAX(eventid) FROM event WHERE objid=$1 AND eventsource=$2);
   ELSE
      event_id := (SELECT MAX(eventid) FROM event WHERE objid=$1 AND eventsource=$2 AND externalid=external_id);
   END IF;

   RETURN event_id;

END;
$$ LANGUAGE 'plpgsql';
