
-- dictionary

CREATE TABLE auditlevel (
        level           integer PRIMARY KEY,
        name            varchar(200) NOT NULL
);

INSERT INTO auditlevel (level, name) VALUES
(1, 'DEBUG'),
(2, 'INFO'),
(3, 'WARN'),
(4, 'ERROR'),
(5, 'FATAL');


CREATE TABLE auditcategory (
        category        integer PRIMARY KEY,
        parent          integer,
        name            varchar(200) NOT NULL,
        digest          varchar
);


INSERT INTO auditcategory (category, parent, name, digest) VALUES
(1,null,'User: Authentication', null),
(2,1,'Login','Login successful'),
(3,1,'Logout','Logout successful'),
(4,1,'Session expired', 'Session expired'),
(5,1,'Session forced closed', 'Session forced closed by %1'),
(6,null,'User: Actions',null),
(7,6,'Open GUI',E'User opened \'%1\''),
(8,6,'Load/ Save/ Delete/ Share configuration','Matrix GUI configuration %1'),
(9,6,'PTZ: lock/ unlock/ expired/ override','PTZ: %1'),
(10,6,'PTZ Tour: create/ delete / edit / share / activate/ stop',null),
(11,6,'vMX: [re]split / place video / place tour / configuration load/save/edit','vMX: %1'),
(12,6,'Open video: live/ archive', '%1 stream request'),
(13,6,'Local camera tour: place into matrix, change set of cameras to x,y,z, activate / stop','Local camera tour: %1'),
(14,6,'Export media-clip','Media clip export'),
(15,6,'Objects control through OM: ACSG objects', 'Invoke method %1'),
(16,null,'User: Eventlog',null),
(17,16,'Review event (open dialog)','Event %1 review'),
(18,16,'Execute action/command on event', E'Execute command \'%1\' on event'),
(19,16,'Execute command on assocaited device', 'Execute command on associated device'),
(20,16,'Update event properties','Update event properties'),
(23,16,'Review video: on originator / on all witnesses','Review event %1 video from %2'),
(24,16,'Create event through "[R]" (recording)',null),
(25,null,'Object: Management',null),
(26,25,'device management','%1 %2'),
(27,25,'storage management', E'Submit command \'%1\' to volume %2'),
(28,null,'Object: Health',null),
(29,28,'devices health: on / off / broken / etc...', E'Health status set to \'%1\''),
(30,28,'storage management: volumes state', E'Volume \'%1\' %2'),
(31,28,'cache problems: overflow, lost chunks / restarts',null),
(32,28,'system status changes', E'System status set to \'%1\' %2'),
(33,null,'Credentials: Users',null),
(34,33,'User add/ edit / remove',E'User \'%1\' %2'),
(35,null,'Credentials: Objects',null),
(36,35,'all role/set ownership and assignment changes',null),
(37,35,'future extension: user-defined permission levels',null),
(38,28,'WIPE','%1');

-- big table for storing audit records

CREATE TABLE audit (
	date timestamp without time zone NOT NULL DEFAULT timezone('UTC'::text, now()),
	category integer NOT NULL,
	userid integer,
	objid integer,
    level integer DEFAULT 2,
	parameters varchar);

CREATE INDEX idx_auditlog_objid ON audit(objid);

