SET search_path to apl;

CREATE OR REPLACE FUNCTION initCamNODEID() RETURNS VOID AS $$
DECLARE
    objrec RECORD;
BEGIN
    FOR objrec IN SELECT * FROM _objs WHERE otype='D' AND subtype in ('C','A') AND deleted=0 LOOP
	BEGIN
	    INSERT INTO  _obj_attr VALUES (objrec.obj, 'NODEID', objrec.node_id);
	EXCEPTION WHEN unique_violation THEN
	    UPDATE _obj_attr SET val=objrec.node_id WHERE attr='NODEID';
	END;
    END LOOP;
END;
$$ LANGUAGE plpgsql;

SELECT initCamNODEID();
