SET search_path TO confdb;

CREATE TABLE eventannounce (
  eventid integer not null,
  announced_by_userid integer not null, -- ID of user who created announce
  announced_at timestamp without time zone default (now() at time zone 'UTC') not null, -- date/time when announce was created
  announce_to_userid integer not null, -- ID of user to deliver notification
  PRIMARY KEY(announce_to_userid, eventid)
);

SET search_path TO apl;

CREATE OR REPLACE VIEW eventannounce as select * from confdb.eventannounce;

CREATE OR REPLACE RULE v_eventannounce_ins AS ON INSERT TO eventannounce
  DO INSTEAD
  INSERT INTO confdb.eventannounce VALUES (NEW.*);

CREATE OR REPLACE RULE v_eventannounce_upd AS ON UPDATE TO eventannounce
  DO INSTEAD NOTHING;

CREATE OR REPLACE RULE v_eventannounce_del AS ON DELETE TO eventannounce
 	DO INSTEAD
	DELETE FROM confdb.eventannounce WHERE eventid=OLD.eventid AND announce_to_userid=OLD.announce_to_userid;

ALTER VIEW eventannounce ALTER COLUMN announced_at SET DEFAULT (now() at time zone 'UTC');

GRANT select, insert, update, delete ON eventannounce to apl;
