
-- CIRRUS_REMOVE_BEGIN

SET search_path TO confdb;


--
-- Analytic workflow with merge
--

UPDATE workflow
SET description = 'Analytic workflow with event merge',
    context = 
'<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow"> 
  <state id="empty">
    <transition event="create" target="yellow" cond="property.confidence &lt; 1" lib="elog_actions"/>
    <transition event="create" target="red"/>
  </state>

  <state id="red">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Red" tags="4,5,7,10,11"/>
      </data>
    </datamodel>
    <onentry>
      <assign location="property.BGCOLOR" expr="FF0000" lib="elog_actions"/>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>
    <transition event="update" target="yellow" cond="property.confidence &lt; 1" lib="elog_actions"/>
    <transition event="update" target="red"/>
    <transition event="clear" target="cleared"/>
  </state>

  <state id="yellow">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Yellow" tags="4,5,7,10"/>
      </data>
    </datamodel>
    <onentry>
      <assign location="property.BGCOLOR" expr="FFFF00" lib="elog_actions"/>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>
    <transition event="update" target="yellow" cond="property.confidence &lt; 1" lib="elog_actions"/>
    <transition event="update" target="red"/>
    <transition event="clear" target="cleared"/>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,5,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <assign location="property.BGCOLOR" expr="FFFFFF" lib="elog_actions"/>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <transition event="update" target="cleared"/>
  </state>
</scxml>
' 
WHERE workflow = 7;


INSERT INTO eventstatetag (eventstate, eventtag) VALUES (17, 10);
INSERT INTO eventstatetag (eventstate, eventtag) VALUES (18, 10);

-- CIRRUS_REMOVE_END
