SET search_path TO apl;

-- Routines for querying and purging expired objects
CREATE OR REPLACE FUNCTION purge_expired_objects(integer, integer) RETURNS integer AS $$
DECLARE
    num_objs ALIAS FOR $1;
    preserve_hours ALIAS FOR $2;
    result integer;
BEGIN
    CREATE TEMPORARY TABLE exp_objs (o integer) ON COMMIT DROP;
    
    INSERT INTO exp_objs
	SELECT obj FROM _objs WHERE ((otype='D' and subtype <> 'N') OR otype='X') 
	AND deleted=1 AND protected=0 AND (now() at time zone 'UTC' - (preserve_hours || 'hour')::interval) > rtime 
	AND obj > 99 AND NOT EXISTS (SELECT 1 FROM event WHERE objid=obj) 
	ORDER BY rtime LIMIT num_objs;
    
    DELETE FROM obj_block WHERE obj IN (SELECT o FROM exp_objs);
    DELETE FROM _obj_attr WHERE obj IN (SELECT o FROM exp_objs);
    DELETE FROM _links WHERE obj_res IN (SELECT o FROM exp_objs) OR obj_cons IN (SELECT o FROM exp_objs);
    DELETE FROM _objs WHERE obj IN (SELECT o FROM exp_objs);

    GET DIAGNOSTICS result = ROW_COUNT;
    
    RETURN result;    
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION count_expired_objects(integer) RETURNS integer AS $$
DECLARE
    preserve_hours ALIAS FOR $1;
    result integer;
BEGIN
    
    SELECT count(obj) INTO result FROM _objs WHERE ((otype='D' and subtype <> 'N') OR otype='X') 
	AND deleted=1 AND protected=0 AND (now() at time zone 'UTC' - (preserve_hours || 'hour')::interval) > rtime 
	AND obj > 99 AND NOT EXISTS (SELECT 1 FROM event WHERE objid=obj);
    
    RETURN result;
    
END;
$$ LANGUAGE plpgsql;
