-- Change table ownership to postgres
CREATE OR REPLACE FUNCTION apl.chownTables(text, text) RETURNS VOID AS $$
DECLARE
    user_name alias for $1;
    schema_name alias for $2;
    tableentry RECORD;
BEGIN
    -- tables
    FOR tableentry IN SELECT * FROM information_schema.tables WHERE table_schema=schema_name LOOP
	EXECUTE 'ALTER TABLE ' || schema_name || '.' || quote_ident(tableentry.table_name) || ' OWNER TO ' || user_name;
    END LOOP;
    -- sequences
    FOR tableentry IN SELECT * FROM information_schema.sequences WHERE sequence_schema=schema_name LOOP
	EXECUTE 'ALTER SEQUENCE ' || schema_name || '.' || quote_ident(tableentry.sequence_name) || ' OWNER TO ' || user_name;
    END LOOP;

END;
$$ LANGUAGE plpgsql;

SELECT apl.chownTables('postgres','confdb');
SELECT apl.chownTables('postgres','transdb');

-- Change ownership for rest of DB objects
ALTER AGGREGATE apl.concatfields(text) OWNER TO postgres;

-- functions
ALTER FUNCTION confdb.updateUDID() OWNER TO postgres;
ALTER FUNCTION confdb.insertAttributes() OWNER TO postgres;
ALTER FUNCTION confdb.updateAttributes() OWNER TO postgres;
ALTER FUNCTION confdb.logg(varchar) OWNER TO postgres;
ALTER FUNCTION confdb.attr_archstate_on_of() OWNER TO postgres;
ALTER FUNCTION confdb.insert_link_type() OWNER TO postgres;
ALTER FUNCTION confdb.addMatrix() OWNER TO postgres;
ALTER FUNCTION confdb.set_cmd_stime() OWNER TO postgres;
ALTER FUNCTION confdb.set_stime() OWNER TO postgres;

ALTER FUNCTION apl.getNodes() OWNER TO postgres;
ALTER FUNCTION apl.merge_obj_attr(objid INT, name VARCHAR, value VARCHAR) OWNER TO postgres;
ALTER FUNCTION apl.getObject(userobj integer, objectobj integer) OWNER TO postgres;
ALTER FUNCTION apl.getObjects(userobj integer, roleobj integer, objtype char(1), objsubtype char(1)) OWNER TO postgres;
ALTER FUNCTION apl.getObjects(userobj integer, roleobj integer, setobj integer, objtype char(1), objsubtype char(1)) OWNER TO postgres;
ALTER FUNCTION apl.getObjectsFromSet(setobj integer, otype char(1), subtype char(1)) OWNER TO postgres;
ALTER FUNCTION apl.getSetsFromRole(roleobj integer) OWNER TO postgres;
ALTER FUNCTION apl.getObjectsFromRole(roleobj integer, otype char(1), subtype char(1)) OWNER TO postgres;
ALTER FUNCTION apl.getUsers() OWNER TO postgres;
ALTER FUNCTION apl.getUsers(roleobj integer) OWNER TO postgres;
ALTER FUNCTION apl.getSets() OWNER TO postgres;
ALTER FUNCTION apl.getSets(objectobj integer) OWNER TO postgres;
ALTER FUNCTION apl.getSets(userobj integer, roleobj integer, objectobj integer) OWNER TO postgres;
ALTER FUNCTION apl.getRoles() OWNER TO postgres;
ALTER FUNCTION apl.getRoles(userobj integer) OWNER TO postgres;
ALTER FUNCTION apl.getRolesForSet(setobj integer) OWNER TO postgres;

-- types
ALTER TYPE apl.object_list_with_credentials OWNER TO postgres;
ALTER TYPE apl.object_list_without_credentials OWNER TO postgres;
ALTER TYPE apl.object_list OWNER TO postgres;
