-- Create specific views as substitutes for sequences
-- Create routines for replacing calls to sequences

SET search_path TO apl;

-- seq_obj
CREATE OR REPLACE VIEW v_seq_obj (currval) AS SELECT 0::bigint;

CREATE OR REPLACE RULE "_RETURN" AS ON SELECT TO v_seq_obj DO INSTEAD
    SELECT currval('confdb.seq_obj');
CREATE OR REPLACE RULE v_seq_obj_nextval AS ON UPDATE TO v_seq_obj
DO INSTEAD
    SELECT nextval('confdb.seq_obj');


CREATE OR REPLACE FUNCTION nextval_seq_obj() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    UPDATE v_seq_obj SET currval=DEFAULT;
    val := (SELECT currval FROM v_seq_obj);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION currval_seq_obj() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    val := (SELECT currval FROM v_seq_obj);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

ALTER VIEW _objs ALTER COLUMN obj SET DEFAULT nextval_seq_obj();


-- dyna_data_seq
CREATE OR REPLACE VIEW v_dyna_data_seq (currval) AS SELECT 0::bigint;

CREATE OR REPLACE RULE "_RETURN" AS ON SELECT TO v_dyna_data_seq DO INSTEAD
    SELECT currval('confdb.dyna_data_seq');
CREATE OR REPLACE RULE v_dyna_data_seq_nextval AS ON UPDATE TO v_dyna_data_seq
DO INSTEAD
    SELECT nextval('confdb.dyna_data_seq');

CREATE OR REPLACE FUNCTION nextval_dyna_data_seq() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    UPDATE v_dyna_data_seq SET currval=DEFAULT;
    val := (SELECT currval FROM v_dyna_data_seq);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION currval_dyna_data_seq() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    val := (SELECT currval FROM v_dyna_data_seq);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

ALTER VIEW dyna_data ALTER COLUMN ind SET DEFAULT nextval_dyna_data_seq();


-- seqblockid
CREATE OR REPLACE VIEW v_seqblockid (currval) AS SELECT 0::bigint;

CREATE OR REPLACE RULE "_RETURN" AS ON SELECT TO v_seqblockid DO INSTEAD
    SELECT currval('confdb.seqblockid');
CREATE OR REPLACE RULE v_seqblockid_nextval AS ON UPDATE TO v_seqblockid
DO INSTEAD
    SELECT nextval('confdb.seqblockid');

CREATE OR REPLACE FUNCTION nextval_seqblockid() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    UPDATE v_seqblockid SET currval=DEFAULT;
    val := (SELECT currval FROM v_seqblockid);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION currval_seqblockid() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    val := (SELECT currval FROM v_seqblockid);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

ALTER VIEW obj_block ALTER COLUMN blockid SET DEFAULT nextval_seqblockid();

-- seq_event_emailer_snapshot

CREATE OR REPLACE VIEW v_seq_event_emailer_snapshot (currval) AS SELECT 0::bigint;

CREATE OR REPLACE RULE "_RETURN" AS ON SELECT TO v_seq_event_emailer_snapshot DO INSTEAD
    SELECT currval('confdb.seq_obj');
CREATE OR REPLACE RULE v_seq_event_emailer_snapshot_nextval AS ON UPDATE TO v_seq_event_emailer_snapshot
DO INSTEAD
    SELECT nextval('confdb.seq_obj');

CREATE OR REPLACE FUNCTION nextval_seq_event_emailer_snapshot() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    UPDATE v_seq_event_emailer_snapshot SET currval=DEFAULT;
    val := (SELECT currval FROM v_seq_event_emailer_snapshot);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION currval_seq_event_emailer_snapshot() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    val := (SELECT currval FROM v_seq_event_emailer_snapshot);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

-- sm_dblog_rid
CREATE OR REPLACE VIEW v_sm_dblog_rid (currval) AS SELECT 0::bigint;

CREATE OR REPLACE RULE "_RETURN" AS ON SELECT TO v_sm_dblog_rid DO INSTEAD
    SELECT currval('confdb.sm_dblog_rid');
CREATE OR REPLACE RULE v_sm_dblog_rid_nextval AS ON UPDATE TO v_sm_dblog_rid
DO INSTEAD
    SELECT nextval('confdb.sm_dblog_rid');



CREATE OR REPLACE FUNCTION nextval_sm_dblog_rid() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    UPDATE v_sm_dblog_rid SET currval=DEFAULT;
    val := (SELECT currval FROM v_sm_dblog_rid);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION currval_sm_dblog_rid() RETURNS int AS $$
DECLARE
    val bigint;
BEGIN
    val := (SELECT currval FROM v_sm_dblog_rid);
    RETURN val;
END;
$$ LANGUAGE plpgsql;

ALTER VIEW sm_dblog ALTER COLUMN rid SET DEFAULT nextval_sm_dblog_rid();

-- Create proxy sequences for read-only public requests 
--
CREATE OR REPLACE VIEW v_sm_dblog_rid_ro AS SELECT * from confdb.sm_dblog_rid;
