SET search_path TO apl;

-- _obj_otypes
-- Insert/update/delete on _obj_otypes is forbidden for apl
CREATE OR REPLACE VIEW _obj_otypes as select * from confdb._obj_otypes;
CREATE OR REPLACE RULE v_obj_otypes_ins AS ON INSERT TO _obj_otypes
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_obj_otypes_upd AS ON UPDATE TO _obj_otypes
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_obj_otypes_del AS ON DELETE TO _obj_otypes
 	DO INSTEAD NOTHING;
	
-- _obj_otype_subtype
-- Insert/update/delete on _obj_otype_subtype is forbidden for apl
CREATE OR REPLACE VIEW _obj_otype_subtype as select * from confdb._obj_otype_subtype;
CREATE OR REPLACE RULE v_obj_otype_subtype_ins AS ON INSERT TO _obj_otype_subtype
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_obj_otype_subtype_upd AS ON UPDATE TO _obj_otype_subtype
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_obj_otype_subtype_del AS ON DELETE TO _obj_otype_subtype
 	DO INSTEAD NOTHING;

-- _objs
CREATE OR REPLACE VIEW _objs as select * from confdb._objs;

CREATE OR REPLACE RULE v_objs_ins AS ON INSERT TO _objs
    DO INSTEAD
	INSERT INTO confdb._objs VALUES (NEW.*);
	    	    
CREATE OR REPLACE RULE v_objs_upd AS ON UPDATE TO _objs
 	DO INSTEAD
 	UPDATE confdb._objs
 	SET
 	    udid=NEW.udid,
 	    node_id=NEW.node_id,
 	    node_ip=NEW.node_ip,
 	    name=NEW.name,
	    description=NEW.description,
 	    location=NEW.location,
 	    deleted=NEW.deleted,
 	    protected=NEW.protected,
 	    updated_at=NEW.updated_at,
 	    stime=NEW.stime,
 	    rtime=NEW.rtime,
 	    owner=NEW.owner
 	WHERE obj=OLD.obj and protected=OLD.protected;
 	
CREATE OR REPLACE RULE v_objs_del AS ON DELETE TO _objs
 	DO INSTEAD
	DELETE FROM confdb._objs WHERE obj=OLD.obj;

ALTER VIEW _objs ALTER COLUMN name SET DEFAULT '';
ALTER VIEW _objs ALTER COLUMN description SET DEFAULT '';
ALTER VIEW _objs ALTER COLUMN location SET DEFAULT '';
ALTER VIEW _objs ALTER COLUMN updated_at SET DEFAULT (now() at time zone 'UTC');
ALTER VIEW _objs ALTER COLUMN deleted SET DEFAULT 0;
ALTER VIEW _objs ALTER COLUMN protected SET DEFAULT 0;
ALTER VIEW _objs ALTER COLUMN stime SET DEFAULT (now() at time zone 'UTC');


-- _obj_attr
CREATE OR REPLACE VIEW _obj_attr as select * from confdb._obj_attr;

CREATE OR REPLACE RULE v_obj_attr_ins AS ON INSERT TO _obj_attr
    DO INSTEAD
	INSERT INTO confdb._obj_attr (obj,attr,val) 
	    VALUES (NEW.obj, NEW.attr, NEW.val);
	    	    	    
CREATE OR REPLACE RULE v_obj_attr_upd AS ON UPDATE TO _obj_attr
 	DO INSTEAD
 	UPDATE confdb._obj_attr
 	SET
	    val=NEW.val
 	WHERE obj=OLD.obj and attr=OLD.attr;
 	
CREATE OR REPLACE RULE v_obj_attr_del AS ON DELETE TO _obj_attr
 	DO INSTEAD
	DELETE FROM confdb._obj_attr 
	WHERE obj=OLD.obj and attr=OLD.attr;

-- obj_block
CREATE OR REPLACE VIEW obj_block as select * from confdb.obj_block;
CREATE OR REPLACE RULE v_obj_block_ins AS ON INSERT TO obj_block
    DO INSTEAD
	INSERT INTO confdb.obj_block VALUES (NEW.*);
CREATE OR REPLACE RULE v_obj_block_upd AS ON UPDATE TO obj_block
    DO INSTEAD 
	UPDATE confdb.obj_block
	SET
	    name=NEW.name,
	    description=NEW.description,
	    mime=NEW.mime,
	    block=NEW.block
	WHERE blockid=OLD.blockid AND obj=OLD.obj;
	
CREATE OR REPLACE RULE v_obj_block_del AS ON DELETE TO obj_block
 	DO INSTEAD
	DELETE FROM confdb.obj_block
	    WHERE 
		obj=OLD.obj and
		blockid=OLD.blockid;

ALTER VIEW obj_block ALTER COLUMN name SET DEFAULT ''::varchar;
ALTER VIEW obj_block ALTER COLUMN description SET DEFAULT ''::varchar;
ALTER VIEW obj_block ALTER COLUMN mime SET DEFAULT 'application/octet-stream'::varchar;

-- permission_type
-- Insert/update/delete on permission_type is forbidden for apl
CREATE OR REPLACE VIEW permission_type as select * from confdb.permission_type;
CREATE OR REPLACE RULE v_permission_type_ins AS ON INSERT TO permission_type
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_permission_type_upd AS ON UPDATE TO permission_type
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_permission_type_del AS ON DELETE TO permission_type
 	DO INSTEAD NOTHING;
		
-- _link_types
-- Insert/update/delete on _link_types is forbidden for apl
CREATE OR REPLACE VIEW _link_types as select * from confdb._link_types;
CREATE OR REPLACE RULE v_link_types_ins AS ON INSERT TO _link_types
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_link_types_upd AS ON UPDATE TO _link_types
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_link_types_del AS ON DELETE TO _link_types
 	DO INSTEAD NOTHING;

-- _cred_types
-- Insert/update/delete on _cred_types is forbidden for apl
CREATE OR REPLACE VIEW _cred_types as select * from confdb._cred_types;
CREATE OR REPLACE RULE v_cred_types_ins AS ON INSERT TO _cred_types
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_cred_types_upd AS ON UPDATE TO _cred_types
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_cred_types_del AS ON DELETE TO _cred_types
 	DO INSTEAD NOTHING;

-- _links
CREATE OR REPLACE VIEW _links as select * from confdb._links;
CREATE OR REPLACE RULE v_links_ins AS ON INSERT TO _links
    DO INSTEAD
	INSERT INTO confdb._links VALUES (NEW.*);
	
CREATE OR REPLACE RULE v_links_upd AS ON UPDATE TO _links
    DO INSTEAD 
	UPDATE confdb._links
	SET obj_res=NEW.obj_res,
	    obj_cons=NEW.obj_cons,
	    link_type=NEW.link_type,
	    protected=NEW.protected,
	    permission=NEW.permission,
	    special_credentials=NEW.special_credentials,
	    level=NEW.level
	WHERE obj_res=OLD.obj_res AND obj_cons=OLD.obj_cons AND protected=OLD.protected;
CREATE OR REPLACE RULE v_links_del AS ON DELETE TO _links
 	DO INSTEAD
	DELETE FROM confdb._links
	    WHERE 
		obj_res=OLD.obj_res AND
		obj_cons=OLD.obj_cons AND
		link_type=OLD.link_type AND
		protected=OLD.protected;

ALTER VIEW _links ALTER COLUMN special_credentials SET DEFAULT ''::varchar;
ALTER VIEW _links ALTER COLUMN protected SET DEFAULT 0;
ALTER VIEW _links ALTER COLUMN level SET DEFAULT 0;
ALTER VIEW _links ALTER COLUMN updated_at SET DEFAULT timezone('UTC'::text, now());

-- dyna_types
-- Insert/update/delete on dyna_types is forbidden for apl
CREATE OR REPLACE VIEW dyna_types as select * from confdb.dyna_types;
CREATE OR REPLACE RULE v_dyna_types_ins AS ON INSERT TO dyna_types
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_dyna_types_upd AS ON UPDATE TO dyna_types
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_dyna_types_del AS ON DELETE TO dyna_types
 	DO INSTEAD NOTHING;
 	
-- dyna_data
CREATE OR REPLACE VIEW dyna_data as select * from confdb.dyna_data;
CREATE OR REPLACE RULE v_dyna_data_ins AS ON INSERT TO dyna_data
    DO INSTEAD 
    INSERT INTO confdb.dyna_data VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_dyna_data_upd AS ON UPDATE TO dyna_data
 	DO INSTEAD
 	UPDATE confdb.dyna_data
 	SET
	    description=NEW.description,
 	    typeid=NEW.typeid,
 	    contentid=NEW.contentid,
 	    data=NEW.data
 	WHERE ind=OLD.ind;
 	 	
CREATE OR REPLACE RULE v_dyna_data_del AS ON DELETE TO dyna_data
 	DO INSTEAD
	DELETE FROM confdb.dyna_data WHERE ind=OLD.ind;


-- event_emailer_snapshot
CREATE OR REPLACE VIEW event_emailer_snapshot as select * from confdb.event_emailer_snapshot;
CREATE OR REPLACE RULE v_event_emailer_snapshot_ins AS ON INSERT TO event_emailer_snapshot
    DO INSTEAD 
    INSERT INTO confdb.event_emailer_snapshot VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_event_emailer_snapshot_upd AS ON UPDATE TO event_emailer_snapshot
 	DO INSTEAD
 	UPDATE confdb.event_emailer_snapshot
 	SET
	    userid=NEW.userid,
 	    eventid=NEW.eventid,
 	    ts_created=NEW.ts_created
 	WHERE snapshotid=OLD.snapshotid and userid=OLD.userid and eventid=OLD.eventid;
 	 	
CREATE OR REPLACE RULE v_event_emailer_snapshot_del AS ON DELETE TO event_emailer_snapshot
 	DO INSTEAD
	DELETE FROM confdb.event_emailer_snapshot 
	    WHERE 
		snapshotid=OLD.snapshotid and 
		userid=OLD.userid and 
		eventid=OLD.eventid and 
		ts_created=OLD.ts_created;
		
ALTER VIEW event_emailer_snapshot ALTER COLUMN ts_created SET DEFAULT timezone('UTC'::text, now());

-- event_emailer_tag
CREATE OR REPLACE VIEW event_emailer_tag as select * from confdb.event_emailer_tag;
CREATE OR REPLACE RULE v_event_emailer_tag_ins AS ON INSERT TO event_emailer_tag
    DO INSTEAD 
    INSERT INTO confdb.event_emailer_tag VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_event_emailer_tag_upd AS ON UPDATE TO event_emailer_tag
 	DO INSTEAD
 	UPDATE confdb.event_emailer_tag
 	SET
	    userid=NEW.userid,
 	    last_eventid=NEW.last_eventid,
 	    last_send=NEW.last_send
 	WHERE userid=OLD.userid and last_eventid=OLD.last_eventid and last_send=OLD.last_send;
 	 	
CREATE OR REPLACE RULE v_event_emailer_tag_del AS ON DELETE TO event_emailer_tag
 	DO INSTEAD
	DELETE FROM confdb.event_emailer_tag 
	    WHERE 
		userid=OLD.userid and 
		last_eventid=OLD.last_eventid and 
		last_send=OLD.last_send;

-- eventlifespan
-- Insert/update/delete on eventlifespan is forbidden for apl
CREATE OR REPLACE VIEW eventlifespan as select * from confdb.eventlifespan;
CREATE OR REPLACE RULE v_eventlifespan_ins AS ON INSERT TO eventlifespan
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventlifespan_upd AS ON UPDATE TO eventlifespan
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventlifespan_del AS ON DELETE TO eventlifespan
 	DO INSTEAD NOTHING;
 	
-- eventpriority
-- Insert/update/delete on eventpriority is forbidden for apl
CREATE OR REPLACE VIEW eventpriority as select * from confdb.eventpriority;
CREATE OR REPLACE RULE v_eventpriority_ins AS ON INSERT TO eventpriority
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventpriority_upd AS ON UPDATE TO eventpriority
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventpriority_del AS ON DELETE TO eventpriority
 	DO INSTEAD NOTHING;

-- eventpropertydef
-- Insert/update/delete on eventpropertydef is forbidden for apl
CREATE OR REPLACE VIEW eventpropertydef as select * from confdb.eventpropertydef;
CREATE OR REPLACE RULE v_eventpropertydef_ins AS ON INSERT TO eventpropertydef
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventpropertydef_upd AS ON UPDATE TO eventpropertydef
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventpropertydef_del AS ON DELETE TO eventpropertydef
 	DO INSTEAD NOTHING;

-- eventsource
-- Insert/update/delete on eventsource is forbidden for apl
CREATE OR REPLACE VIEW eventsource as select * from confdb.eventsource;
CREATE OR REPLACE RULE v_eventsource_ins AS ON INSERT TO eventsource
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventsource_upd AS ON UPDATE TO eventsource
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventsource_del AS ON DELETE TO eventsource
 	DO INSTEAD NOTHING;

-- eventstate
-- Insert/update/delete on eventstate is forbidden for apl
CREATE OR REPLACE VIEW eventstate as select * from confdb.eventstate;
CREATE OR REPLACE RULE v_eventstate_ins AS ON INSERT TO eventstate
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventstate_upd AS ON UPDATE TO eventstate
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventstate_del AS ON DELETE TO eventstate
 	DO INSTEAD NOTHING;

-- eventstatetag
-- Insert/update/delete on eventstatetag is forbidden for apl
CREATE OR REPLACE VIEW eventstatetag as select * from confdb.eventstatetag;
CREATE OR REPLACE RULE v_eventstatetag_ins AS ON INSERT TO eventstatetag
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventstatetag_upd AS ON UPDATE TO eventstatetag
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventstatetag_del AS ON DELETE TO eventstatetag
 	DO INSTEAD NOTHING;
 	
-- eventtag
-- Insert/update/delete on eventtag is forbidden for apl
CREATE OR REPLACE VIEW eventtag as select * from confdb.eventtag;
CREATE OR REPLACE RULE v_eventtag_ins AS ON INSERT TO eventtag
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventtag_upd AS ON UPDATE TO eventtag
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventtag_del AS ON DELETE TO eventtag
 	DO INSTEAD NOTHING;
 	
-- eventtype
-- Insert/update/delete on eventtype is forbidden for apl
CREATE OR REPLACE VIEW eventtype as select * from confdb.eventtype;
CREATE OR REPLACE RULE v_eventtype_ins AS ON INSERT TO eventtype
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventtype_upd AS ON UPDATE TO eventtype
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_eventtype_del AS ON DELETE TO eventtype
 	DO INSTEAD NOTHING;

-- storagertntype
-- Insert/update/delete on storagertntype is forbidden for apl
CREATE OR REPLACE VIEW storagertntype as select * from confdb.storagertntype;
CREATE OR REPLACE RULE v_storagertntype_ins AS ON INSERT TO storagertntype
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_storagertntype_upd AS ON UPDATE TO storagertntype
    DO INSTEAD NOTHING;
CREATE OR REPLACE RULE v_storagertntype_del AS ON DELETE TO storagertntype
 	DO INSTEAD NOTHING;

-- schedulehist
CREATE OR REPLACE VIEW schedulehist as select * from confdb.schedulehist;
CREATE OR REPLACE RULE v_schedulehist_ins AS ON INSERT TO schedulehist
    DO INSTEAD 
    INSERT INTO confdb.schedulehist VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_schedulehist_upd AS ON UPDATE TO schedulehist
 	DO INSTEAD
 	UPDATE confdb.schedulehist
 	SET
 	    data=NEW.data
 	WHERE scheduleid=OLD.scheduleid and subjectid=OLD.subjectid and propname=OLD.propname;
 	 	
CREATE OR REPLACE RULE v_schedulehist_del AS ON DELETE TO schedulehist
 	DO INSTEAD
	DELETE FROM confdb.schedulehist 
	    WHERE 
		scheduleid=OLD.scheduleid and 
		subjectid=OLD.subjectid and 
		propname=OLD.propname;		
		
-- schedulelink
CREATE OR REPLACE VIEW schedulelink as select * from confdb.schedulelink;
CREATE OR REPLACE RULE v_schedulelink_ins AS ON INSERT TO schedulelink
    DO INSTEAD 
    INSERT INTO confdb.schedulelink VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_schedulelink_upd AS ON UPDATE TO schedulelink
 	DO INSTEAD
 	UPDATE confdb.schedulelink
 	SET
	    scheduleid=NEW.scheduleid,
 	    timecardid=NEW.timecardid,
 	    postureid=NEW.postureid
 	WHERE scheduleid=OLD.scheduleid and timecardid=OLD.timecardid and postureid=OLD.postureid;
 	 	
CREATE OR REPLACE RULE v_schedulelink_del AS ON DELETE TO schedulelink
 	DO INSTEAD
	DELETE FROM confdb.schedulelink 
	    WHERE 
		scheduleid=OLD.scheduleid and 
		timecardid=OLD.timecardid and 
		postureid=OLD.postureid;

-- sm_cache
CREATE OR REPLACE VIEW sm_cache as select * from confdb.sm_cache;
CREATE OR REPLACE RULE v_sm_cache_ins AS ON INSERT TO sm_cache
    DO INSTEAD 
    INSERT INTO confdb.sm_cache VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_cache_upd AS ON UPDATE TO sm_cache
 	DO INSTEAD
 	UPDATE confdb.sm_cache
 	SET
 	    size=NEW.size,
 	    usage=NEW.usage,
 	    stime=NEW.stime,
 	    chunk_loss_ts=NEW.chunk_loss_ts
 	WHERE nodeid=OLD.nodeid;
 	 	
CREATE OR REPLACE RULE v_sm_cache_del AS ON DELETE TO sm_cache
 	DO INSTEAD
	DELETE FROM confdb.sm_cache WHERE nodeid=OLD.nodeid;
	
ALTER VIEW sm_cache ALTER COLUMN stime SET DEFAULT timezone('UTC'::text, now());

-- sm_cst
CREATE OR REPLACE VIEW sm_cst as select * from confdb.sm_cst;
CREATE OR REPLACE RULE v_sm_cst_ins AS ON INSERT TO sm_cst
    DO INSTEAD 
    INSERT INTO confdb.sm_cst VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_cst_upd AS ON UPDATE TO sm_cst
 	DO INSTEAD
 	UPDATE confdb.sm_cst
 	SET
 	    cst=NEW.cst,
 	    stime=NEW.stime
 	WHERE id=OLD.id;
 	 	
CREATE OR REPLACE RULE v_sm_cst_del AS ON DELETE TO sm_cst
 	DO INSTEAD
	DELETE FROM confdb.sm_cst WHERE id=OLD.id;

ALTER VIEW sm_cst ALTER COLUMN stime SET DEFAULT timezone('UTC'::text, now());	
ALTER VIEW sm_cst ALTER COLUMN cst SET DEFAULT 'OFFLINE'::varchar;

-- sm_ost
CREATE OR REPLACE VIEW sm_ost as select * from confdb.sm_ost;
CREATE OR REPLACE RULE v_sm_ost_ins AS ON INSERT TO sm_ost
    DO INSTEAD 
    INSERT INTO confdb.sm_ost VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_ost_upd AS ON UPDATE TO sm_ost
 	DO INSTEAD
 	UPDATE confdb.sm_ost
 	SET
 	    ost=NEW.ost,
 	    stime=NEW.stime
 	WHERE id=OLD.id;
 	 	
CREATE OR REPLACE RULE v_sm_ost_del AS ON DELETE TO sm_ost
 	DO INSTEAD
	DELETE FROM confdb.sm_ost WHERE id=OLD.id;
	
ALTER VIEW sm_ost ALTER COLUMN stime SET DEFAULT timezone('UTC'::text, now());	
ALTER VIEW sm_ost ALTER COLUMN ost SET DEFAULT 'offline'::varchar;

-- sm_dblog
CREATE OR REPLACE VIEW sm_dblog as select * from confdb.sm_dblog;
CREATE OR REPLACE RULE v_sm_dblog_ins AS ON INSERT TO sm_dblog
    DO INSTEAD 
    INSERT INTO confdb.sm_dblog VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_dblog_upd AS ON UPDATE TO sm_dblog
 	DO INSTEAD
 	UPDATE confdb.sm_dblog
 	SET
 	    level=NEW.level,
 	    id=NEW.id,
 	    module=NEW.module,
 	    line=NEW.line,
 	    stime=NEW.stime,
 	    note=NEW.note
 	WHERE rid=OLD.rid and nodeid=OLD.nodeid;
 	 	
CREATE OR REPLACE RULE v_sm_dblog_del AS ON DELETE TO sm_dblog
 	DO INSTEAD
	DELETE FROM confdb.sm_dblog 
	    WHERE 
		rid=OLD.rid and 
		nodeid=OLD.nodeid and
		level=OLD.level and 
		id=OLD.id and
		module=OLD.module and
		line=OLD.line and
		stime=OLD.stime and
		note=OLD.note;

ALTER VIEW sm_dblog ALTER COLUMN stime SET DEFAULT timezone('UTC'::text, now());

-- sm_nodes
CREATE OR REPLACE VIEW sm_nodes as select * from confdb.sm_nodes;
CREATE OR REPLACE RULE v_sm_nodes_ins AS ON INSERT TO sm_nodes
    DO INSTEAD 
    INSERT INTO confdb.sm_nodes VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_nodes_upd AS ON UPDATE TO sm_nodes
 	DO INSTEAD
 	UPDATE confdb.sm_nodes
 	SET
 	    name=NEW.name,
 	    cmd=NEW.cmd,
 	    target=NEW.target,
 	    stime=NEW.stime,
 	    cmd_end=NEW.cmd_end,
 	    alive=NEW.alive
 	WHERE nodeid=OLD.nodeid;
 	 	
CREATE OR REPLACE RULE v_sm_nodes_del AS ON DELETE TO sm_nodes
 	DO INSTEAD
	DELETE FROM confdb.sm_nodes WHERE nodeid=OLD.nodeid;

ALTER VIEW sm_nodes ALTER COLUMN cmd SET DEFAULT ''::varchar;
ALTER VIEW sm_nodes ALTER COLUMN stime SET DEFAULT timezone('UTC'::text, now());
ALTER VIEW sm_nodes ALTER COLUMN cmd_end SET DEFAULT timezone('UTC'::text, now());
ALTER VIEW sm_nodes ALTER COLUMN alive SET DEFAULT timezone('UTC'::text, now());

-- sm_space
CREATE OR REPLACE VIEW sm_space as select * from confdb.sm_space;
CREATE OR REPLACE RULE v_sm_space_ins AS ON INSERT TO sm_space
    DO INSTEAD 
    INSERT INTO confdb.sm_space VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_space_upd AS ON UPDATE TO sm_space
 	DO INSTEAD
 	UPDATE confdb.sm_space
 	SET
 	    stime=NEW.stime,
 	    space=NEW.space
 	WHERE nodeid=OLD.nodeid and objid=OLD.objid;
 	 	
CREATE OR REPLACE RULE v_sm_space_del AS ON DELETE TO sm_space
 	DO INSTEAD
	DELETE FROM confdb.sm_space WHERE nodeid=OLD.nodeid and objid=OLD.objid;

ALTER VIEW sm_space ALTER COLUMN stime SET DEFAULT timezone('UTC'::text, now());

-- sm_space_spread
CREATE OR REPLACE VIEW sm_space_spread as select * from confdb.sm_space_spread;
CREATE OR REPLACE RULE v_sm_space_spread_ins AS ON INSERT TO sm_space_spread
    DO INSTEAD 
    INSERT INTO confdb.sm_space_spread VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_space_spread_upd AS ON UPDATE TO sm_space_spread
 	DO INSTEAD
 	UPDATE confdb.sm_space_spread
 	SET
 	    space=NEW.space
 	WHERE nodeid=OLD.nodeid and objid=OLD.objid and id=OLD.id and day=OLD.day;
 	 	
CREATE OR REPLACE RULE v_sm_space_spread_del AS ON DELETE TO sm_space_spread
 	DO INSTEAD
	DELETE FROM confdb.sm_space_spread WHERE nodeid=OLD.nodeid and objid=OLD.objid and id=OLD.id and day=OLD.day;

-- sm_stat
CREATE OR REPLACE VIEW sm_stat as select * from confdb.sm_stat;
CREATE OR REPLACE RULE v_sm_stat_ins AS ON INSERT TO sm_stat
    DO INSTEAD 
    INSERT INTO confdb.sm_stat VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_stat_upd AS ON UPDATE TO sm_stat
 	DO INSTEAD
 	UPDATE confdb.sm_stat
 	SET
 	    size=NEW.size,
 	    free=NEW.free,
 	    used=NEW.used,
 	    limit_write=NEW.limit_write,
 	    write=NEW.write,
 	    stime=NEW.stime
 	WHERE id=OLD.id;
 	 	
CREATE OR REPLACE RULE v_sm_stat_del AS ON DELETE TO sm_stat
 	DO INSTEAD
	DELETE FROM confdb.sm_stat WHERE id=OLD.id;

ALTER VIEW sm_stat ALTER COLUMN stime SET DEFAULT timezone('UTC'::text, now());

-- sm_unused
CREATE OR REPLACE VIEW sm_unused as select * from confdb.sm_unused;
CREATE OR REPLACE RULE v_sm_unused_ins AS ON INSERT TO sm_unused
    DO INSTEAD 
    INSERT INTO confdb.sm_unused VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_unused_upd AS ON UPDATE TO sm_unused
 	DO INSTEAD
 	UPDATE confdb.sm_unused
 	SET
 	    name=NEW.name,
 	    limit_write=NEW.limit_write,
 	    target=NEW.target,
 	    mount_options=NEW.mount_options,
 	    size=NEW.size,
 	    free=NEW.free,
 	    cmd=NEW.cmd,
 	    stime=NEW.stime
 	WHERE nodeid=OLD.nodeid and id=OLD.id;
 	 	
CREATE OR REPLACE RULE v_sm_unused_del AS ON DELETE TO sm_unused
 	DO INSTEAD
	DELETE FROM confdb.sm_unused WHERE nodeid=OLD.nodeid and id=OLD.id;

ALTER VIEW sm_unused ALTER COLUMN cmd SET DEFAULT ''::varchar;
ALTER VIEW sm_unused ALTER COLUMN stime SET DEFAULT timezone('UTC'::text, now());

-- sm_wheels
CREATE OR REPLACE VIEW sm_wheels as select * from confdb.sm_wheels;
CREATE OR REPLACE RULE v_sm_wheels_ins AS ON INSERT TO sm_wheels
    DO INSTEAD 
    INSERT INTO confdb.sm_wheels VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_sm_wheels_upd AS ON UPDATE TO sm_wheels
 	DO INSTEAD
 	UPDATE confdb.sm_wheels
 	SET
 	    name=NEW.name,
 	    limit_write=NEW.limit_write,
 	    target=NEW.target,
 	    mount_options=NEW.mount_options
 	WHERE nodeid=OLD.nodeid and id=OLD.id;
 	 	
CREATE OR REPLACE RULE v_sm_wheels_del AS ON DELETE TO sm_wheels
 	DO INSTEAD
	DELETE FROM confdb.sm_wheels WHERE id=OLD.id and nodeid=OLD.nodeid;

-- storagepolicy
CREATE OR REPLACE VIEW storagepolicy as select * from confdb.storagepolicy;
CREATE OR REPLACE RULE v_storagepolicy_ins AS ON INSERT TO storagepolicy
    DO INSTEAD 
    INSERT INTO confdb.storagepolicy VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_storagepolicy_upd AS ON UPDATE TO storagepolicy
 	DO INSTEAD
 	UPDATE confdb.storagepolicy
 	SET
 	    name=NEW.name,
 	    description=NEW.description,
 	    storagertntype=NEW.storagertntype,
 	    preservedaysmin=NEW.preservedaysmin,
 	    preservedaysmax=NEW.preservedaysmax,
 	    frdtype=NEW.frdtype,
 	    frdschedule=NEW.frdschedule,
 	    protected=NEW.protected
 	WHERE storagepolicy=OLD.storagepolicy and protected=OLD.protected;
 	 	
CREATE OR REPLACE RULE v_storagepolicy_del AS ON DELETE TO storagepolicy
 	DO INSTEAD
	DELETE FROM confdb.storagepolicy WHERE storagepolicy=OLD.storagepolicy and protected=OLD.protected;

ALTER VIEW storagepolicy ALTER COLUMN preservedaysmin SET DEFAULT 0;
ALTER VIEW storagepolicy ALTER COLUMN preservedaysmax SET DEFAULT 0;
ALTER VIEW storagepolicy ALTER COLUMN protected SET DEFAULT false;

-- version_confdb
CREATE OR REPLACE VIEW version_confdb as select * from confdb.version_confdb;
CREATE OR REPLACE RULE v_version_confdb_ins AS ON INSERT TO version_confdb
    DO INSTEAD
    INSERT INTO confdb.version_confdb VALUES (NEW.*);
CREATE OR REPLACE RULE v_version_confdb_upd AS ON UPDATE TO version_confdb
    DO INSTEAD
    UPDATE confdb.version_confdb
    SET version=NEW.version,
	iteration=NEW.iteration
    WHERE version=OLD.version AND iteration=OLD.iteration;
CREATE OR REPLACE RULE v_version_confdb_del AS ON DELETE TO version_confdb
 	DO INSTEAD
 	DELETE FROM confdb.version_confdb
 	    WHERE version=OLD.version AND iteration=OLD.iteration;

-- workflow
CREATE OR REPLACE VIEW workflow as select * from confdb.workflow;
CREATE OR REPLACE RULE v_workflow_ins AS ON INSERT TO workflow
    DO INSTEAD 
    INSERT INTO confdb.workflow VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_workflow_upd AS ON UPDATE TO workflow
 	DO INSTEAD
 	UPDATE confdb.workflow
 	SET
 	    name=NEW.name,
 	    description=NEW.description,
 	    context=NEW.context,
 	    protected=NEW.protected,
 	    deleted=NEW.deleted
 	WHERE workflow=OLD.workflow and protected=OLD.protected and deleted=OLD.deleted;
 	 	
CREATE OR REPLACE RULE v_workflow_del AS ON DELETE TO workflow
 	DO INSTEAD
	DELETE FROM confdb.workflow WHERE workflow=OLD.workflow and deleted=OLD.deleted and protected=OLD.protected;

-- eventsourceworkflow
CREATE OR REPLACE VIEW eventsourceworkflow as select * from confdb.eventsourceworkflow;
CREATE OR REPLACE RULE v_eventsourceworkflow_ins AS ON INSERT TO eventsourceworkflow
    DO INSTEAD 
    INSERT INTO confdb.eventsourceworkflow VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_eventsourceworkflow_upd AS ON UPDATE TO eventsourceworkflow
 	DO INSTEAD
 	UPDATE confdb.eventsourceworkflow
 	SET
 	    eventsource=NEW.eventsource,
 	    workflow=NEW.workflow
 	WHERE eventsource=OLD.eventsource and workflow=OLD.workflow;
 	 	
CREATE OR REPLACE RULE v_eventsourceworkflow_del AS ON DELETE TO eventsourceworkflow
 	DO INSTEAD
	DELETE FROM confdb.eventsourceworkflow WHERE eventsource=OLD.eventsource and workflow=OLD.workflow;

-- eventpolicy
CREATE OR REPLACE VIEW eventpolicy as select * from confdb.eventpolicy;
CREATE OR REPLACE RULE v_eventpolicy_ins AS ON INSERT TO eventpolicy
    DO INSTEAD 
    INSERT INTO confdb.eventpolicy VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_eventpolicy_upd AS ON UPDATE TO eventpolicy
 	DO INSTEAD
 	UPDATE confdb.eventpolicy
 	SET
 	    name=NEW.name,
 	    description=NEW.description,
 	    protected=NEW.protected
 	WHERE eventpolicy=OLD.eventpolicy and protected=OLD.protected;
 	 	
CREATE OR REPLACE RULE v_eventpolicy_del AS ON DELETE TO eventpolicy
 	DO INSTEAD
	DELETE FROM confdb.eventpolicy WHERE eventpolicy=OLD.eventpolicy and protected=OLD.protected;

ALTER VIEW eventpolicy ALTER COLUMN protected SET DEFAULT false;

-- eventpolicycontent
CREATE OR REPLACE VIEW eventpolicycontent as select * from confdb.eventpolicycontent;
CREATE OR REPLACE RULE v_eventpolicycontent_ins AS ON INSERT TO eventpolicycontent
    DO INSTEAD 
    INSERT INTO confdb.eventpolicycontent VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_eventpolicycontent_upd AS ON UPDATE TO eventpolicycontent
 	DO INSTEAD
 	UPDATE confdb.eventpolicycontent
 	SET
 	    workflow=NEW.workflow,
 	    infworkflow=NEW.infworkflow,
 	    parameters=NEW.parameters
 	WHERE eventpolicy=OLD.eventpolicy and eventsource=OLD.eventsource;
 	 	
CREATE OR REPLACE RULE v_eventpolicycontent_del AS ON DELETE TO eventpolicycontent
 	DO INSTEAD
	DELETE FROM confdb.eventpolicycontent 
	    WHERE eventpolicy=OLD.eventpolicy and eventsource=OLD.eventsource and workflow=OLD.workflow;

-- eventpolicystorage
CREATE OR REPLACE VIEW eventpolicystorage as select * from confdb.eventpolicystorage;
CREATE OR REPLACE RULE v_eventpolicystorage_ins AS ON INSERT TO eventpolicystorage
    DO INSTEAD 
    INSERT INTO confdb.eventpolicystorage VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_eventpolicystorage_upd AS ON UPDATE TO eventpolicystorage
 	DO INSTEAD
 	UPDATE confdb.eventpolicystorage
 	SET
 	    eventpriority=NEW.eventpriority,
 	    preserverhours=NEW.preserverhours
 	WHERE eventpolicy=OLD.eventpolicy and eventpriority=OLD.eventpriority;
 	 	
CREATE OR REPLACE RULE v_eventpolicystorage_del AS ON DELETE TO eventpolicystorage
 	DO INSTEAD
	DELETE FROM confdb.eventpolicystorage 
	    WHERE eventpolicy=OLD.eventpolicy and eventpriority=OLD.eventpriority;

-- password_history
CREATE OR REPLACE VIEW password_history as select * from confdb.password_history;
CREATE OR REPLACE RULE v_password_history_ins AS ON INSERT TO password_history
    DO INSTEAD 
    INSERT INTO confdb.password_history VALUES (NEW.*);
    
CREATE OR REPLACE RULE v_password_history_upd AS ON UPDATE TO password_history
 	DO INSTEAD
 	UPDATE confdb.password_history
 	SET
 	    password=NEW.password,
 	    changed=NEW.changed
 	WHERE userid=OLD.userid;
 	 	
CREATE OR REPLACE RULE v_password_history_del AS ON DELETE TO password_history
 	DO INSTEAD NOTHING;

ALTER VIEW password_history ALTER COLUMN changed SET DEFAULT timezone('UTC'::text, now());
ALTER VIEW password_history ALTER COLUMN expired SET DEFAULT 0;
