SET search_path TO public;

-- Move tables to confdb
ALTER SEQUENCE seq_obj SET SCHEMA confdb;
ALTER SEQUENCE seqBlockId SET SCHEMA confdb;
ALTER SEQUENCE dyna_data_seq SET SCHEMA confdb;
ALTER SEQUENCE sm_dblog_rid SET SCHEMA confdb;
ALTER SEQUENCE seq_event_emailer_snapshot SET SCHEMA confdb;

ALTER TABLE _obj_otypes SET SCHEMA confdb;
ALTER TABLE _obj_otype_subtype SET SCHEMA confdb;
ALTER TABLE _objs SET SCHEMA confdb;
ALTER TABLE _obj_attr SET SCHEMA confdb;
ALTER TABLE eventPriority SET SCHEMA confdb;
ALTER TABLE obj_block SET SCHEMA confdb;
ALTER TABLE dyna_types SET SCHEMA confdb;
ALTER TABLE dyna_data SET SCHEMA confdb;
ALTER TABLE permission_type SET SCHEMA confdb;
ALTER TABLE _link_types SET SCHEMA confdb;
ALTER TABLE _cred_types SET SCHEMA confdb;
ALTER TABLE _links SET SCHEMA confdb;
ALTER TABLE sm_nodes SET SCHEMA confdb;
ALTER TABLE sm_unused SET SCHEMA confdb;
ALTER TABLE sm_wheels SET SCHEMA confdb;
ALTER TABLE sm_cst SET SCHEMA confdb;
ALTER TABLE sm_ost SET SCHEMA confdb;
ALTER TABLE sm_stat SET SCHEMA confdb;
ALTER TABLE sm_dblog SET SCHEMA confdb;
ALTER TABLE sm_space SET SCHEMA confdb;
ALTER TABLE sm_space_spread SET SCHEMA confdb;
ALTER TABLE sm_cache SET SCHEMA confdb;
ALTER TABLE eventpropertydef SET SCHEMA confdb;
ALTER TABLE eventpolicy SET SCHEMA confdb;
ALTER TABLE workflow SET SCHEMA confdb;
ALTER TABLE eventsource SET SCHEMA confdb;
ALTER TABLE eventsourceworkflow SET SCHEMA confdb;
ALTER TABLE eventpolicycontent SET SCHEMA confdb;
ALTER TABLE eventlifespan SET SCHEMA confdb;
ALTER TABLE eventpolicystorage SET SCHEMA confdb;
ALTER TABLE eventtype SET SCHEMA confdb;
ALTER TABLE eventtag SET SCHEMA confdb;
ALTER TABLE eventstate SET SCHEMA confdb;
ALTER TABLE eventstatetag SET SCHEMA confdb;
ALTER TABLE storagertntype SET SCHEMA confdb;
ALTER TABLE storagepolicy SET SCHEMA confdb;
ALTER TABLE event_emailer_tag SET SCHEMA confdb;
ALTER TABLE event_emailer_snapshot SET SCHEMA confdb;
ALTER TABLE schedulelink SET SCHEMA confdb;
ALTER TABLE schedulehist SET SCHEMA confdb;
ALTER TABLE version_confdb SET SCHEMA confdb;
ALTER TABLE password_history SET SCHEMA confdb;

ALTER AGGREGATE concatfields(text) set schema apl;

ALTER FUNCTION updateUDID() SET SCHEMA confdb;
ALTER FUNCTION insertAttributes() SET SCHEMA confdb;
ALTER FUNCTION updateAttributes() SET SCHEMA confdb;
ALTER FUNCTION logg(varchar) SET SCHEMA confdb;
ALTER FUNCTION attr_archstate_on_of() SET SCHEMA confdb;
ALTER FUNCTION insert_link_type() SET SCHEMA confdb;
ALTER FUNCTION addMatrix() SET SCHEMA confdb;
ALTER FUNCTION set_cmd_stime() SET SCHEMA confdb;
ALTER FUNCTION set_stime() SET SCHEMA confdb;

ALTER FUNCTION getNodes() SET SCHEMA apl;
ALTER FUNCTION merge_obj_attr(objid INT, name VARCHAR, value VARCHAR) SET SCHEMA apl;
ALTER FUNCTION getObject(userobj integer, objectobj integer) SET SCHEMA apl;
ALTER FUNCTION getObjects(userobj integer, roleobj integer, objtype char(1), objsubtype char(1)) SET SCHEMA apl;
ALTER FUNCTION getObjects(userobj integer, roleobj integer, setobj integer, objtype char(1), objsubtype char(1)) SET SCHEMA apl;
ALTER FUNCTION getObjectsFromSet(setobj integer, otype char(1), subtype char(1)) SET SCHEMA apl;
ALTER FUNCTION getSetsFromRole(roleobj integer) SET SCHEMA apl;
ALTER FUNCTION getObjectsFromRole(roleobj integer, otype char(1), subtype char(1)) SET SCHEMA apl;
ALTER FUNCTION getUsers() SET SCHEMA apl;
ALTER FUNCTION getUsers(roleobj integer) SET SCHEMA apl;
ALTER FUNCTION getSets() SET SCHEMA apl;
ALTER FUNCTION getSets(objectobj integer) SET SCHEMA apl;
ALTER FUNCTION getSets(userobj integer, roleobj integer, objectobj integer) SET SCHEMA apl;
ALTER FUNCTION getRoles() SET SCHEMA apl;
ALTER FUNCTION getRoles(userobj integer) SET SCHEMA apl;
ALTER FUNCTION getRolesForSet(setobj integer) SET SCHEMA apl;

ALTER TYPE node_list SET SCHEMA apl;
ALTER TYPE object_list_with_credentials SET SCHEMA apl;
ALTER TYPE object_list_without_credentials SET SCHEMA apl;
ALTER TYPE object_list SET SCHEMA apl;
