set search_path to public;

-- remove unused column
ALTER TABLE _objs DROP COLUMN node_alt_ip;

-- setup passwords for predefined users
INSERT INTO password_history(userid, password) VALUES(21, '{"sha512": "734c883fb55e212cfe7a48ba6e2a33ff2f7ed275be04aeff6ea228ee6a2ac885ac4dd962a7bafe3514cd0f7cda7163d467b5652e7e1de7fd74a1a12b74b2ee64"}');

-- clear all passwords from _obj_attr table for all users
UPDATE _obj_attr SET val = '' WHERE attr = 'PASSWORD';

-- remove predefined guard user
DELETE FROM _obj_attr WHERE obj = 22;
DELETE FROM password_history WHERE userid = 22;
DELETE FROM _objs WHERE obj = 22;

-- correct procedures for not changing case of UDID attributes
-- write attr from _obj_attr to _objs on insert
CREATE OR REPLACE FUNCTION insertAttributes() RETURNS TRIGGER AS $$
BEGIN
    if NEW.attr = 'OBJID' then
        NEW.val = NEW.obj;
    end if;
    if NEW.attr = 'DEVID' then
        SELECT INTO NEW.val lower(subtype) || obj
            FROM _objs
            WHERE obj = NEW.obj AND otype='D' AND subtype NOT IN ('C','L','N');
        if NOT FOUND then
            NEW.val = NEW.obj;
        end if;
    end if;
    if NEW.attr = 'NAME' then
        UPDATE _objs
            SET name = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'LOCATION' then
        UPDATE _objs
            SET location = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'DESCRIPTION' then
        UPDATE _objs
            SET description = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'UDID' then
        if NEW.val = '' then
            SELECT udid INTO NEW.val FROM _objs WHERE obj = NEW.obj;
        else
            UPDATE _objs
                SET udid = NEW.val
                WHERE obj = NEW.obj;
        end if;
    end if;
    NEW.val = COALESCE(NEW.val,'');
    return NEW;
END;
$$ LANGUAGE plpgsql;

-- write attr from _obj_attr to _objs on update
CREATE OR REPLACE FUNCTION updateAttributes() RETURNS TRIGGER AS $$
BEGIN
    if NEW.attr = 'NAME' then
        UPDATE _objs
            SET name = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'LOCATION' then
        UPDATE _objs
            SET location = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'DESCRIPTION' then
        UPDATE _objs
            SET description = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'UDID' then
        UPDATE _objs
            SET udid = NEW.val
            WHERE obj = NEW.obj;
    end if;
    NEW.val = COALESCE(NEW.val,'');
    return NEW;
END;
$$ LANGUAGE plpgsql;
