INSERT INTO _obj_otype_subtype(otype, subtype, name, template, defaultsetobj) VALUES ('M', 'V', 'Viewpoint location', 'location', null);

-- changes for Avatar support
INSERT INTO _obj_otypes VALUES ('V', 'Avatar');
INSERT INTO _obj_otype_subtype(otype, subtype, name, template, defaultsetobj) VALUES ('V', '*', 'Avatar', 'avatar', null);

 -- get node list ordered by number of cameras on it
CREATE TYPE node_list AS (obj integer, location varchar, UNI varchar, number_of_cameras integer);
CREATE OR REPLACE FUNCTION getNodes() RETURNS SETOF node_list AS $$
DECLARE
   result node_list;
BEGIN
    FOR result in
        (SELECT
            node.obj, node.location, node.name as UNI, count(*) as camera_number
        FROM
            _objs as node,
            _objs as camera
        WHERE
            node.otype='D'
            AND node.subtype='N'
            AND node.deleted=0
            AND camera.otype='D'
            AND camera.subtype='C'
            AND camera.deleted=0
            AND node.name = camera.node_ip
        GROUP BY node.obj, node.location, node.name)
        UNION ALL
        (SELECT
            node.obj, node.location, node.name as UNI, 0
        FROM
            _objs as node
        WHERE
            otype='D'
            AND subtype='N'
            AND deleted=0
            AND name NOT IN (SELECT node_ip FROM _objs WHERE otype='D' AND subtype='C' AND deleted=0)
        GROUP BY node.obj, node.location, node.name)
        ORDER BY camera_number ASC
    LOOP
        RETURN NEXT result;
    END LOOP;

    RETURN;
END
$$ LANGUAGE 'plpgsql';
