
-- CIRRUS_REMOVE_BEGIN

--
-- Analytic workflow with merge
--

INSERT INTO workflow (workflow, protected, name,description,context)
VALUES (7, true, 'Analytic workflow' ,'Analytic workflow with merge with event merge' ,
'<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow"> 
  <state id="empty">
    <transition event="create" target="yellow" cond="property.confidence &lt; 1" lib="elog_actions"/>
    <transition event="create" target="red"/>
  </state>

  <state id="red">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Red" tags="4,5,7,11"/>
      </data>
    </datamodel>
    <onentry>
      <assign location="property.BGCOLOR" expr="FF0000" lib="elog_actions"/>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>
    <transition event="update" target="yellow" cond="property.confidence &lt; 1" lib="elog_actions"/>
    <transition event="update" target="red"/>
    <transition event="clear" target="cleared"/>
  </state>

  <state id="yellow">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Yellow" tags="4,5,7"/>
      </data>
    </datamodel>
    <onentry>
      <assign location="property.BGCOLOR" expr="FFFF00" lib="elog_actions"/>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>
    <transition event="update" target="yellow" cond="property.confidence &lt; 1" lib="elog_actions"/>
    <transition event="update" target="red"/>
    <transition event="clear" target="cleared"/>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,5,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <assign location="property.BGCOLOR" expr="FFFFFF" lib="elog_actions"/>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <transition event="update" target="cleared"/>
  </state>
</scxml>
');

INSERT INTO eventsourceworkflow (workflow, eventsource) VALUES (7, 6);

INSERT INTO eventstate (eventstate, workflow, name, description, actions) VALUES (17, 7, 'red', 'Red', null);
INSERT INTO eventstatetag (eventstate, eventtag) VALUES (17, 4), (17,5), (17,7), (17,11);

INSERT INTO eventstate (eventstate, workflow, name, description, actions) VALUES (18, 7, 'yellow', 'Yellow', null);
INSERT INTO eventstatetag (eventstate, eventtag) VALUES (18, 4), (18,5), (18,7);

INSERT INTO eventstate (eventstate, workflow, name, description, actions) VALUES (19, 7, 'cleared', 'Cleared', null);
INSERT INTO eventstatetag (eventstate, eventtag) VALUES (19, 4), (19,5), (19,8), (19,9);


UPDATE eventpolicycontent SET workflow=7 WHERE eventpolicy=1 AND eventsource=6;


-- CIRRUS_REMOVE_END
